#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <limits.h>

#include "util.h"


/**************************************************************** Prototypes */


/******************************************************************** Bodies */




/*****************************************************************************\
*                                                                             *
* Stack                                                                       *
*                                                                             *
\*****************************************************************************/

/* ODOT...
 */
Stack *
sCreate(void (*printFunc) ())
{
    static number = 0;
    Stack *ps;

    ps = UNew(Stack);
    ps->number = number++;
    ps->nbe = 0;
    ps->sz = 0;
    ps->ea = NULL;
    ps->printFunc = printFunc;
    return ps;
}

/* ODOT...
 */
void
sFree(Stack * ps)
{
    free(ps->ea);
    free(ps);
}

/* ODOT...
 */
void
sPrint(Stack * ps)
{
    int i, nbe;

    nbe = ps->nbe;
    printf("Stack (%d): |", ps->number);
    for (i = 0; i < nbe; i++) {
	ps->printFunc(ps->ea[i]);
	printf("|");
    }
}

/* ODOT...
 */
Bools
sIsEmpty(Stack * ps)
{
    return (ps->nbe == 0) ? True : False;
}

/* ODOT...
 */
void *
sPop(Stack * ps)
{
    if (ps->nbe > 0) {
	ps->nbe--;
	return ps->ea[ps->nbe];
    }
    else
	return NULL;
}

/* ODOT...
 */
void
sPush(Stack * ps, void *pe)
{
    ps->nbe++;
    if (ps->nbe > ps->sz) {
	if (ps->ea == NULL) {
	    ps->sz = STACK_CHKSZ;
	    ps->ea = (void **) UMallocMsg(ps->sz * sizeof(void *), "Stack allocation ");
	}
	else {
	    ps->sz += STACK_CHKSZ;
	    ps->ea = (void **) UReallocMsg(ps->ea, ps->sz * sizeof(void *), "Stack enlargment ");
	}
    }
    ps->ea[ps->nbe - 1] = pe;
}

/* ODOT...
 */
void *
sLook(Stack * ps)
{
    return ps->ea[ps->nbe - 1];
}
