#ifndef SASSOCT_H
#define SASSOCT_H


/* Assoc Table */

typedef struct AssocList {
    void *key;				/* pointer on the key */
    void *pe;				/* pointer on the associated element */
    struct AssocList *next;
}         AssocList;

typedef struct AssocListHeader {
    AssocList *l;
    int lsz;
}

                AssocListHeader;

typedef struct AssocTable {
    int number;				/* a kind of id... useful for debug */
    int size;				/* assoc table size */
    int nbe;				/* NumBer of Elements */
    Bools modified;			/* for acces optimization */
    int lastAskedn;			/* ie */
    int lastATInd;			/* ie */
    int lastEltCount;			/* ie */
    int (*ordFunc) ();			/* to order keys  */
    int (*hashFunc) ();			/* to hash key */
    void (*freeKeyFunc) ();		/* to free key */
    void (*freeEltFunc) ();		/* to free user element */
    void (*printKeyFunc) ();		/* to print key */
    void (*printEltFunc) ();		/* to print user element */
    AssocListHeader *hla;		/* Assoc List Array */
}

           AssocTable;


/**************************************************************** Prototypes */


/* ODOT...
 */
AssocTable *
           atCreate(int size, int (*hashFunc) (), int (*orderFunc) (), void (*freeKeyFunc) (), void (*freeEltFunc) (), void (*printKeyFunc) (), void (*printEltFunc) ());

/* ODOT...
 */
void
     atFree(AssocTable * pat, Bools freeElt);

/* ODOT...
 */
void
     atPrint(AssocTable * pat);

/* ODOT...
 */
void *
     atSearch(AssocTable * pat, void *key);

/* See description section */
void
     atInsert(AssocTable * pat, void *key, void *pe, Bools doFree);

/* ODOT...
 */
void
     atDel(AssocTable * pat, void *key, Bools doFree);

/* ODOT...
 */
int
    atNbElts(AssocTable * pat);

/* is used to return corresponding
	      key. */
void *
     atLookNth(AssocTable * pat, int n, void **pkey);

/************************************************************ End Prototypes */



#endif					/* SASSOCT_H */
