#ifndef MISC_H
#define MISC_H
#include <sys/types.h>
#include <sys/time.h>
#include <sys/timeb.h>

#define UDUMP_HEX 0
#define UDUMP_ASC 1
#define UDUMP_RAW 2
#define UDUMP_ASC_OR_DEC 3


typedef struct Chrono {
    struct timeval start;
}      Chrono;


/**************************************************************** Prototypes */


/* Like std select but restart if interrupted
 */
int
    URestartSelect(int width, fd_set * readfds, fd_set * writefds, fd_set * exceptfds, struct timeval * timeout);

/* Delay in microseconds */
int
    UUsleep(long usec);

/* ODOT...
 */
int
    UIntBigEndianEnc(int toEnc);

/* ODOT...
 */
int
    UIntBigEndianDec(int toDec);

/* Convert a byte into a string reflecting it's bit pattern.
 * For other types just change char into the desired type
 * (don't work with types with size > sizeof(long)).
 */
char *
     UCharToBit(char w);

/* Convert an int into a string reflecting it's bit pattern
 */
char *
     UIntToBit(int w);

/* is a string containing:x->
					 * execute, r-> read, w-> write, d->
	       directory */
Bools
UFileExist(char *n, char *p);

/* Dump memory.
 *
 * Return: a string (caller must free it after use)
 */
char *
     UDumpMem(char *pMem, int len, char mod);

/* Create (start) a new chrono.
 *
 * It is set to zero.
 *
 * Return: chrono
 */
Chrono *
       UChronoCreate(void);

/* Restart chrono.
 *
 * Reset to zero.
 */
void
     UChronoRestart(Chrono * pc);

/* Get elapsed time since last start (or restart).
 *
 * Return: number of milliseconds elapsed.
 *
 * Warning: be aware of overfull (time may exceed capacity of a long)
 */
long
     UChronoGet(Chrono * pc);

void
     UIndent(char *com);

/* concat a dirname and a basename in dst
 * dst is allocated by caller
 * try to be clever:
 * - add a  if needed t
 * dev + null -> devnull
 * - don't concat if basename start with /
 * dev + null -> null
 */
void
     UConcatPath(char *dst, char *dirname, char *basename);

/* ODOT ...
 */
int
    UOpenPath(List * lPath, char *fileName, int flag);

/************************************************************ End Prototypes */


#endif					/* MISC_H */
