#ifndef ERROR_H
#define ERROR_H

#define NO_EXIT

extern long UTraceLevel;

#define TRACE_UCOMM 1L<<0
#define TRACE_URESERVED 1L<<8

#ifdef DEBUG
#define UTraceSetLevel(level) UTraceLevel|=(level)
#define UTraceUnsetLevel(level) UTraceLevel&=~level;
#define UTraceZeroLevel(level) UtraceLevel=0L;
#define UTrace(level,args) if(UTraceLevel&(level)){printf args;}
#else
#define UTraceSetLevel(level)
#define UTraceUnsetLevel(level)
#define UTraceZeroLevel(level)
#define UTrace(level,args)
#endif


/**************************************************************** Prototypes */


/* A wrapper for exit.
 * If NO_EXIT is defined any call to UExit is fatal...
 * segmentation fault (core dumped)!!
 * Useful when debuginig.
 */
void
     UExit(int status);

/* Example:  UIWarning should be called like:
 * UIWarning(function_name, format, arg1, arg2...);
 * the format string is like this used by printf
 * UIWarning("CheckedMalloc", "can't allocate %d bytes, %d allocated"
 *           ,size, allocatedSize);
 */
void
     UIWarning(char *funcName, char *format,...);

/* Example: UIError should be called like:
 * UIError(function_name, format, arg1, arg2...);
 * the format string is like this used by printf
 * UIError("CheckedMalloc", "can't allocate %d bytes, %d allocated"
 *         ,size, allocatedSize);
 */
void
     UIError(char *funcName, char *format,...);

/* Given a open-file-error-number build the error message string
 */
char *
     UOpenError(int err, char *f);

/************************************************************ End Prototypes */

#endif					/* ERROR_H */
