#ifndef XMISC_H
#define XMISC_H

#include <X11/Xlib.h>

/**************************************************************** Prototypes */


/* Convert a XEvent.type to its human readable form
 *
 * Return: the string corresponding to the type or "Unknown XEvent Type"
 */
char *
     UXEventTypeToString(int type);

/* Compute rgb distance between two colors.
 */
int
    UXRGBDist(XColor * c1, XColor * c2);

/* Create a GC with fore and bacground inverted.
 */
GC
UXInvertGc(Display * dpy, Drawable d, GC srcGc);

/* Find the nearest color in the default colormap of screen.
 */
int
    UXFindNearestColor(Display * dpy, XColor * colRef, int *dist);

/* ODOT...
 */
void
     UXReduce4Ximage(Display * dpy, XImage * srci, XImage * desti, int ulx, int uly, int w, int h, int *greyMap);

/* Draw a bezier curve given 4 control points.
 */
void
     UXDrawBezier(Display * dpy, Drawable d, GC gc, int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3);

/************************************************************ End Prototypes */

#endif					/* XMISC_H */
