#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <limits.h>

#include "util.h"


/**************************************************************** Prototypes */


/******************************************************************** Bodies */



/*****************************************************************************\
*                                                                             *
* some predefined functions useful for hash, list, tree, ...                  *
*                                                                             *
\*****************************************************************************/

/* Do nothing... usefull when a function pointer is needed */
void
nullFunc()
{
}

/* ODOT...
 */
int
hashString(char *str, int sz)
{
    /* ?? search a better hash function */
    if (str == (char *) NULL)
	UIError("hashStringFunc", "NULL string");
    return str[0] % sz;
}

/* ODOT...
 */
int
hashInt(int *i, int sz)
{
    /* ?? search a better hash function */
    return abs((*i * 9973) % sz);
}

/* ODOT...
 */
int
hashVoid(void *p, int sz)
{
    /* ?? search a better hash function */
    return abs(((unsigned long) p * 9973) % sz);
}

/* ODOT...
 */
int
ordString(char *s1, char *s2)
{
    return strcmp(s1, s2);
}


/* ODOT...
 */
int
ordInt(int *a, int *b)
{
    return (*a > *b) ? 1 : (*a == *b) ? 0 : -1;
}

/* ODOT...
 */
int
ordVoid(void *a, void *b)
{
    return (a > b) ? 1 : (a == b) ? 0 : -1;
}

/* ODOT...
 */
void
printString(char *pe)
{
    puts(pe);
}

/* ODOT...
 */
void
printInt(int *pe)
{
    printf("%d", *pe);
}

/* ODOT...
 */
void
printVoid(void *pe)
{
    printf("(void*)%x", (unsigned long) pe);
}

/* ODOT...
 */
void *
keySame(void *pe)
{
    return pe;
}

/* ODOT...
 */
void *
keyVoid(void *pe)
{
    return pe;
}
