#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <limits.h>

#include "util.h"


/**************************************************************** Prototypes */

/* ODOT...
 */
static void
     tFreeSons(TreeNode * ptn, Bools freeElt);

/* ODOT...
 */
static void
     tAddSon(TreeNode * ptnf, TreeNode * ptn);

/* ODOT...
 */
static List *
     tbfb(TreeNode * ptn, List * pl);

/* ODOT...
 */
static List *
     tdfb(TreeNode * ptn, List * pl);

/* ODOT...
 */
static void
     tPrintAux(TreeNode * ptn);

/******************************************************************** Bodies */




/*****************************************************************************\
*                                                                             *
* Tree                                                                        *
*                                                                             *
\*****************************************************************************/

/* ODOT...
 */
Tree *
     tCreate(void *(*keyFunc) (), int (*orderFunc) (), void (*freeFunc) (),
	     void (*printFunc) ())
{
    Tree *pt;

    if ((keyFunc == NULL) || (orderFunc == NULL) || (freeFunc == NULL))
	UIError("createTree", "bad parameters");
    pt = UNew(Tree);
    pt->nbn = 0;
    pt->keyFunc = keyFunc;
    pt->ordFunc = orderFunc;
    pt->freeFunc = freeFunc;
    if (printFunc == NULL)
	printFunc = printVoid;
    pt->printFunc = printFunc;
    pt->root = NULL;
    return pt;
}

/* ODOT...
 */
static void
tFreeSons(TreeNode * ptn, Bools freeElt)
{
    int i;

    if (ptn == NULL)
	return;
    for (i = 0; i < ptn->nbs; i++)
	tFreeSons(ptn->sa[i], freeElt);
    if (freeElt)
	(*(ptn->pt->freeFunc)) (ptn->pe);
    free(ptn->sa);
    free(ptn);
}

/* ODOT...
 */
void
tFree(Tree * pt, Bools freeElt)
{
    tFreeSons(pt->root, freeElt);
    free(pt);
}

/* ODOT...
 */
static void
tAddSon(TreeNode * ptnf, TreeNode * ptn)
{
    if ((ptnf->nbs % TREESA_CHKSZ) == 0) {
	if (ptnf->sa == NULL)
	    ptnf->sa = (TreeNode **) UMalloc(TREESA_CHKSZ * sizeof(TreeNode *));
	else
	    ptnf->sa = (TreeNode **) URealloc(ptnf->sa, (ptnf->nbs + TREESA_CHKSZ) * sizeof(TreeNode *));
    }
    ptnf->sa[ptnf->nbs] = ptn;
    ptnf->nbs++;
}

/* ODOT...
 */
TreeNode *
tAddNode(Tree * pt, TreeNode * ptnf, void *pe)
{
    TreeNode *ptn;

    if ((ptnf != NULL) && (pt != ptnf->pt))
	UIError("tAddNode", " mismatched tree and treeNode");
    ptn = (TreeNode *) UMallocMsg(sizeof(TreeNode), "alloc a new tree node");
    ptn->pe = pe;
    ptn->flag = 0;
    ptn->nbs = 0;
    ptn->sa = NULL;
    ptn->pt = pt;
    if ((ptnf == NULL) && (pt->root != NULL))
	UIError("tAddNode", "already a root for this tree!");
    if (pt->root == NULL)
	pt->root = ptn;
    else
	tAddSon(ptnf, ptn);
    pt->nbn++;
    return ptn;
}

/* ODOT...
 */
int
tNbSons(TreeNode * ptn)
{
    return ptn->nbs;
}

/* ODOT...
 */
static List *
tbfb(TreeNode * ptn, List * pl)
{
    int i;

    for (i = 0; i < ptn->nbs; i++) {
	lAdd(pl, ptn->sa[i]->pe);
    }
    for (i = 0; i < ptn->nbs; i++) {
	tbfb(ptn->sa[i], pl);
    }
    return pl;
}

/* ODOT...
 */
List *
tBreadthFirst(Tree * pt)
{
    List *pl;

    pl = lCreate(pt->keyFunc, pt->ordFunc, pt->freeFunc, pt->printFunc);
    if (pt->root == NULL)
	return pl;
    lAdd(pl, pt->root->pe);
    pl = tbfb(pt->root, pl);
    lReverse(pl);
    return pl;
}

/* ODOT...
 */
static List *
tdfb(TreeNode * ptn, List * pl)
{
    int i;

    for (i = 0; i < ptn->nbs; i++) {
	tdfb(ptn->sa[i], pl);
    }
    lAdd(pl, ptn->pe);
    return pl;
}

/* ODOT...
 */
List *
tDephtFirst(Tree * pt)
{
    List *pl;

    pl = lCreate(pt->keyFunc, pt->ordFunc, pt->freeFunc, pt->printFunc);
    if (pt->root == NULL)
	return pl;
    pl = tdfb(pt->root, pl);
    lReverse(pl);
    return pl;
}

/* ODOT...
 */
static void
tPrintAux(TreeNode * ptn)
{
    static int indent = 0;
    int i;

    for (i = 0; i < indent; i++)
	putchar(' ');
    indent += 3;
    (*(ptn->pt->printFunc)) (ptn->pe);
    putchar('\n');
    for (i = 0; i < ptn->nbs; i++)
	tPrintAux(ptn->sa[i]);
    indent -= 3;
}

/* ODOT...
 */
void
tPrint(Tree * pt)
{
    tPrintAux(pt->root);
}
