#ifndef SQUEUE_H
#define SQUEUE_H


/* Queue */

typedef struct Queue {
    int number;				/* a kind of id... useful for debug */
    int nbe;				/* number of elements of this queue */
    int sz;				/* actual maximum size  " */
    int ihead;				/* the oldest element of the queue */
    int iend;				/* the newest " */
    int firstNull;			/* the first Null element (cf
					 * QNull()) */
    void **ea;				/* the queue (warning cyclic storage) */
    /* growing form left to right */
    void (*printFunc) ();		/* to print user element */

}

      Queue;

/**************************************************************** Prototypes */


/* ODOT...
 */
Queue *
      qCreate(void (*printFunc) ());

/* ODOT...
 */
void
     qFree(Queue * pq);

/* ODOT...
 */
void
     qPrint(Queue * pq);

/* Add an element at the end of this queue.
 */
void
     qAdd(Queue * pq, void *pe);

/* Return: Return (and remove) the first element of this queue.
 */
void *
     qGet(Queue * pq);

/* Del the first nb elements of this queue.
 */
void
     qDel(Queue * pq, int nb, void (*freeFunc) ());

/* Return: Return (but don't remove the first element of this queue.
 */
void *
     qLook(Queue * pq);

/* Return: Return (but don't remove the nth element of this queue.
 */
void *
     qLookNth(Queue * pq, int nb);

/* Not tested */
void
     qShift(Queue * pq, int start, int shift);

int
    qNbElts(Queue * pq);

/* TODO must free*/
void
     qDelNth(Queue * pq, int nb);

/* Remove holes from the queue (an hole may result from a qDelNth).
 */
void
     qCompactNull(Queue * pq);

/************************************************************ End Prototypes */



#endif					/* SQUEUE_H */
