#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <limits.h>

#include "util.h"


/**************************************************************** Prototypes */

/* ODOT...
 */
static int
    qPos(Queue * pq, int pos);

/******************************************************************** Bodies */



/*****************************************************************************\
*                                                                             *
* Queue                                                                       *
*                                                                             *
\*****************************************************************************/

/* ODOT...
 */
Queue *
qCreate(void (*printFunc) ())
{
    static number = 0;
    Queue *pq;

    pq = UNew(Queue);
    pq->number = number++;
    pq->nbe = 0;
    pq->sz = QUEUE_STARTSZ;
    pq->ea = (void **) UCalloc(pq->sz, sizeof(void *));

    pq->iend = 0;
    pq->ihead = 0;
    pq->firstNull = INT_MAX;
    pq->printFunc = printFunc;
    return pq;
}

/* ODOT...
 */
void
qFree(Queue * pq)
{
    free(pq->ea);
    free(pq);
}

/* ODOT...
 */
void
qPrint(Queue * pq)
{
    int i, nbe;

    nbe = pq->nbe;
    printf("Queue (%d): |", pq->number);
    for (i = 0; i < nbe; i++) {
	pq->printFunc(qLookNth(pq, i));
	printf("|");
    }
}

/* ODOT...
 */
static int
qPos(Queue * pq, int pos)
{
    int np;

    np = pos + pq->ihead;
    if (np > pq->sz)
	return np - pq->sz;
    else if (np < 0)
	return np + pq->sz;
    else
	return np;
}

/* Add an element at the end of this queue.
 */
void
qAdd(Queue * pq, void *pe)
{
    void **eatmp;

    if (pq->nbe == pq->sz) {
	pq->sz = (float) pq->sz * QUEUE_MULTSZ + 1;
	if (pq->iend > pq->ihead)
	    pq->ea = (void **) UReallocMsg(pq->ea, pq->sz * sizeof(void *), "Queue can't grow");

	else {
	    eatmp = (void **) UMallocMsg(pq->sz * sizeof(void *), "Queue can't grow");
	    memcpy(eatmp, &pq->ea[pq->ihead], (pq->nbe - pq->ihead) * sizeof(void *));
	    memcpy(&eatmp[pq->nbe - pq->ihead], pq->ea, pq->ihead * sizeof(void *));

	    free(pq->ea);
	    pq->ea = eatmp;
	    pq->ihead = 0;
	    pq->iend = pq->nbe;
	}
    }
    pq->ea[pq->iend] = pe;
    pq->iend = (pq->iend + 1) % pq->sz;
    pq->nbe++;
}

/* Return: Return (and remove) the first element of this queue.
 */
void *
qGet(Queue * pq)
{
    void *pe;

    if (pq->nbe <= 0)
	return NULL;
    pe = pq->ea[pq->ihead];
    pq->ihead = (pq->ihead + 1) % pq->sz;
    pq->nbe--;
    return pe;
}


/* Del the first nb elements of this queue.
 */
void
qDel(Queue * pq, int nb, void (*freeFunc) ())
{
    int i;

    for (i = 0; i < nb; i++) {
	if (pq->nbe <= 0)
	    return;
	(*freeFunc) (pq->ea[pq->ihead]);
	pq->ihead = (pq->ihead + 1) % pq->sz;
	pq->nbe--;
    }
}

/* Return: Return (but don't remove the first element of this queue.
 */
void *
qLook(Queue * pq)
{
    return pq->ea[pq->ihead];
}

/* Return: Return (but don't remove the nth element of this queue.
 */
void *
qLookNth(Queue * pq, int nb)
{
    int ind;

    ind = (pq->ihead + nb) % pq->sz;
    return pq->ea[ind];
}

/* Not tested */
void
qShift(Queue * pq, int start, int shift)
{
    int i, id, is;

    if (shift > 0) {
	UIError("qShift", "for positive numbers (%d) not implemented\n", shift);
	exit(1);
    }
    if ((start + shift) < 0) {
	UIWarning("qShift", "loosing some values (%d) due to a too big shift\n", shift + start);
	start = -shift;
    }
    if (start > pq->nbe) {
	UIWarning("qShift", "shift has no effect, start to high (%d)\n", start);
    }
    for (i = start; i < pq->nbe; i++) {
	id = qPos(pq, i + shift);
	is = qPos(pq, i);
	pq->ea[id] = pq->ea[is];
    }
    pq->nbe += shift;
    pq->iend = qPos(pq, pq->nbe);
}


int
qNbElts(Queue * pq)
{
    return pq->nbe;
}

/* TODO must free*/
void
qDelNth(Queue * pq, int nb)
{
    pq->ea[qPos(pq, nb)] = NULL;
    if (pq->firstNull > nb)
	pq->firstNull = nb - 1;
}

/* Remove holes from the queue (an hole may result from a qDelNth).
 */
void
qCompactNull(Queue * pq)
{
    int ie, ic, nbe, i;

    if (pq->firstNull > pq->nbe)
	return;
    ie = ic = qPos(pq, pq->firstNull);
    nbe = pq->nbe;
    for (i = pq->firstNull; i < pq->nbe; i++) {
	if (pq->ea[ic]) {
	    if (ie != ic)		/* avoid useless copy */
		pq->ea[ie] = pq->ea[ic];
	    ie++;
	    if (ie >= pq->sz)
		ie = 0;
	}
	else {
	    nbe--;
	}
	ic++;
	if (ic >= pq->sz)
	    ic = 0;
    }
    pq->iend = ie;
    pq->nbe = nbe;
    pq->firstNull = INT_MAX;
}
