#ifndef SOGRAPH_H
#define SOGRAPH_H


/* Oriented Graph */

typedef struct OGNode {
    void *pe;				/* pointer on a user-element */
    int flag;
    int nbs;				/* NumBer of Successors */
    int nbp;				/* NumBer of Predecessors */
    struct OGNode **sa;			/* Successor Array */
    struct OGraph *pog;			/* to retrive (*funcs)() */
}      OGNode;

typedef struct OGraph {
    int es;				/* Estiamted Size for this graph */
    int nbn;				/* NumBer of Nodes */
    void *(*keyFunc) ();		/* to extract key from element */
    int (*ordFunc) ();			/* to order keys  */
    void (*freeFunc) ();		/* to free user element */
    int (*hashFunc) ();			/* to hash key */
    void (*printFunc) ();		/* to print user element */
    HashTable *ht;			/* for Node storage */
}

       OGraph;

/**************************************************************** Prototypes */


/* ODOT...
 */
OGraph *
       ogCreate(int orderOfSize, void *(*keyFunc) (), int (*orderFunc) (), void (*freeFunc) (), int (*hashFunc) (), void (*printFunc) ());

/* ODOT...
 */
void
     ogFree(OGraph * pog);

/* ODOT...
 */
void
     ogAddNode(OGraph * pog, void *pe);

/* Add an arc between node pa and pb (pa->pb).
 * Nodes are created if needed.
 */
void
     ogAddArc(OGraph * pog, void *pa, void *pb);

/* ODOT...
 */
Bools
ogCheckCycleAux(OGNode * pogn);

/* Does this oriented graph embed a cycle ?
 */
Bools
ogCheckCycle(OGraph * pog);

/* Find an order in an oriented graph.
 *
 * Return: the returned list is ordered from most prior to less prior
 * in the graph.
 *
 * Example:
 *   graph:   a-> b ->c     list:  a->b->c->d  or  a->d->b->c
 * \> d
 *
 * Warning: graph must not be cyclic
 */
List *
     ogFindOrder(OGraph * pog);

/* ODOT...
 */
Tree *
     ogFindTree(OGraph * pog);

/************************************************************ End Prototypes */



#endif					/* SOGRAPH_H */
