#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <limits.h>

#include "util.h"


/**************************************************************** Prototypes */


/******************************************************************** Bodies */




/*****************************************************************************\
*                                                                             *
* Assoc Table                                                                 *
*                                                                             *
\*****************************************************************************/

/* ODOT...
 */
AssocTable *
           atCreate(int size, int (*hashFunc) (), int (*orderFunc) (), void (*freeKeyFunc) (), void (*freeEltFunc) (), void (*printKeyFunc) (),
		    void (*printEltFunc) ())
{
    AssocTable *at;
    static number = 1;

    if ((hashFunc == NULL) || (orderFunc == NULL) ||
	(freeKeyFunc == NULL) || (freeEltFunc == NULL) ||
	(size <= 0))
	UIError("createAssocTable", "bad parameters");
    at = (AssocTable *) UMallocMsg(sizeof(AssocTable), "createAssocTable: ");
    at->size = size;
    at->nbe = 0;
    at->number = number++;
    at->modified = True;
    at->lastAskedn = -1;
    at->lastATInd = 0;
    at->lastEltCount = 0;
    at->hla = (AssocListHeader *) UCallocMsg(size, sizeof(AssocListHeader), "createAssocTable: ");
    at->ordFunc = orderFunc;
    at->freeKeyFunc = freeKeyFunc;
    at->freeEltFunc = freeEltFunc;
    at->hashFunc = hashFunc;
    if (printKeyFunc == NULL)
	at->printKeyFunc = printVoid;
    else
	at->printKeyFunc = printKeyFunc;
    if (printEltFunc == NULL)
	at->printEltFunc = printVoid;
    else
	at->printEltFunc = printEltFunc;

    return at;
}

/* ODOT...
 */
void
atFree(AssocTable * pat, Bools freeElt)
{
    int i;
    AssocList *hl, *hlb;

    for (i = 0; i < pat->size; i++) {
	hl = pat->hla[i].l;
	while (hl != NULL) {
	    if (freeElt) {
		(*pat->freeKeyFunc) (hl->key);
		(*pat->freeEltFunc) (hl->pe);
	    }
	    hlb = hl;
	    hl = hl->next;
	    free(hlb);
	}
    }
    free(pat->hla);
    free(pat);
}

/* ODOT...
 */
void
atPrint(AssocTable * pat)
{
    int nbelts, i;
    void *key, *pe;

    nbelts = atNbElts(pat);
    for (i = 0; i < nbelts; i++) {
	pe = atLookNth(pat, i, &key);
	pat->printKeyFunc(key);
	putchar(' ');
	pat->printEltFunc(pe);
    }
}

/* ODOT...
 */
void *
atSearch(AssocTable * pat, void *key)
{
    int hind;
    AssocList *hl;
    void *k1;

    hind = (*pat->hashFunc) (key, pat->size);
    hl = pat->hla[hind].l;
    while (hl != NULL) {
	if (((*pat->ordFunc) (hl->key, key)) == 0)
	    return hl->pe;
	hl = hl->next;
    }
    return NULL;
}

/* If an element has the same key than pe it's replaced with pe.
 * In this case key and element are freed or not depending on Bools (doFree)
 */
void
atInsert(AssocTable * pat /* The associated table */ ,
	 void *key /* The key */ ,
	 void *pe /* The pointed element */ ,
	 Bools doFree /* See description section */ )
{
    int hind;
    AssocList *hl;

    pat->modified = True;		/* ?? TODO maintain list sorted for
					 * fast access */
    hind = (*pat->hashFunc) (key, pat->size);
    if (atSearch(pat, key) == NULL) {
	hl = (AssocList *) UMallocMsg(sizeof(AssocList), "atInsert: ");
	hl->pe = pe;
	hl->key = key;
	hl->next = pat->hla[hind].l;
	pat->hla[hind].l = hl;
	pat->hla[hind].lsz++;
	pat->nbe++;
    }
    else {				/* ?? TODO: tobe optimized (modify
					 * structure in place) */
	atDel(pat, key, doFree);
	atInsert(pat, key, pe, doFree);
    }
}

/* ODOT...
 */
void
atDel(AssocTable * pat, void *key, Bools doFree)
{
    int hind;
    AssocList *hl, *hlp;
    void *k1;

    pat->modified = True;
    hind = (*pat->hashFunc) (key, pat->size);
    hl = pat->hla[hind].l;
    while (hl != NULL) {
	if (!(*pat->ordFunc) (hl->key, key)) {
	    if (hl == pat->hla[hind].l)
		pat->hla[hind].l = hl->next;
	    else
		hlp->next = hl->next;
	    if (doFree) {
		pat->freeKeyFunc(hl->key);
		pat->freeEltFunc(hl->pe);
	    }
	    free(hl);
	    pat->hla[hind].lsz--;
	    return;
	}
	hlp = hl;
	hl = hl->next;
    }
}

/* ODOT...
 */
int
atNbElts(AssocTable * pat)
{
    return pat->nbe;
}

/* Sequential access (like in loops) are specialy optimized to be in O(n)
 * and not in O(n2) (as far as you do access in increasing order) .
 * First element is 0
 *
 * Return: the nth element in assoctable.
 */
void *
atLookNth(AssocTable * pat,
	  int n,
	  void **pkey			/* is used to return corresponding
	      key. */ )
{
    AssocList *hl;
    int nbelt;
    int i;
    int atInd;


    if (n < 0)
	UIError("atLookNth", "bad element rank %d (<0)", n);
    if ((n >= pat->lastAskedn) && (pat->modified == False)) {
	nbelt = pat->lastEltCount;
	atInd = pat->lastATInd;
    }
    else {
	nbelt = 0;
	atInd = 0;
    }
    pat->modified = False;
    pat->lastAskedn = n;
    n++;				/* simpler code if first element is 1
					 * instead of 0 */
    for (i = atInd; i < pat->size; i++) {
	if (nbelt + pat->hla[i].lsz >= n) {
	    hl = pat->hla[i].l;
	    pat->lastEltCount = nbelt;
	    while (nbelt < n - 1) {
		nbelt++;
		hl = hl->next;
	    }
	    pat->lastATInd = i;
	    *pkey = hl->key;
	    return hl->pe;
	}
	nbelt += pat->hla[i].lsz;
    }
    UIError("atLookNth", "no element of this rank %d", n);
    return NULL;			/* not reached */
}
