#ifndef MATH3D_H
#define MATH3D_H


typedef struct Point3Struct {		/* 3d point */
    double x, y, z;
}

             Point3;
typedef Point3 Vector3;


typedef struct Matrix4Struct {		/* 4-by-4 matrix */
    double elt[4][4];			/* representation of matrix : line
					 * column */
}

              Matrix4;

typedef struct Box3dStruct {		/* 3d box */
    Point3 min, max;
}           Box3;


/**************************************************************** Prototypes */


/* ODOT...
 */
Point3 *
       V3FillPoint(Point3 * p, double x, double y, double z);

/* ODOT...
 */
Vector3 *
        V3FillVector(Vector3 * v, double x, double y, double z);

/* ODOT...
 */
Point3 *
       V3CopyPoint(Point3 * pin, Point3 * pout);

/* ODOT...
 */
Vector3 *
        V3CopyVector(Vector3 * vin, Vector3 * vout);

/* print vector pv1
 */
void
     V3PrintVector(Vector3 * pv1);

/* compare vectors pv1 and pv2
 * useful for debugging
 * return 1 if they are identical else return 0 and print difference
 */
int
    V3SameVector(Vector3 * pv1, Vector3 * pv2);

/* returns squared length of input vector */
double
       V3SquaredLength(Vector3 * a);

/* returns length of input vector */
double
       V3Length(Vector3 * a);

/* normalizes the input vector and returns it */
Vector3 *
        V3Normalize(Vector3 * v);

/* return vector sum c = a+b */
Vector3 *
        V3Add(Vector3 * a, Vector3 * b, Vector3 * c);

/* return vector difference c = a-b */
Vector3 *
        V3Sub(Vector3 * a, Vector3 * b, Vector3 * c);

/* multiply each component of v by d */
Vector3 *
        V3Scale(Vector3 * v, double d);

/* return the dot product of vectors a and b */
double
       V3Dot(Vector3 * a, Vector3 * b);

/* return the cross product c = a cross b */
Vector3 *
        V3Cross(Vector3 * a, Vector3 * b, Vector3 * c);

/* return a vector constructed with two points */
Vector3 *
        V3Points2Vector(Point3 * p1, Point3 * p2, Vector3 * v);

/* return the distance between two points */
double
       V3DistanceBetween2Points(Point3 * a, Point3 * b);

/* multiply a point by a matrix and return the transformed point */
Point3 *
       V3MulPointByMatrix(Point3 * pin, Matrix4 * m, Point3 * pout);

/* multiply a point by a projective matrix and return the transformed point */
Point3 *
       V3MulPointByProjMatrix(Point3 * pin, Matrix4 * m, Point3 * pout);

/* fill matrix mout with vectors c0 c1 c2 (used as columns)
 */
Matrix4 *
        V3VectorToMat(Vector3 * c0, Vector3 * c1, Vector3 * c2, Matrix4 * mout);

/* multiply together matrices c = ab
 * note that c must not point to either of the input matrices
 */
Matrix4 *
        V3MatMul(Matrix4 * a, Matrix4 * b, Matrix4 * c);

/* multiply together matrices c = a * bt
 * note that c must not point to either of the input matrices
 * useful for invers of orthogonal matrix
 */
Matrix4 *
        V3MatTransp2Mul(Matrix4 * a, Matrix4 * b, Matrix4 * c);

/* multiply together matrices c = at * b
 * note that c must not point to either of the input matrices
 * useful for invers of orthogonal matrix
 */
Matrix4 *
        V3MatTranspMul(Matrix4 * a, Matrix4 * b, Matrix4 * c);

/* multiply all element of matrix by d */
Matrix4 *
        V3MatNorm(Matrix4 * m, double d);

/* determinant of m */
double
       V3MatDet(Matrix4 * m);

/* return a nul matrix */
Matrix4 *
        V3MatNul(Matrix4 * m);

/* copy min in mout */
Matrix4 *
        V3MatCopy(Matrix4 * min, Matrix4 * mout);

/* place numbers on the diagonal line of the matrix */
Matrix4 *
        V3MatDiag(Matrix4 * m, double d0, double d1, double d2, double d3);

/* return id matrix */
Matrix4 *
        V3MatId(Matrix4 * m);

/* return a translate matrix */
Matrix4 *
        V3MatTranslate(Matrix4 * m, double deltaX, double deltaY, double deltaZ);

/*return a scale matrix */
Matrix4 *
        V3MatScale(Matrix4 * m, double scaleX, double scaleY, double scaleZ);

/* return a rotate matrix for the x coordinates */
Matrix4 *
        V3MatRotX(Matrix4 * m, double angle);

/* return a rotate matrix for the y coordinates */
Matrix4 *
        V3MatRotY(Matrix4 * m, double angle);

/* return a rotate matrix for the z coordinates */
Matrix4 *
        V3MatRotZ(Matrix4 * m, double angle);

/* return a shear rotate matrix */
Matrix4 *
        V3MatShearXY(Matrix4 * m, double shx, double shy);

/* return a perspective-projection matrix */
Matrix4 *
        V3MatPer(Matrix4 * m, double d);

/* return a clip matrix */
Matrix4 *
        V3MatClip(Matrix4 * m, double zm);

/* compute the rotation matrix rm given v1 and v2
 * v2=rm*v1
 */
Matrix4 *
        V3VectToRot(Vector3 * pv1, Vector3 * pv2, Matrix4 * rm);

/************************************************************ End Prototypes */




#endif					/* MATH3D_H */
