#ifndef MACRO_H
#define MACRO_H

/* maximum size of tmp strings used in these modules */
#define MAX_CHAR_TMP 1024

/* maximum lenght of a file name in characters */
#define MAX_FILE_LEN 256


#define KILO 1024
#define MEGA (KILO*KILO)

/* usefull during debug */
#ifdef DEBUG
#define IFDBG(c) c
#else
#define IFDBG(c)
#endif


/* return errno, or make core for debug */
#define URetErrno return errno
/*#define URetErrno MAKECORE*/



/* if including Xlib.h comment this to avoid redefinition for True and False */
/*#define DEFINE_BOOL*/
#ifdef DEFINE_BOOL
#ifndef True
#define True ((Bools) 1)
#endif
#ifndef False
#define False ((Bools) 0)
#endif
#endif
#define BoolNot(x) (((x)==True)?False:True)

#define Ok 0
#define Err 1

#define BoolsNot(x) (((x)==True)?False:True)


/* for 's' in strings like theres 2 byte's' and 1 word'' */
#define NBTOCS(n) (((n)>1)?'s':' ')
#define NBTOSS(n) (((n)>1)?"s":"")
/* for 'is' or 'are' */
#define NBTOSBE(n) (((n)>1)?" are":"'s")


/* to make a nice core dump */
#define MAKECORE {char*p=NULL; *p=1;}


/* when you build a new function and forget to fill it ;) think to put at least UNI (U Not Implemented) */

#define UNI    (UIError("__FILE__:__LINE__","not implemented"))
#define UNIW   (UIWarning("__FILE__:__LINE__","not implemented"))
/* bcopy, bzero and Co are non portable calls so replace them by mem family */
#ifndef bcopy
#define bcopy(source, dest, count) memcpy(dest, source, count)
#endif					/* bcopy */

#ifndef bzero
#define bzero(dest, count) memset(dest, 0, count)
#endif					/* bzero */

#ifndef bcmp
#define bcmp(source, dest, count) memcmp(source, dest, count)
#endif					/* bcmp */


#ifndef Min
#define Min(a,b) (((a)>(b))?(b):(a))
#endif
#ifndef Max
#define Max(a,b) (((a)<(b))?(b):(a))
#endif
#ifndef Abs
#define Abs(a)   (((a)>=0)?(a):-(a))
#endif


/* useful personnal macros */

#define UMin(a,b) (((a)>(b))?(b):(a))
#define UMax(a,b) (((a)<(b))?(b):(a))
#define UAbs(a)   (((a)>=0)?(a):-(a))
#define UForceNonZero(a,subst) (((a)!=0)?(a):(subst))

/* uh it seems to be a swap. isn't it? ;) */
/* eg: USwap(a,b,int) or Swap(v1,v2,vectorType) */
#define USwap(a,b,type) {type tmp; tmp=a;a=b;b=tmp;}

/* more compact notation */
/* eg: pv=UNew(vector*) is equal to pv=(vector*)malloc(sizeof(vector*)) */
#define UNew(t) ((t*) UMalloc(sizeof(t)))

#endif					/* MACRO_H */
