#include "util.h"

/**************************************************************** Prototypes */


/******************************************************************** Bodies */



/* Like the standard strdup function.
 *
 * Avantages on the stadard strdup function;
 * Don't crash if (s) is NULL (return NULL).
 * Test if allocation is succesful (if not generate an error message).
 */
char *
UStrDup(char *s)
{
    char *cs;

    if (s == NULL)
	return (char *) NULL;
    if ((cs = (char *) malloc((size_t) (sizeof(char) * (strlen(s) + 1)))) == (char *) NULL)
	UIError("UStrDup", "%s: for %d bytes", ER_NOMEM, s);

    return (char *) strcpy(cs, s);
}

/* Like the standard malloc function.
 *
 * Avantages on the standard malloc function;
 * Test if allocation is succesful (if not generate an error message).
 */
void *
UMalloc(size_t s)
{
    void *tmp;

    if (s == 0)
	s = 1;				/* to avoid crash on Dec Alpha */
    if ((tmp = (void *) malloc(s)) != (void *) NULL)
	return tmp;
    else {
	UIError("UMalloc", "%s: for %d bytes", ER_NOMEM, s);
	return NULL;
    }
}

/* Like UMalloc.
 */
void *
UMallocMsg(size_t s,
	   char *msg			/* Printed message if allocation
	       fails */ )
{
    void *tmp;

    if ((tmp = UMalloc(s)) != NULL)
	return tmp;
    else {
	UIError("UMallocMsg", "%s: for %d bytes: %s", ER_NOMEM, s, msg);
	return NULL;
    }
}

/* Like the standard realloc function.
 *
 * Avantages on the standard realloc function;
 * Test if old pointer is null (if it's the case make an alloc instead of a
 * realloc).
 * Test if allocation is succesful (if not generate an error message)
 */
void *
URealloc(void *oldPt, size_t s)
{
    void *tmp;

    if (s == 0)
	s = 1;				/* to avoid crash on Dec Alpha */
    if (oldPt) {
	if ((tmp = (void *) realloc(oldPt, s)) != (void *) NULL)
	    return tmp;
	else {
	    UIError("URealloc", "%s: for %d bytes", ER_NOMEM, s);
	    return NULL;
	}
    }
    else {				/* this pointer was nether allocated
					 * so it's a malloc instead of a
					 * realloc */
	return UMalloc(s);
    }
}

/* Like URealloc.
 */
void *
UReallocMsg(void *oldPt,
	    size_t s,
	    char *msg			/* Printed message if allocation
	        fails */ )
{
    void *tmp;

    if ((tmp = URealloc(oldPt, s)) != (void *) NULL)
	return tmp;
    else {
	UIError("UReallocMsg", "%s: for %d bytes: %s", ER_NOMEM, s, msg);
	return NULL;
    }
}

/* Like the standard calloc function
 *
 * Avantages on the standard realloc function;
 * Test if allocation is succesful (if not generate an error message)
 */
void *
UCalloc(int nbElt, int eltSz)
{
    void *tmp;

    if (!eltSz * nbElt) {
	eltSz = nbElt = 1;
    }
    if ((tmp = (void *) calloc(nbElt, eltSz)) != (void *) NULL)
	return tmp;
    else {
	UIError("UCalloc", "%s: for %d bytes (%d elements of %d bytes)", ER_NOMEM, nbElt * eltSz, nbElt, eltSz);
	return NULL;
    }
}

/* Like UCalloc.
 */
void *
UCallocMsg(int nbElt,
	   int eltSz,
	   char *msg			/* Printed message if allocation
	       fails */ )
{
    void *tmp;

    if ((tmp = UCalloc(nbElt, eltSz)) != (void *) NULL)
	return tmp;
    else {
	UIError("UCallocMsg", "%s: for %d bytes (%d elements of %d bytes): %s", ER_NOMEM, nbElt * eltSz, nbElt, eltSz, msg);
	return NULL;
    }
}


/* Like the standard free function.
 *
 * Avantages on the standard realloc function;
 * Check if non NULL pointer
 */
void
UFree(void *p)
{
    if (p)
	free(p);
}
