/*
 * QuickThreads -- Threads-building toolkit.
 * Copyright (c) 1993 by David Keppel
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice and this notice
 * appear in all copies.  This software is provided as a
 * proof-of-concept and for demonstration purposes; there is no
 * representation about the suitability of this software for any
 * purpose.
 */

#include <stdarg.h>
#include "qt.h"


/* Varargs is harder on the AXP.  Parameters are saved on the stack as
   something like (stack grows down to low memory; low at bottom of
   picture):

	|  :
	| arg6
	+---
	| iarg5
	|  :
	| iarg3		<-- va_list.a0 + va_list.offset
	|  :
	| iarg0		<-- va_list.a0
	+---
	| farg5
	|  :
	| farg0
	+---

   When some of the arguments have known type, there is no need to
   save all of them in the struct.  So, for example, if the routine is
   called

	zork (int a0, float a1, int a2, ...)
	{
	  va_list ap;
	  va_start (ap, a2);
	  qt_vargs (... &ap ...);
	}

   then offset is set to 3 * 8 (8 === sizeof machine word) = 24.

   What this means for us is that the user's routine needs to be
   called with an arg list where some of the words in the `any type'
   parameter list have to be split and moved up in to the int/fp
   region.

   Ways in which this can fail:
    - The user might not know the size of the pushed arguments anyway.
    - Structures have funny promotion rules.
    - Probably lots of other things.

   All in all, we never promised varargs would work reliably. */



#define QT_VADJ(sp)	(((char *)sp) - QT_VSTKBASE)

#define QT_VARGS_MD0(sp, vabytes) \
   ((qt_t *)(((char *)(sp)) - 6*2*8 - QT_STKROUNDUP(vabytes)))

extern void qt_vstart(void);
#define QT_VARGS_MD1(sp)	(QT_SPUT (sp, QT_R26, qt_vstart))



  struct qt_t *
qt_vargs (struct qt_t *qsp, int nbytes, struct va_list *vargs,
	  void *pt, qt_function_t *startup,
	  qt_function_t *vuserf, qt_function_t *cleanup)
{
}


