/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT**/
/****************************\
* 			     *
*  Lex generator for Klone   *
* 			     *
\****************************/

%{

#include "y.tab.h"

/* #define KLCRYPT */

/* to have always at least MAX_TOKEN_LENGTH chars in all lexes */
#undef YYLMAX
#define YYLMAX MAX_TOKEN_LENGTH

/* here goes the definition of lex I/O, as macros for efficiency */

/* first, we forget the previous definitions, */
#undef input
#undef unput
/* which were :
#define output(c) putc(c,yyout)
#define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):\
getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;\
*yysptr++=yytchar;}
*/

/* So here are our macros 
 * we cache KlStdyy streams into yyin, KlyyinIsString, Klyystrin global vars
 * for efficiency (reporting load on context switch)
 */

int KlyyinIsString;	/* 0 ==> reading from STREAM yyin */
				/* 1 ==> reading from STRING Klyystrin */
char *Klyystrin;		/* current pointer on input string */

#define input() (((\
    	yytchar =\
        (yysptr>yysbuf ?\
	    U(*--yysptr)\
	:   (KlyyinIsString ?\
	        ( *Klyystrin ? *Klyystrin++ : 4)\
	    :   getc(yyin))))\
	==10 ?\
	    (yylineno++,yytchar)\
	:   yytchar)\
    ==EOF ?\
        4\
    :   yytchar)

#define unput(c) {\
    yytchar= (c);\
    if(yytchar=='\n')\
        yylineno--;\
    *yysptr++=yytchar;\
}

/* externally callable function for unput:
 */

KlUnput(buffer)
char *buffer;
{
    while (*buffer) {
	unput(*buffer);
	buffer++;
    }
}

/* free "tag" chars
   Control +:    bcefknopr t-y \-_
*/

%}

%a 5000
%o 5000

FNCP	[^-+\004 \t\014\015\n"'(){}\[\]0-9`,;]
FNC	[^\004 \t\014\015\n"'(){}\[\]0-9`,;]
NC	[^\004 \t\014\015\n"'(){}\[\]`,;]
SIGN	[-+]
PACKCHAR [%]

%start BOF NOMORE

%%
 BEGIN BOF;
<BOF>\#![^\n]*\n      {BEGIN NOMORE;}	/* ignore first line when shell exec */
.[\010]		;				/* handles backspacing */
.[\177]		;				/* handles deleting */
\"([^\\\"\004]|\\(.|\n)|\"\")*\"     return(STRING); /* strings */
\"([^\\\"\004]|\\(.|\n)|\"\")*[\004] return(NON_CLOSED_STRING);	/* error */
\;[^\n\004]*[\n\004]	;			/* comments */
[-+]?[0-9]+	return(NUMBER);			/* integers */
[#]x[0-9a-fA-F]+	return(HEX_NUMBER);	/* hex integers */
[#]u[0-9]+	return(UNSIGNED_NUMBER);	        /* unsigned integers */
0[xX][0-9a-fA-F]+	return(HEX_NUMBER);	/* hex integers OBSOLETE */
[-+]?[0-9]+[.][0-9]*[eE][-+]?[0-9][0-9]* return(REAL_NUMBER);
[-+]?[.][0-9]+[eE][-+]?[0-9][0-9]* 	return(REAL_NUMBER);
[-+]?[0-9]+[.][0-9]*               	return(REAL_NUMBER);
[-+]?[.][0-9]+               		return(REAL_NUMBER);
[-+]?[0-9]+[eE][-+]?[0-9][0-9]*     	return(REAL_NUMBER);
"("		return(LEFTPAR); 		/* start of list */
")"		return(RIGHTPAR);    		/* end of list */
"{"		return(LEFTBRA); 		/* start of read-obj */
"}"		return(RIGHTBRA);    		/* end of read-obj */
"["             return(LEFTSQUARE); /*  begin locator */
"#""["          return(LEFTSHARPSQUARE); 
"]"             return(RIGHTSQUARE); /*  end locator  */
"#("            return(LEFTPARVECTOR);          /* start of vector, CL compat */
"'"		return(QUOTECHAR);		/* quoting */
\`		return(BACKQUOTE);		/* backquoting */
","		return(UNQUOTE);		/* backquoting */
",@"		return(UNQUOTESPLICING);	/* backquoting */
{PACKCHAR}{FNC}{NC}* return(PACKNAME);		/* see KlPacknameMake */
[#]\\\^[@-~]	return(CTRLCHAR);		/* #\^A */
[#]\\{FNCP}{NC}{NC}* return(SYMBCHAR);		/* #\space etc... */
[#]\\.		return(CHAR);			/* #\A */
{FNCP}{NC}*	return (NAME);			/* identifier */
{SIGN}{FNC}{NC}*	return (NAME);		/* +foo */
{SIGN}		return (NAME);			/* + */
[ \t\014\015]		;			/* blanks */
[\n]            ;                     		/* carriage return */
[\004]		return(END_OF_FILE);		/* pseudo-EOF handling */
.		;				/* skip over control codes */
%%

/**********************\
* 		       *
*  KLONE's I/O package  *
* 		       *
\**********************/

/* 
 * yywrap
 * we treat EOF (or EOString) as a TOKEN, for yacc.
 */

yywrap(){		/* to make EOF a "normal" character */
    unput('\004');	/* EOF is pushed back on the input as ^D */
    return 0;		/* tell Lex there is more to read */
}

/* to know input is complete to send to lex, we parse file by hand
 * give 0 for reset
 */

int
KlCountParentheses(s)
    char *s;
{
    int level = 0;
    static int in_string;

    if (!s) {
	in_string = 0;
	return 0;
    }
    for(;;){
	switch (*s) {
	case 0:
	    return (level > 0 ? level : 0); /* allow extra closing pars */
	case '\\':
	    s++;
	    break;
	case '"':
	    if (in_string) {
		in_string = 0;
		level--;
	    } else {
		in_string = 1;
		level++;
	    }
	    break;
	case '(': case '{': case '[':
	    if (!in_string)
		level++;
	    break;
	case ')': case '}': case ']':
	    if (!in_string)
		level--;
	    break;
	case 2:				/* binary string*/
	    {
		int length = 0;

		s++;
		while (*s != KlBT_STRING) {
		    length *= 10;
		    length += *s - '0';
		}
		s++;
		while (length--)
		    if (! *s++)
			KlError1s(KlE_SYNTAX_ERROR,
				"Syntax error in binary strings");
	    }
	    
	}
	s++;
    }
}

/****************\
*                *
* Binary parsing *
*                *
\****************/

/****************************************************************** OBSOLETE */
/* binary mode: 
 * first byte = type
 * can be 
 * KlBT_STRING length-as-ascii-number KlBT_STRING raw-string-chars
 */

int
KlParseBinaryOld()
{
    int packet_type, c;
    int length;
    char *s;

    switch (packet_type = input()) {
    case KlBT_STRING:
	{
	    KlString kls;

	    length = 0;
	    while ((c = input()) != KlBT_STRING) {
		length *= 10;
		length += c - '0';
	    }
	    kls = KlStringNMake(length);
	    if (KlyyinIsString) {
		bcopy(Klyystrin, kls->string, length);
		Klyystrin += length;
	    } else {
		fread(kls->string, 1, length, yyin);
	    }
	    kls->string[length] = '\0';
	    KlReadExprBin = (KlO) kls;
	}
	break;
    default:				/* EOF or KlBT_BINSTREAMEND */
	return BADBINEXPR;
    }
    return BINEXPR;
}

