/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* Since we refine the main malloc routines in klmalloc.c, we must also 
 * provide the other standard malloc routines as dummy entries to satisfy
 * malloc-tracing packages such as purify.
 * 
 * This is a separate module to avoid loading them in normal applications
 */

#ifndef USE_STANDARD_MALLOC
#ifndef DO_NOT_REDEFINE_MALLOC

int cfree(ptr)
     char *ptr;
{
    free(ptr);
}

char *memalign(alignment, size)
    unsigned alignment;
    unsigned size;
{
    char *ptr = (char *) malloc(size);
    if (((unsigned int) ptr) % (2 * alignment)) {
	/* ok, return it */
	return ptr;
    } else {
	/* else recurse. cross our fingers, with luck it will work... */
	char *rec_ptr =  memalign(alignment, size);
	free(ptr);
	return rec_ptr;
    }
}

char *valloc(size)
    unsigned size;
{
    return memalign(getpagesize(), size);
}

void mallocmap()
{
}

int mallopt(cmd, value)
    int cmd, value;
{
    return 0;
}

#endif					/* DO_NOT_REDEFINE_MALLOC */
#endif					/* USE_STANDARD_MALLOC */
