/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/***********************\
* 		        *
*  KlO  String  *
*  DEFINITIONS	        *
* 		        *
\***********************/

#ifndef INCLUDE_Kl_STRING_H
#define INCLUDE_Kl_STRING_H

/* type */

/* the string field of a KlString begins at the same place as the KlAtom p_name
 * field, so that a KlAtom can be handled to any function expecting an KlString
 * as argument. An KlAtom is less memory_consuming for often used symbols (
 * "foo" "foo" allocates two strings, 'foo 'foo only one atom), but cannot be
 * released.
 */

typedef struct _KlString {
    KlKLONE_HEADER;
    char *string;
    unsigned int size;
}        *KlString;

typedef struct _KlStringPtr {
    KlKLONE_HEADER;
    char *string;
    unsigned int size;
}        *KlStringPtr;			/* same but do not free string! */


/* an internally used object for C typing, not a visible Klone type */
typedef struct _KlUString {
    KlKLONE_HEADER;
    unsigned char *string;
    unsigned int size;
}        *KlUString;

/* exported functions */

EXT KlString KlStringMake();
EXT KlString KlStringMakeNoCopy();
EXT KlString KlStringNMake();
EXT KlString KlStringMakeFromBytes();
EXT KlO KlStringPrint();
EXT KlO KlStringEqual();
EXT KlO KlStringNth();
EXT KlO add_strings();
EXT KlString KlStringMatch();
EXT KlString KlStringStrcat();
extern char *KlStripString();
extern KlO KlStringCoerce();
extern KlString KlExpandTildeForFiles();
extern char *KlStrdup();
extern KlString KlExpandTildeForFiles();

/* exported objects */

EXT KlString KlNilString;
EXT KlString KlPackage;

/* methods */

EXT KlType KlStringType;
EXT KlType KlStringPtrType;

/* macros */

#define KlIsAString(obj) KlHasTrait(obj, KlTrait_string)
#define KlMustBeString(o, n) KlArgumentMustHaveTrait(o, n, KlTrait_string)
#define KlConvertArgToString(o, n) (KlString) (KlIsAString(o) ? ((KlO) (o)) : \
    ((KlConvertArgTo_obj = KlCoerceOrNil(o, KlStringType)) ? \
     KlConvertArgTo_obj : KlBadArgument(o, n, KlTypeCName(KlStringType))))

/* atoms cannot be modified in place */
#define KlIsAModifiableString(obj) (KlIsAString(obj) && !KlIsASymbol(obj))
#define KlMustBeAModifiableString(obj, pos) \
    if (!KlIsAModifiableString(obj))  \
        KlBadArgument(obj, pos, KlTypeCName(KlStringType))

#define KlStringLength(obj) (KlIsASymbol(obj) ? \
    strlen(((KlString)(obj))->string) : (((KlString)(obj))->size))
#define KlStringSetLength(obj, l) {if(!KlIsASymbol(obj)) \
    (((KlString)(obj))->size) = l;}
#define KlStringFixLength(obj) {if(!KlIsASymbol(obj)) \
    ((KlString)(obj))->size = strlen(((KlString)(obj))->string);}

/* when we are sure these can onbly be modifiable strings */
#define KlModStringLength(obj) ((KlString)(obj))->size
#define KlModStringSetLength(obj, l) ((((KlString)(obj))->size) = (l))
#define KlModStringFixLength(obj) \
    (((KlString)(obj))->size = strlen(((KlString)(obj))->string))


#endif					/* INCLUDE_Kl_STRING_H */
