/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*********************\
* 		      *
*  KlO  List  *
*  DEFINITIONS	      *
* 		      *
\*********************/

#ifndef INCLUDE_Kl_LIST_H
#define INCLUDE_Kl_LIST_H
#ifdef NEED_ALLOCA_H
#include <alloca.h>
#endif

/* type */

typedef struct _KlList {
    KlKLONE_HEADER;
    int size;				/* size of list  ( # of elements ) */
    KlO *list;				/* malloced region to store elements */
}      *KlList;				/* so that lists are expandable now */

typedef KlList KlVector;		/* vectors are actually lists */
typedef KlList KlLocator;		/* so are locators */

EXT KlList KlErrorHandlers;

/* exported functions */

EXT KlList KlListMake();
EXT KlList KlListMakeKl();
EXT KlList KlListNMake();
EXT KlList KlListNEvalAndMakeFromArray();
EXT KlList KlListMakeV _ANSI_ARGS_(VARARGS);
EXT KlList KlListKl();
EXT KlList KlListNullTerminated();
EXT KlList KlVectorMakeQ();
EXT KlList KlVectorMake();
EXT KlO KlListEval();
EXT KlO KlListEvalAndTrace();
EXT KlO KlListPrint();
EXT KlO KlListFree();
EXT KlO KlList_sub();
EXT KlO KlList_nth();
EXT KlO KlList_replace_nth();
EXT KlO KlList_delete_nth();
EXT KlO KlList_concat();
EXT KlO KlListEqual();
EXT KlO KlListExecute();
EXT KlO *Kl_flatten_pairlist();
EXT KlO KlListQsort();
EXT KlO KlListCopy();
EXT KlO KlListGet();
EXT KlO KlListCoerce();
EXT KlO KlListAppend();
EXT KlList KlLocatorMakeFromColl();

#define KlListPairMake(e1, e2) KlListMakeV(2, e1, e2)
#define KlListTripletMake(e1, e2, e3) KlListMakeV(3, e1, e2, e3)

/* if an error can occur while filling slots, use KlListNMakeZ */
#define KlListNMakeZ(o, N) (o = KlListNMake(N),bzero(o->list,(N)*sizeof(KlO)))

/* temporary malloc space. kl is a KlList variable, N is in words!*/
#ifndef NO_ALLOCA
#define KlAlloca(N) ((KlO *) alloca((N)*sizeof(KlO)))
#else
EXT KlList Kl__InternalDummyList;
#define KlAlloca(N) (Kl__InternalDummyList = KlListNMake(N), \
		     Kl__InternalDummyList->size = -1, \
		     Kl__InternalDummyList->list)
#endif

/* methods */

EXT KlType KlListType;
EXT KlType KlVectorType;
EXT KlType KlLocatorType;
EXT KlType KlSequenceType;

#define KlListStore(l, i, e) KlIncRef((l)->list[i] = (KlO) (e))
#define KlListStoreDecl KlO *KlListStoreDeclPos
#define KlListStoreReset(l) KlListStoreDeclPos = (l)->list
#define KlListStoreDReset(l) KlO *KlListStoreDeclPos = (l)->list
#define KlListStoreAdd(e) KlIncRef(*KlListStoreDeclPos++ = (KlO) (e))

#define KlLocatorCheck(l)     ((((KlList) (l))->size < 2 || \
    (((KlList) (l))->size==2 && ((KlList) (l))->list[0]==(KlO) KlA_equal)) ? \
    (KlLocator) KlError1(KlE_BAD_LOCATOR, KlListCast(l)) : (KlLocator) l)
#define KlIsALocator(obj)  ((obj)->type == KlLocatorType)
#define KlMustBeLocator(obj, n)  KlArgumentMustBe(obj, n, KlLocatorType)

#define KlIsAList(obj) KlHasTrait(obj, KlTrait_list)
#define KlMustBeList(obj, n) KlArgumentMustHaveTrait(obj, n, KlTrait_list)
#define KlMustBeEvenList(o, n) \
    if(o->size % 2) KlBadArgument(o, n, "list with even number of elements")
#define KlMustBeNonNilList(o, n) \
    if(NIL == (KlO) o) KlBadArgument(o, n, "non-nil list")

#define KlIsAVector(obj)  ((obj)->type == KlVectorType)
#define KlMustBeVector(obj, n)  KlArgumentMustBe(obj, n, KlVectorType)
#endif					/* INCLUDE_Kl_LIST_H */
