/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/**************************\
* 			   *
*  KlO Collection  *
*  DEFINITIONS		   *
* 			   *
\**************************/

#ifndef INCLUDE_Kl_COLL_H
#define INCLUDE_Kl_COLL_H

/* type */

typedef struct _KlCollection {
    KlKLONE_HEADER;
    int size;				/* number of elements */
    KlO *list;				/* malloced region to store elements */
    int limit;				/* elements allowable in the malloced
					 * aera */
}            *KlCollection;

typedef struct _KlQuotedExpr {		/* 'foo */
    KlKLONE_HEADER;
    int size;				/* 2 */
    KlO *list;				/* pointer to the symbol, expr pair */
    KlMethod eval;			/* eval method */
    struct _KlAtom *symbol;
    KlO expr;
}            *KlQuotedExpr;

/* exported functions */

EXT KlCollection KlCollectionMake();
EXT KlO KlCollectionPrint();
EXT KlO KlCollectionFree();
EXT KlCollection KlCollectionAdd();
EXT KlO KlCollectionEvalOnLine();

EXT KlQuotedExpr KlAnyQuotedExprMake();
EXT KlO KlQuotedExprEval();
EXT KlO KlQuotedExprPrint();
EXT KlO KlQuotedExprFree();
EXT KlO KlQuotedExprEqual();
EXT KlO KlQuotedExprCommaEval();
EXT KlO KlQuotedExprCoerce();

/* (backward compatible) convenient functions */

#define KlQuotedExprMake(expr) \
	KlAnyQuotedExprMake(KlA_quote, expr, KlQuote)
#define KlBackQuotedExprMake(expr) \
	KlAnyQuotedExprMake(KlA_backquote, expr, KlBackquote)
#define KlUnquoteExprMake(expr) \
	KlAnyQuotedExprMake(KlA_unquote, expr, KlQuotedExprCommaEval)
#define KlUnquoteSplicingExprMake(expr) \
	KlAnyQuotedExprMake(KlA_unquotesplicing, expr, KlQuotedExprCommaEval)
					    

#define KlIsACollection(obj) ((obj)->type == KlCollectionType)
#define KlIsAQuotedExpr(obj) ((obj)->type == KlQuotedExprType)

/* methods */

EXT KlType KlCollectionType;
EXT KlType KlQuotedExprType;

#endif					/* INCLUDE_Kl_COLL_H */
