extern char *malloc(), *realloc();

# line 2 "klparser.y"
/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*****************************************************************************\
*                                                                             *
*  Yacc grammar for Klone                                                     *
*                                                                             *
\*****************************************************************************/

#define IN_YACC_PARSER
#include "klparser.h"



# line 15 "klparser.y"
typedef union {
    KlO KlObject;
    KlCollection Kl_collection;
} YYSTYPE;
# define END_OF_FILE 257
# define STRING 258
# define NON_CLOSED_STRING 259
# define QUOTECHAR 260
# define BINEXPR 261
# define BADBINEXPR 262
# define NUMBER 263
# define HEX_NUMBER 264
# define SYMBCHAR 265
# define CHAR 266
# define CTRLCHAR 267
# define REAL_NUMBER 268
# define LEFTPAR 269
# define RIGHTPAR 270
# define LEFTBRA 271
# define RIGHTBRA 272
# define LEFTSQUARE 273
# define RIGHTSQUARE 274
# define LEFTSHARPSQUARE 275
# define BACKQUOTE 276
# define UNQUOTE 277
# define UNQUOTESPLICING 278
# define NAME 279
# define PACKNAME 280
# define LEFTPARVECTOR 281
# define UNSIGNED_NUMBER 282
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 149 "klparser.y"


static char *Klyyerrorstring;

yyerror(s)
char *s;
{
    Klyyerrorstring = s;
}

static int Klyyparsing;

KlyyparseSyntaxError(why)
    char *why;
{
    /* set back flag to 0 since this error cannot be corrected */
    Klyyparsing = 0;
    KlError1s(KlE_SYNTAX_ERROR, why);
}

int
Klyyparse()
{
    if (Klyyparsing) {			/* we cannot re-enter parser! */
	return (int) KlError1s(KlE_SYNTAX_ERROR,
			 "Parser not reentrant: cannot call read in a read");
    } else {
	Klyyparsing = 1;
    }
    if (KlyyparseRaw()) {		/* abort */
	Klyyparsing = 0;
	return (int) KlError1s(KlE_SYNTAX_ERROR, Klyyerrorstring);
    } else {				/* accept */
	Klyyparsing = 0;
	return 0;
    }
}
int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 30
# define YYLAST 211
int yyact[]={

    27,    39,    16,    21,    17,    25,    26,    12,    14,    24,
    22,    23,    13,     5,    38,     6,     0,     9,     0,     8,
    18,    19,    20,    10,    11,     7,    15,    27,     4,    16,
    21,    17,    25,    26,    12,    14,    24,    22,    23,    13,
     5,     3,     6,     0,     9,     0,     8,    18,    19,    20,
    10,    11,     7,    15,    27,     0,    16,    21,    17,    25,
    26,    12,    14,    24,    22,    23,    13,     5,     0,     6,
     0,     9,    44,     8,    18,    19,    20,    10,    11,     7,
    15,    27,     0,    16,    21,    17,    25,    26,    12,    14,
    24,    22,    23,    13,     5,     0,     6,     0,     9,    43,
     8,    18,    19,    20,    10,    11,     7,    15,    27,     0,
    16,    21,    17,    25,    26,    12,    14,    24,    22,    23,
    13,     5,    42,     6,     0,     9,     0,     8,    18,    19,
    20,    10,    11,     7,    15,    27,     0,    16,    21,    17,
    25,    26,    12,    14,    24,    22,    23,    13,     5,     1,
     6,    41,     9,    28,     8,    18,    19,    20,    10,    11,
     7,    15,    27,     0,    16,    21,    17,    25,    26,    12,
    14,    24,    22,    23,    13,     5,     0,     6,     0,     9,
     0,     8,    18,    19,    20,    10,    11,     7,    15,    40,
     2,    29,     0,     2,     0,     0,     0,     0,    30,    31,
    32,    33,     0,     0,     0,     0,     0,    34,    35,    36,
    37 };
int yypact[]={

  -229, -1000, -1000,  -229, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,   -94,   -94,   -94,
   -94, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -256,
  -121,  -148,  -175,  -202, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000 };
int yypgo[]={

     0,   189,   149,   191 };
int yyr1[]={

     0,     2,     2,     2,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     3,     3 };
int yyr2[]={

     0,     3,     5,     3,     7,     7,     7,     7,     7,     3,
     3,     3,     3,     3,     3,     3,     5,     5,     5,     5,
     3,     7,     3,     3,     3,     3,     3,     3,     5,     1 };
int yychk[]={

 -1000,    -2,    -1,   270,   257,   269,   271,   281,   275,   273,
   279,   280,   263,   268,   264,   282,   258,   260,   276,   277,
   278,   259,   266,   267,   265,   261,   262,   256,    -2,    -3,
    -3,    -3,    -3,    -3,    -1,    -1,    -1,    -1,   270,   257,
    -1,   272,   270,   274,   274 };
int yydef[]={

     0,    -2,     1,     0,     3,    29,    29,    29,    29,    29,
     9,    10,    11,    12,    13,    14,    15,     0,     0,     0,
     0,    20,    22,    23,    24,    25,    26,    27,     2,     0,
     0,     0,     0,     0,    16,    17,    18,    19,     4,    21,
    28,     5,     6,     7,     8 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"END_OF_FILE",	257,
	"STRING",	258,
	"NON_CLOSED_STRING",	259,
	"QUOTECHAR",	260,
	"BINEXPR",	261,
	"BADBINEXPR",	262,
	"NUMBER",	263,
	"HEX_NUMBER",	264,
	"SYMBCHAR",	265,
	"CHAR",	266,
	"CTRLCHAR",	267,
	"REAL_NUMBER",	268,
	"LEFTPAR",	269,
	"RIGHTPAR",	270,
	"LEFTBRA",	271,
	"RIGHTBRA",	272,
	"LEFTSQUARE",	273,
	"RIGHTSQUARE",	274,
	"LEFTSHARPSQUARE",	275,
	"BACKQUOTE",	276,
	"UNQUOTE",	277,
	"UNQUOTESPLICING",	278,
	"NAME",	279,
	"PACKNAME",	280,
	"LEFTPARVECTOR",	281,
	"UNSIGNED_NUMBER",	282,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"main_s_exp : s_expression",
	"main_s_exp : RIGHTPAR main_s_exp",
	"main_s_exp : END_OF_FILE",
	"s_expression : LEFTPAR list_of_s_expressions RIGHTPAR",
	"s_expression : LEFTBRA list_of_s_expressions RIGHTBRA",
	"s_expression : LEFTPARVECTOR list_of_s_expressions RIGHTPAR",
	"s_expression : LEFTSHARPSQUARE list_of_s_expressions RIGHTSQUARE",
	"s_expression : LEFTSQUARE list_of_s_expressions RIGHTSQUARE",
	"s_expression : NAME",
	"s_expression : PACKNAME",
	"s_expression : NUMBER",
	"s_expression : REAL_NUMBER",
	"s_expression : HEX_NUMBER",
	"s_expression : UNSIGNED_NUMBER",
	"s_expression : STRING",
	"s_expression : QUOTECHAR s_expression",
	"s_expression : BACKQUOTE s_expression",
	"s_expression : UNQUOTE s_expression",
	"s_expression : UNQUOTESPLICING s_expression",
	"s_expression : NON_CLOSED_STRING",
	"s_expression : LEFTPAR list_of_s_expressions END_OF_FILE",
	"s_expression : CHAR",
	"s_expression : CTRLCHAR",
	"s_expression : SYMBCHAR",
	"s_expression : BINEXPR",
	"s_expression : BADBINEXPR",
	"s_expression : error",
	"list_of_s_expressions : list_of_s_expressions s_expression",
	"list_of_s_expressions : /* empty */",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 39 "klparser.y"
{yyval.KlObject = KlReadExpr = yypvt[-0].KlObject;
			 YYACCEPT;} break;
case 2:
# line 42 "klparser.y"
{yyval.KlObject = KlReadExpr = yypvt[-0].KlObject;
			 YYACCEPT;} break;
case 3:
# line 45 "klparser.y"
{yyval.KlObject = KlReadExpr = NULL;
			 YYACCEPT;} break;
case 4:
# line 50 "klparser.y"
{yyval.KlObject = (KlO) KlListMake(yypvt[-1].Kl_collection);} break;
case 5:
# line 52 "klparser.y"
{yyval.KlObject = KlCollectionEvalOnLine(yypvt[-1].Kl_collection);
			 if (!yyval.KlObject) {
			     KlReadExpr = NULL;
			     yyerror("Error in inline function");
			     YYABORT;
			 }
		     } break;
case 6:
# line 60 "klparser.y"
{yyval.KlObject = (KlO) KlVectorMakeQ(yypvt[-1].Kl_collection);} break;
case 7:
# line 62 "klparser.y"
{
			    if (((KlList) yypvt[-1].Kl_collection)->size < 2 || 
                                (((KlList) yypvt[-1].Kl_collection)->size == 2 &&
			         ((KlList) yypvt[-1].Kl_collection)->list[0] == (KlO) KlA_equal)
                               ) {
				yyerror("A locator #[...] needs more elements");
				YYABORT;
			    }
			    yyval.KlObject = (KlO) KlLocatorMakeFromColl(yypvt[-1].Kl_collection);
			} break;
case 8:
# line 73 "klparser.y"
{
			    if (((KlList) yypvt[-1].Kl_collection)->size < 2 || 
                                (((KlList) yypvt[-1].Kl_collection)->size == 2 &&
			         ((KlList) yypvt[-1].Kl_collection)->list[0] == (KlO) KlA_equal)
                               ) {
				yyerror("A message [...] needs more elements");
				YYABORT;
			    }
			    yyval.KlObject = (KlO) KlKoMessageMakeFromColl(yypvt[-1].Kl_collection);
			} break;
case 9:
# line 84 "klparser.y"
{yyval.KlObject = (KlO) KlInternBytes(yyleng, yytext);} break;
case 10:
# line 86 "klparser.y"
{yyval.KlObject = (KlO) KlPacknameMake(yyleng, yytext);} break;
case 11:
# line 88 "klparser.y"
{yyval.KlObject = (KlO) KlNumberMake((Int) atoi(yytext));} break;
case 12:
# line 90 "klparser.y"
{double x;
			 KlParseReals(x);
			 yyval.KlObject = (KlO) KlRealMake(x);} break;
case 13:
# line 94 "klparser.y"
{int num;
			 sscanf(yytext+2,"%x",&num);
			 yyval.KlObject = (KlO) KlNumberMake((Int) num);} break;
case 14:
# line 98 "klparser.y"
{yyval.KlObject = (KlO) KlUnsignedMakeFromString(yytext);} break;
case 15:
# line 99 "klparser.y"
{
		    int sslen;
		    char *ss = KlStripString(yyleng, yytext, &sslen);
		    yyval.KlObject = (KlO) KlStringMakeFromBytes(sslen, ss);} break;
case 16:
# line 104 "klparser.y"
{yyval.KlObject = (KlO) KlQuotedExprMake(yypvt[-0].KlObject);} break;
case 17:
# line 106 "klparser.y"
{yyval.KlObject = (KlO) KlBackQuotedExprMake(yypvt[-0].KlObject);} break;
case 18:
# line 108 "klparser.y"
{yyval.KlObject = (KlO) KlUnquoteExprMake(yypvt[-0].KlObject);} break;
case 19:
# line 110 "klparser.y"
{yyval.KlObject = (KlO) KlUnquoteSplicingExprMake(yypvt[-0].KlObject);} break;
case 20:
# line 112 "klparser.y"
{yyval.KlObject = KlReadExpr = NULL;
			    yyerror("Non closed string");
		            YYABORT;
			} break;
case 21:
# line 117 "klparser.y"
{yyval.KlObject = KlReadExpr = NULL;
			    yyerror("Lacking \")\" at the end of file!");
			    YYABORT;
			} break;
case 22:
# line 122 "klparser.y"
{yyval.KlObject = (KlO) KlNumberMake(yytext[2]);} break;
case 23:
# line 124 "klparser.y"
{yyval.KlObject = (KlO) KlNumberMake((yytext[3] - 64) % 32);} break;
case 24:
# line 126 "klparser.y"
{int charcode = KlSymbCharParse(yytext+2);
			if (charcode == -1) {
			    yyerror("Invalid character name");
			    YYABORT;
			 } else {			
			     yyval.KlObject = (KlO) KlNumberMake(charcode);
			 }
			} break;
case 25:
# line 135 "klparser.y"
{yyval.KlObject = KlReadExprBin;} break;
case 26:
# line 137 "klparser.y"
{yyval.KlObject = NIL;yyerror("Bad BinExpr");} break;
case 27:
# line 139 "klparser.y"
{yyval.KlObject = NIL;} break;
case 28:
# line 143 "klparser.y"
{yyval.Kl_collection = KlCollectionAdd(yypvt[-1].Kl_collection, yypvt[-0].KlObject);} break;
case 29:
# line 145 "klparser.y"
{yyval.Kl_collection = KlCollectionMake();} break;
	}
	goto yystack;		/* reset registers in driver code */
}
