#include <ctype.h>

#include "EXTERN.h"
#include "klone.h"
#ifdef SYSV_STRINGS
#include <string.h>
#else  /* !SYSV_STRINGS */
#include <strings.h>
#endif /* !SYSV_STRINGS */

#include "kl_atom.h"
#include "kl_string.h"
#include "kl_list.h"
#include "kl_coll.h"
#include "kl_stream.h"
#include "klko.h"

    /* rename yacc functions to avoid conflicts */
#define yyparse KlyyparseRaw
#define yylex Klyylex
#define yyerror Klyyerror
#define yysptr Klyysptr
#define yysbuf Klyysbuf
#define yyin Klyyin
#define yylineno Klyylineno
#define yytext Klyytext
#define yyback Klyyback
#define yyinput Klyyinput
#define yylook Klyylook
#define yyoutput Klyyoutput
#define yyunput Klyyunput
#define yywrap Klyywrap
#define yyleng Klyyleng

#define KlParseReals(x) sscanf(yytext, "%lg", &x)
#define KlParseReal(s, x) sscanf(s, "%lg", &x)

#define KlBT_BINSTREAMBEGIN 1		/* fixed */
#define KlBT_BINSTREAMEND 4		/* fixed */
#define KlBT_STRING 2

#ifdef IN_YACC_PARSER
extern char Klyytext[];
extern int Klyyleng;
#endif
# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin, *yyout;
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

#include "y.tab.h"

/* #define KLCRYPT */

/* to have always at least MAX_TOKEN_LENGTH chars in all lexes */
#undef YYLMAX
#define YYLMAX MAX_TOKEN_LENGTH

/* here goes the definition of lex I/O, as macros for efficiency */

/* first, we forget the previous definitions, */
#undef input
#undef unput
/* which were :
#define output(c) putc(c,yyout)
#define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):\
getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;\
*yysptr++=yytchar;}
*/

/* So here are our macros 
 * we cache KlStdyy streams into yyin, KlyyinIsString, Klyystrin global vars
 * for efficiency (reporting load on context switch)
 */

int KlyyinIsString;	/* 0 ==> reading from STREAM yyin */
				/* 1 ==> reading from STRING Klyystrin */
char *Klyystrin;		/* current pointer on input string */

#define input() (((\
    	yytchar =\
        (yysptr>yysbuf ?\
	    U(*--yysptr)\
	:   (KlyyinIsString ?\
	        ( *Klyystrin ? *Klyystrin++ : 4)\
	    :   getc(yyin))))\
	==10 ?\
	    (yylineno++,yytchar)\
	:   yytchar)\
    ==EOF ?\
        4\
    :   yytchar)

#define unput(c) {\
    yytchar= (c);\
    if(yytchar=='\n')\
        yylineno--;\
    *yysptr++=yytchar;\
}

/* externally callable function for unput:
 */

KlUnput(buffer)
char *buffer;
{
    while (*buffer) {
	unput(*buffer);
	buffer++;
    }
}

/* free "tag" chars
   Control +:    bcefknopr t-y \-_
*/

# define BOF 2
# define NOMORE 4
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
BEGIN BOF;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
     {BEGIN NOMORE;}
break;
case 2:
	;
break;
case 3:
	;
break;
case 4:
    return(STRING);
break;
case 5:
return(NON_CLOSED_STRING);
break;
case 6:
;
break;
case 7:
return(NUMBER);
break;
case 8:
return(HEX_NUMBER);
break;
case 9:
return(UNSIGNED_NUMBER);
break;
case 10:
return(HEX_NUMBER);
break;
case 11:
return(REAL_NUMBER);
break;
case 12:
	return(REAL_NUMBER);
break;
case 13:
              	return(REAL_NUMBER);
break;
case 14:
              		return(REAL_NUMBER);
break;
case 15:
    	return(REAL_NUMBER);
break;
case 16:
	return(LEFTPAR);
break;
case 17:
	return(RIGHTPAR);
break;
case 18:
	return(LEFTBRA);
break;
case 19:
	return(RIGHTBRA);
break;
case 20:
            return(LEFTSQUARE);
break;
case 21:
         return(LEFTSHARPSQUARE);
break;
case 22:
            return(RIGHTSQUARE);
break;
case 23:
           return(LEFTPARVECTOR);
break;
case 24:
	return(QUOTECHAR);
break;
case 25:
	return(BACKQUOTE);
break;
case 26:
	return(UNQUOTE);
break;
case 27:
	return(UNQUOTESPLICING);
break;
case 28:
return(PACKNAME);
break;
case 29:
return(CTRLCHAR);
break;
case 30:
return(SYMBCHAR);
break;
case 31:
	return(CHAR);
break;
case 32:
return (NAME);
break;
case 33:
return (NAME);
break;
case 34:
	return (NAME);
break;
case 35:
	;
break;
case 36:
           ;
break;
case 37:
	return(END_OF_FILE);
break;
case 38:
	;
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/**********************\
* 		       *
*  KLONE's I/O package  *
* 		       *
\**********************/

/* 
 * yywrap
 * we treat EOF (or EOString) as a TOKEN, for yacc.
 */

yywrap(){		/* to make EOF a "normal" character */
    unput('\004');	/* EOF is pushed back on the input as ^D */
    return 0;		/* tell Lex there is more to read */
}

/* to know input is complete to send to lex, we parse file by hand
 * give 0 for reset
 */

int
KlCountParentheses(s)
    char *s;
{
    int level = 0;
    static int in_string;

    if (!s) {
	in_string = 0;
	return 0;
    }
    for(;;){
	switch (*s) {
	case 0:
	    return (level > 0 ? level : 0); /* allow extra closing pars */
	case '\\':
	    s++;
	    break;
	case '"':
	    if (in_string) {
		in_string = 0;
		level--;
	    } else {
		in_string = 1;
		level++;
	    }
	    break;
	case '(': case '{': case '[':
	    if (!in_string)
		level++;
	    break;
	case ')': case '}': case ']':
	    if (!in_string)
		level--;
	    break;
	case 2:				/* binary string*/
	    {
		int length = 0;

		s++;
		while (*s != KlBT_STRING) {
		    length *= 10;
		    length += *s - '0';
		}
		s++;
		while (length--)
		    if (! *s++)
			KlError1s(KlE_SYNTAX_ERROR,
				"Syntax error in binary strings");
	    }
	    
	}
	s++;
    }
}

/****************\
*                *
* Binary parsing *
*                *
\****************/

/****************************************************************** OBSOLETE */
/* binary mode: 
 * first byte = type
 * can be 
 * KlBT_STRING length-as-ascii-number KlBT_STRING raw-string-chars
 */

int
KlParseBinaryOld()
{
    int packet_type, c;
    int length;
    char *s;

    switch (packet_type = input()) {
    case KlBT_STRING:
	{
	    KlString kls;

	    length = 0;
	    while ((c = input()) != KlBT_STRING) {
		length *= 10;
		length += c - '0';
	    }
	    kls = KlStringNMake(length);
	    if (KlyyinIsString) {
		bcopy(Klyystrin, kls->string, length);
		Klyystrin += length;
	    } else {
		fread(kls->string, 1, length, yyin);
	    }
	    kls->string[length] = '\0';
	    KlReadExprBin = (KlO) kls;
	}
	break;
    default:				/* EOF or KlBT_BINSTREAMEND */
	return BADBINEXPR;
    }
    return BINEXPR;
}

int yyvstop[] = {
0,

32,
38,
0,

37,
38,
0,

35,
38,
0,

36,
0,

38,
0,

32,
38,
0,

32,
38,
0,

24,
38,
0,

16,
38,
0,

17,
38,
0,

34,
38,
0,

26,
38,
0,

32,
38,
0,

7,
38,
0,

7,
38,
0,

38,
0,

20,
38,
0,

22,
38,
0,

25,
38,
0,

18,
38,
0,

19,
38,
0,

32,
38,
0,

32,
0,

2,
32,
0,

3,
32,
0,

2,
0,

3,
0,

5,
0,

2,
0,

4,
0,

3,
0,

23,
0,

21,
0,

32,
0,

32,
0,

32,
0,

28,
32,
0,

2,
28,
32,
0,

3,
28,
32,
0,

33,
0,

2,
33,
0,

33,
0,

7,
0,

3,
33,
0,

27,
0,

14,
32,
0,

13,
0,

6,
0,

2,
0,

3,
0,

32,
0,

31,
32,
0,

31,
0,

31,
32,
0,

31,
32,
0,

9,
32,
0,

8,
32,
0,

14,
33,
0,

32,
0,

15,
0,

10,
0,

1,
0,

30,
32,
0,

29,
30,
32,
0,

29,
0,

33,
0,

32,
0,

12,
32,
0,

11,
0,

33,
0,

12,
33,
0,
0};
# define YYTYPE char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,7,	0,0,	
0,0,	1,8,	0,0,	0,0,	
0,0,	1,7,	1,9,	1,10,	
8,32,	34,34,	36,34,	39,34,	
38,34,	58,58,	60,58,	61,58,	
38,34,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,11,	
1,12,	37,34,	1,13,	0,0,	
1,14,	1,15,	1,16,	0,0,	
1,17,	1,18,	38,34,	1,19,	
0,0,	1,20,	1,21,	1,21,	
1,21,	1,21,	1,21,	1,21,	
1,21,	1,21,	1,21,	0,0,	
1,22,	0,0,	0,0,	2,15,	
2,16,	1,7,	1,7,	2,18,	
18,53,	0,0,	1,7,	0,0,	
2,21,	2,21,	2,21,	2,21,	
2,21,	2,21,	2,21,	2,21,	
2,21,	0,0,	2,22,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,7,	0,0,	0,0,	
1,23,	1,7,	1,24,	0,0,	
0,0,	1,25,	0,0,	0,0,	
56,72,	0,0,	56,72,	0,0,	
38,34,	56,73,	56,73,	56,73,	
56,73,	56,73,	56,73,	56,73,	
56,73,	56,73,	56,73,	0,0,	
2,24,	0,0,	0,0,	2,25,	
0,0,	0,0,	0,0,	0,0,	
1,26,	0,0,	1,27,	0,0,	
1,7,	0,0,	0,0,	8,33,	
34,34,	36,34,	39,34,	3,28,	
58,58,	60,58,	61,58,	38,34,	
3,15,	3,16,	0,0,	0,0,	
3,18,	0,0,	2,26,	0,0,	
2,27,	3,21,	3,21,	3,21,	
3,21,	3,21,	3,21,	3,21,	
3,21,	3,21,	4,28,	3,22,	
0,0,	0,0,	0,0,	4,15,	
4,16,	0,0,	0,0,	4,18,	
0,0,	0,0,	0,0,	0,0,	
4,21,	4,21,	4,21,	4,21,	
4,21,	4,21,	4,21,	4,21,	
4,21,	0,0,	4,22,	0,0,	
0,0,	0,0,	0,0,	0,0,	
5,15,	5,16,	0,0,	0,0,	
5,18,	3,24,	0,0,	0,0,	
3,25,	5,21,	5,21,	5,21,	
5,21,	5,21,	5,21,	5,21,	
5,21,	5,21,	0,0,	5,22,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
4,24,	0,0,	0,0,	4,25,	
0,0,	0,0,	0,0,	3,26,	
51,55,	3,27,	51,51,	51,51,	
51,51,	51,51,	51,51,	51,51,	
51,51,	51,51,	51,51,	51,51,	
0,0,	0,0,	0,0,	0,0,	
0,0,	5,24,	0,0,	0,0,	
5,25,	0,0,	4,26,	51,56,	
4,27,	6,15,	6,16,	0,0,	
0,0,	6,18,	0,0,	0,0,	
0,0,	0,0,	6,21,	6,21,	
6,21,	6,21,	6,21,	6,21,	
6,21,	6,21,	6,21,	0,0,	
6,22,	0,0,	0,0,	5,26,	
0,0,	5,27,	0,0,	7,29,	
0,0,	0,0,	7,0,	51,56,	
0,0,	0,0,	7,30,	7,0,	
7,0,	0,0,	7,0,	7,0,	
0,0,	55,55,	55,55,	55,55,	
55,55,	55,55,	55,55,	55,55,	
55,55,	55,55,	55,55,	0,0,	
0,0,	0,0,	6,24,	0,0,	
0,0,	6,25,	7,0,	0,0,	
7,0,	7,29,	55,71,	7,29,	
0,0,	7,0,	7,0,	7,0,	
11,34,	7,29,	7,0,	11,35,	
7,29,	0,0,	7,29,	11,36,	
11,34,	11,34,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
6,26,	7,0,	6,27,	0,0,	
0,0,	0,0,	7,29,	7,29,	
0,0,	0,0,	55,71,	7,29,	
0,0,	0,0,	0,0,	0,0,	
0,0,	11,37,	11,34,	0,0,	
11,34,	0,0,	11,34,	0,0,	
0,0,	0,0,	11,34,	0,0,	
0,0,	11,34,	7,29,	11,34,	
0,0,	7,0,	7,29,	7,0,	
0,0,	0,0,	7,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	11,34,	
11,34,	12,0,	0,0,	0,0,	
11,34,	0,0,	12,0,	12,0,	
0,0,	12,0,	12,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	7,0,	0,0,	7,0,	
0,0,	7,31,	0,0,	11,34,	
0,0,	0,0,	11,34,	11,38,	
0,0,	12,0,	0,0,	12,0,	
0,0,	0,0,	0,0,	0,0,	
12,0,	12,40,	12,0,	13,45,	
0,0,	12,0,	13,0,	0,0,	
0,0,	0,0,	13,46,	13,0,	
13,0,	0,0,	13,0,	13,0,	
0,0,	0,0,	0,0,	0,0,	
12,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	11,39,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	13,0,	0,0,	
13,0,	13,45,	0,0,	13,45,	
0,0,	13,0,	13,0,	13,0,	
0,0,	13,45,	13,0,	0,0,	
13,45,	0,0,	0,0,	0,0,	
12,41,	12,42,	12,0,	0,0,	
0,0,	12,0,	0,0,	0,0,	
0,0,	13,0,	0,0,	0,0,	
0,0,	0,0,	13,45,	13,45,	
0,0,	0,0,	0,0,	13,45,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	12,43,	0,0,	
0,0,	12,44,	0,0,	0,0,	
12,0,	0,0,	12,0,	0,0,	
0,0,	0,0,	13,45,	0,0,	
0,0,	13,0,	13,45,	13,0,	
0,0,	17,48,	13,0,	0,0,	
17,0,	0,0,	0,0,	0,0,	
17,49,	17,0,	17,0,	0,0,	
17,0,	17,0,	0,0,	0,0,	
0,0,	19,0,	0,0,	0,0,	
0,0,	0,0,	19,0,	19,0,	
0,0,	19,0,	19,0,	0,0,	
0,0,	13,0,	0,0,	13,0,	
17,0,	13,47,	17,0,	17,48,	
20,32,	17,48,	0,0,	17,0,	
17,0,	17,0,	0,0,	17,48,	
17,0,	19,0,	17,50,	19,0,	
17,51,	0,0,	0,0,	0,0,	
19,0,	19,0,	19,0,	0,0,	
0,0,	19,0,	0,0,	17,0,	
0,0,	19,54,	0,0,	0,0,	
17,48,	17,48,	0,0,	0,0,	
0,0,	17,48,	0,0,	0,0,	
19,0,	0,0,	20,55,	0,0,	
20,51,	20,51,	20,51,	20,51,	
20,51,	20,51,	20,51,	20,51,	
20,51,	20,51,	0,0,	0,0,	
17,48,	0,0,	0,0,	17,0,	
17,48,	17,0,	0,0,	0,0,	
17,0,	20,56,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
19,0,	0,0,	19,0,	0,0,	
0,0,	19,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
20,57,	0,0,	21,32,	0,0,	
0,0,	0,0,	0,0,	17,0,	
0,0,	17,0,	0,0,	17,52,	
0,0,	20,56,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
19,0,	0,0,	19,0,	0,0,	
0,0,	0,0,	22,58,	0,0,	
0,0,	22,59,	0,0,	0,0,	
20,57,	22,60,	22,58,	22,59,	
0,0,	0,0,	0,0,	20,33,	
21,55,	0,0,	21,51,	21,51,	
21,51,	21,51,	21,51,	21,51,	
21,51,	21,51,	21,51,	21,51,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	22,58,	
22,58,	0,0,	22,58,	21,56,	
22,58,	0,0,	0,0,	0,0,	
22,58,	28,0,	0,0,	22,58,	
0,0,	22,58,	28,0,	28,0,	
0,0,	28,0,	28,0,	72,73,	
72,73,	72,73,	72,73,	72,73,	
72,73,	72,73,	72,73,	72,73,	
72,73,	22,58,	22,58,	0,0,	
0,0,	0,0,	22,58,	21,56,	
0,0,	28,0,	28,62,	28,0,	
0,0,	0,0,	0,0,	0,0,	
28,0,	28,40,	28,0,	0,0,	
0,0,	28,0,	0,0,	0,0,	
0,0,	22,58,	29,0,	0,0,	
22,58,	22,58,	29,29,	29,0,	
29,0,	21,33,	29,0,	29,0,	
28,0,	71,83,	0,0,	71,83,	
0,0,	0,0,	71,84,	71,84,	
71,84,	71,84,	71,84,	71,84,	
71,84,	71,84,	71,84,	71,84,	
0,0,	0,0,	29,0,	0,0,	
29,0,	0,0,	0,0,	0,0,	
0,0,	29,0,	29,0,	29,0,	
22,61,	0,0,	29,0,	0,0,	
28,41,	28,42,	28,0,	30,0,	
0,0,	28,0,	0,0,	30,29,	
30,0,	30,0,	0,0,	30,0,	
30,0,	29,0,	0,0,	0,0,	
31,0,	0,0,	0,0,	0,0,	
31,29,	31,0,	31,0,	0,0,	
31,0,	31,0,	28,43,	0,0,	
0,0,	28,44,	0,0,	30,0,	
28,0,	30,0,	28,0,	0,0,	
0,0,	0,0,	30,0,	30,0,	
30,0,	0,0,	0,0,	30,0,	
31,0,	29,0,	31,0,	29,0,	
0,0,	0,0,	29,0,	31,0,	
31,0,	31,0,	0,0,	0,0,	
31,0,	75,75,	30,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
75,75,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	31,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	29,0,	0,0,	29,0,	
0,0,	29,29,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	30,0,	75,75,	
30,0,	75,75,	0,0,	30,0,	
0,0,	0,0,	0,0,	75,75,	
0,0,	0,0,	75,75,	31,0,	
75,75,	31,0,	0,0,	42,63,	
31,0,	0,0,	42,64,	0,0,	
0,0,	0,0,	42,63,	42,64,	
42,0,	0,0,	0,0,	0,0,	
75,75,	75,75,	30,0,	43,0,	
30,0,	75,75,	30,29,	43,29,	
43,0,	43,0,	0,0,	43,0,	
43,0,	0,0,	0,0,	31,0,	
0,0,	31,0,	0,0,	31,29,	
42,64,	42,63,	0,0,	42,63,	
75,75,	42,64,	0,0,	0,0,	
75,75,	42,65,	0,0,	43,0,	
42,63,	43,0,	42,65,	0,0,	
0,0,	0,0,	43,0,	43,0,	
43,0,	0,0,	0,0,	43,0,	
0,0,	0,0,	0,0,	43,67,	
0,0,	0,0,	42,63,	42,63,	
0,0,	0,0,	0,0,	42,63,	
0,0,	0,0,	43,0,	0,0,	
0,0,	0,0,	0,0,	75,75,	
83,84,	83,84,	83,84,	83,84,	
83,84,	83,84,	83,84,	83,84,	
83,84,	83,84,	42,63,	0,0,	
0,0,	42,64,	42,63,	44,0,	
42,66,	0,0,	0,0,	44,29,	
44,0,	44,0,	0,0,	44,0,	
44,0,	0,0,	43,0,	0,0,	
43,0,	0,0,	0,0,	43,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	44,0,	
0,0,	44,0,	0,0,	0,0,	
0,0,	42,63,	44,0,	44,0,	
44,0,	0,0,	0,0,	44,0,	
0,0,	0,0,	43,0,	44,68,	
43,0,	0,0,	43,29,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	44,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
44,68,	0,0,	0,0,	45,45,	
44,68,	0,0,	45,0,	0,0,	
0,0,	0,0,	45,45,	45,0,	
45,0,	0,0,	45,0,	45,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	44,0,	0,0,	
44,0,	0,0,	0,0,	44,0,	
0,0,	0,0,	45,0,	0,0,	
45,0,	45,45,	0,0,	45,45,	
0,0,	45,0,	45,0,	45,0,	
0,0,	45,45,	45,0,	46,0,	
45,45,	0,0,	45,45,	0,0,	
46,0,	46,0,	0,0,	46,0,	
46,0,	0,0,	44,0,	0,0,	
44,0,	45,0,	44,29,	0,0,	
0,0,	0,0,	45,45,	45,45,	
0,0,	0,0,	0,0,	45,45,	
0,0,	0,0,	0,0,	46,0,	
0,0,	46,0,	0,0,	0,0,	
47,0,	0,0,	46,0,	46,0,	
46,0,	47,0,	47,0,	46,0,	
47,0,	47,0,	45,45,	0,0,	
0,0,	45,0,	45,45,	45,0,	
0,0,	0,0,	45,0,	0,0,	
0,0,	0,0,	46,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
47,0,	0,0,	47,0,	0,0,	
0,0,	0,0,	0,0,	47,0,	
47,0,	47,0,	0,0,	0,0,	
47,0,	0,0,	0,0,	0,0,	
0,0,	45,0,	0,0,	45,0,	
0,0,	45,45,	0,0,	0,0,	
0,0,	0,0,	46,0,	47,0,	
46,0,	0,0,	0,0,	46,0,	
0,0,	0,0,	0,0,	48,0,	
0,0,	0,0,	0,0,	48,48,	
48,0,	48,0,	0,0,	48,0,	
48,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	46,0,	47,0,	
46,0,	47,0,	0,0,	48,0,	
47,0,	48,0,	0,0,	0,0,	
0,0,	0,0,	48,0,	48,0,	
48,0,	0,0,	0,0,	48,0,	
49,0,	48,48,	0,0,	48,48,	
49,48,	49,0,	49,0,	0,0,	
49,0,	49,0,	0,0,	0,0,	
0,0,	0,0,	48,0,	47,0,	
0,0,	47,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
49,0,	0,0,	49,0,	0,0,	
0,0,	0,0,	0,0,	49,0,	
49,0,	49,0,	0,0,	0,0,	
49,0,	0,0,	49,48,	0,0,	
49,48,	0,0,	48,0,	0,0,	
48,0,	0,0,	0,0,	48,0,	
0,0,	0,0,	0,0,	49,0,	
0,0,	0,0,	50,0,	0,0,	
0,0,	0,0,	50,48,	50,0,	
50,0,	0,0,	50,0,	50,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	48,0,	0,0,	
48,0,	0,0,	48,48,	0,0,	
0,0,	0,0,	50,0,	49,0,	
50,0,	49,0,	0,0,	0,0,	
49,0,	50,0,	50,0,	50,0,	
0,0,	0,0,	50,0,	52,0,	
50,48,	0,0,	50,69,	52,48,	
52,0,	52,0,	0,0,	52,0,	
52,0,	0,0,	0,0,	0,0,	
0,0,	50,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	49,0,	
0,0,	49,0,	0,0,	49,48,	
0,0,	0,0,	0,0,	52,0,	
0,0,	52,0,	0,0,	0,0,	
0,0,	0,0,	52,0,	52,0,	
52,0,	0,0,	0,0,	52,0,	
0,0,	52,48,	0,0,	52,48,	
0,0,	50,0,	0,0,	50,0,	
0,0,	0,0,	50,0,	0,0,	
0,0,	0,0,	52,0,	0,0,	
0,0,	0,0,	0,0,	54,0,	
0,0,	0,0,	0,0,	54,29,	
54,0,	54,0,	0,0,	54,0,	
54,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	50,0,	0,0,	50,0,	
0,0,	50,48,	0,0,	0,0,	
0,0,	0,0,	52,0,	54,0,	
52,0,	54,0,	0,0,	52,0,	
0,0,	0,0,	54,0,	54,0,	
54,0,	0,0,	0,0,	54,0,	
0,0,	0,0,	0,0,	54,54,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	54,0,	0,0,	
0,0,	0,0,	52,0,	0,0,	
52,0,	0,0,	52,48,	0,0,	
54,70,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	57,74,	
57,74,	57,74,	57,74,	57,74,	
57,74,	57,74,	57,74,	57,74,	
57,74,	0,0,	54,0,	0,0,	
54,0,	0,0,	0,0,	54,0,	
57,74,	57,74,	57,74,	57,74,	
57,74,	57,74,	62,62,	0,0,	
0,0,	62,75,	0,0,	0,0,	
0,0,	62,62,	62,75,	62,76,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	54,0,	0,0,	
54,0,	0,0,	54,29,	0,0,	
57,74,	57,74,	57,74,	57,74,	
57,74,	57,74,	0,0,	62,75,	
62,62,	0,0,	62,62,	0,0,	
62,75,	0,0,	0,0,	63,77,	
62,62,	0,0,	63,0,	62,62,	
0,0,	62,62,	63,77,	63,0,	
63,0,	0,0,	63,0,	63,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	62,62,	62,62,	0,0,	
0,0,	0,0,	62,62,	0,0,	
0,0,	0,0,	63,0,	0,0,	
63,0,	63,77,	0,0,	63,77,	
0,0,	63,0,	63,0,	63,0,	
0,0,	63,77,	63,0,	0,0,	
63,77,	62,62,	63,77,	0,0,	
62,75,	62,62,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	63,0,	0,0,	0,0,	
0,0,	0,0,	63,77,	63,77,	
0,0,	65,0,	0,0,	63,77,	
0,0,	65,29,	65,0,	65,0,	
0,0,	65,0,	65,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
62,62,	0,0,	63,77,	0,0,	
0,0,	63,0,	63,77,	63,0,	
0,0,	65,0,	63,0,	65,0,	
0,0,	0,0,	0,0,	0,0,	
65,0,	65,0,	65,0,	66,77,	
0,0,	65,0,	66,0,	0,0,	
0,0,	0,0,	66,77,	66,0,	
66,0,	0,0,	66,0,	66,0,	
0,0,	0,0,	0,0,	0,0,	
65,0,	63,0,	0,0,	63,0,	
0,0,	63,77,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	66,0,	0,0,	
66,0,	66,77,	0,0,	66,77,	
0,0,	66,0,	66,0,	66,0,	
0,0,	66,77,	66,0,	0,0,	
66,77,	0,0,	66,77,	0,0,	
65,0,	0,0,	65,0,	0,0,	
0,0,	65,0,	0,0,	0,0,	
0,0,	66,0,	0,0,	0,0,	
0,0,	0,0,	66,78,	66,78,	
67,0,	0,0,	0,0,	66,78,	
67,29,	67,0,	67,0,	0,0,	
67,0,	67,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
65,0,	0,0,	65,0,	0,0,	
65,29,	0,0,	66,78,	0,0,	
0,0,	66,79,	66,78,	0,0,	
67,0,	0,0,	67,0,	0,0,	
0,0,	0,0,	0,0,	67,0,	
67,0,	67,0,	0,0,	0,0,	
67,0,	68,0,	0,0,	0,0,	
67,67,	68,29,	68,0,	68,0,	
0,0,	68,0,	68,0,	0,0,	
0,0,	0,0,	0,0,	67,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	66,77,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	68,0,	0,0,	68,0,	
0,0,	0,0,	0,0,	0,0,	
68,0,	68,0,	68,0,	0,0,	
0,0,	68,0,	0,0,	0,0,	
0,0,	68,68,	0,0,	67,0,	
0,0,	67,0,	0,0,	0,0,	
67,0,	0,0,	0,0,	0,0,	
68,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	68,68,	0,0,	
69,0,	0,0,	68,68,	0,0,	
69,48,	69,0,	69,0,	0,0,	
69,0,	69,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	67,0,	
0,0,	67,0,	0,0,	67,29,	
0,0,	0,0,	0,0,	0,0,	
68,0,	0,0,	68,0,	0,0,	
69,0,	68,0,	69,0,	0,0,	
0,0,	0,0,	0,0,	69,0,	
69,0,	69,0,	0,0,	0,0,	
69,0,	70,0,	69,48,	0,0,	
69,69,	70,29,	70,0,	70,0,	
0,0,	70,0,	70,0,	0,0,	
0,0,	0,0,	0,0,	69,0,	
68,0,	0,0,	68,0,	0,0,	
68,29,	0,0,	0,0,	0,0,	
0,0,	69,80,	0,0,	0,0,	
0,0,	70,0,	0,0,	70,0,	
0,0,	0,0,	0,0,	0,0,	
70,0,	70,0,	70,0,	0,0,	
70,81,	70,0,	0,0,	0,0,	
0,0,	70,82,	0,0,	69,0,	
0,0,	69,0,	0,0,	0,0,	
69,0,	0,0,	0,0,	0,0,	
70,0,	0,0,	0,0,	77,0,	
0,0,	0,0,	0,0,	0,0,	
77,0,	77,0,	0,0,	77,0,	
77,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	69,0,	
0,0,	69,0,	0,0,	69,48,	
0,0,	0,0,	0,0,	77,0,	
70,0,	77,0,	70,0,	0,0,	
0,0,	70,0,	77,0,	77,0,	
77,0,	78,0,	0,0,	77,0,	
0,0,	0,0,	78,0,	78,0,	
0,0,	78,0,	78,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	77,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
70,0,	0,0,	70,0,	0,0,	
70,29,	78,0,	0,0,	78,0,	
0,0,	0,0,	0,0,	0,0,	
78,0,	78,0,	78,0,	80,0,	
0,0,	78,0,	0,0,	80,48,	
80,0,	80,0,	0,0,	80,0,	
80,0,	0,0,	77,0,	0,0,	
77,0,	0,0,	0,0,	77,0,	
78,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	80,0,	
0,0,	80,0,	0,0,	0,0,	
0,0,	0,0,	80,0,	80,0,	
80,0,	0,0,	80,85,	80,0,	
0,0,	80,48,	77,0,	80,86,	
77,0,	0,0,	0,0,	0,0,	
78,0,	0,0,	78,0,	0,0,	
0,0,	78,0,	80,0,	0,0,	
0,0,	81,0,	0,0,	0,0,	
0,0,	81,29,	81,0,	81,0,	
0,0,	81,0,	81,0,	0,0,	
0,0,	0,0,	82,0,	0,0,	
0,0,	0,0,	82,29,	82,0,	
82,0,	0,0,	82,0,	82,0,	
78,0,	0,0,	78,0,	0,0,	
0,0,	81,0,	80,0,	81,0,	
80,0,	0,0,	0,0,	80,0,	
81,0,	81,0,	81,0,	0,0,	
0,0,	81,0,	82,0,	0,0,	
82,0,	81,82,	0,0,	0,0,	
0,0,	82,0,	82,0,	82,0,	
0,0,	0,0,	82,0,	0,0,	
81,0,	0,0,	82,82,	0,0,	
0,0,	0,0,	80,0,	0,0,	
80,0,	0,0,	80,48,	0,0,	
0,0,	82,0,	0,0,	0,0,	
85,0,	0,0,	0,0,	0,0,	
85,48,	85,0,	85,0,	0,0,	
85,0,	85,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
81,0,	0,0,	81,0,	0,0,	
0,0,	81,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
85,0,	82,0,	85,0,	82,0,	
0,0,	0,0,	82,0,	85,0,	
85,0,	85,0,	0,0,	0,0,	
85,0,	0,0,	85,48,	0,0,	
85,86,	0,0,	0,0,	0,0,	
81,0,	0,0,	81,0,	0,0,	
81,29,	0,0,	0,0,	85,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	82,0,	0,0,	82,0,	
0,0,	82,29,	0,0,	86,0,	
0,0,	0,0,	0,0,	86,48,	
86,0,	86,0,	0,0,	86,0,	
86,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	85,0,	
0,0,	85,0,	0,0,	0,0,	
85,0,	0,0,	0,0,	86,0,	
0,0,	86,0,	0,0,	0,0,	
0,0,	0,0,	86,0,	86,0,	
86,0,	0,0,	0,0,	86,0,	
0,0,	86,48,	0,0,	86,86,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	85,0,	
0,0,	85,0,	86,0,	85,48,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	86,0,	0,0,	
86,0,	0,0,	0,0,	86,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	86,0,	0,0,	
86,0,	0,0,	86,48,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-23,	yysvec+1,	0,	
yycrank+-100,	yysvec+1,	0,	
yycrank+-123,	yysvec+1,	0,	
yycrank+-148,	yysvec+1,	0,	
yycrank+-209,	yysvec+1,	0,	
yycrank+-274,	0,		yyvstop+1,
yycrank+4,	0,		yyvstop+4,
yycrank+0,	yysvec+8,	yyvstop+7,
yycrank+0,	0,		yyvstop+10,
yycrank+-315,	0,		yyvstop+12,
yycrank+-377,	yysvec+7,	yyvstop+14,
yycrank+-418,	yysvec+7,	yyvstop+17,
yycrank+0,	yysvec+8,	yyvstop+20,
yycrank+0,	yysvec+8,	yyvstop+23,
yycrank+0,	yysvec+8,	yyvstop+26,
yycrank+-512,	0,		yyvstop+29,
yycrank+4,	yysvec+8,	yyvstop+32,
yycrank+-525,	yysvec+7,	yyvstop+35,
yycrank+540,	0,		yyvstop+38,
yycrank+622,	0,		yyvstop+41,
yycrank+-653,	0,		yyvstop+44,
yycrank+0,	yysvec+8,	yyvstop+46,
yycrank+0,	yysvec+8,	yyvstop+49,
yycrank+0,	yysvec+8,	yyvstop+52,
yycrank+0,	yysvec+8,	yyvstop+55,
yycrank+0,	yysvec+8,	yyvstop+58,
yycrank+-693,	yysvec+7,	yyvstop+61,
yycrank+-738,	yysvec+7,	yyvstop+64,
yycrank+-783,	yysvec+7,	yyvstop+66,
yycrank+-796,	yysvec+7,	yyvstop+69,
yycrank+0,	0,		yyvstop+72,
yycrank+0,	0,		yyvstop+74,
yycrank+-5,	yysvec+11,	0,	
yycrank+0,	0,		yyvstop+76,
yycrank+-6,	yysvec+11,	yyvstop+78,
yycrank+3,	0,		yyvstop+80,
yycrank+-12,	yysvec+11,	0,	
yycrank+-7,	yysvec+11,	yyvstop+82,
yycrank+0,	0,		yyvstop+84,
yycrank+0,	0,		yyvstop+86,
yycrank+-890,	0,		yyvstop+88,
yycrank+-903,	yysvec+7,	yyvstop+90,
yycrank+-979,	yysvec+7,	yyvstop+92,
yycrank+-1046,	0,		yyvstop+94,
yycrank+-1087,	yysvec+45,	yyvstop+97,
yycrank+-1120,	yysvec+45,	yyvstop+101,
yycrank+-1183,	yysvec+17,	yyvstop+105,
yycrank+-1224,	yysvec+17,	yyvstop+107,
yycrank+-1282,	yysvec+17,	yyvstop+110,
yycrank+178,	0,		yyvstop+112,
yycrank+-1323,	yysvec+17,	yyvstop+114,
yycrank+0,	0,		yyvstop+117,
yycrank+-1383,	yysvec+7,	yyvstop+119,
yycrank+241,	0,		yyvstop+122,
yycrank+57,	0,		0,	
yycrank+1415,	0,		0,	
yycrank+-9,	yysvec+22,	0,	
yycrank+0,	0,		yyvstop+124,
yycrank+-10,	yysvec+22,	yyvstop+126,
yycrank+-11,	yysvec+22,	yyvstop+128,
yycrank+-1485,	0,		yyvstop+130,
yycrank+-1526,	0,		yyvstop+132,
yycrank+0,	0,		yyvstop+135,
yycrank+-1589,	yysvec+7,	yyvstop+137,
yycrank+-1630,	0,		yyvstop+140,
yycrank+-1692,	yysvec+7,	yyvstop+143,
yycrank+-1733,	yysvec+7,	yyvstop+146,
yycrank+-1796,	yysvec+17,	yyvstop+149,
yycrank+-1837,	yysvec+7,	yyvstop+152,
yycrank+710,	0,		0,	
yycrank+659,	0,		0,	
yycrank+0,	yysvec+72,	yyvstop+154,
yycrank+0,	yysvec+57,	yyvstop+156,
yycrank+-840,	yysvec+62,	0,	
yycrank+0,	0,		yyvstop+158,
yycrank+-1895,	yysvec+63,	yyvstop+160,
yycrank+-1933,	yysvec+63,	yyvstop+163,
yycrank+0,	0,		yyvstop+167,
yycrank+-1971,	yysvec+17,	yyvstop+169,
yycrank+-2029,	yysvec+7,	yyvstop+171,
yycrank+-2042,	yysvec+7,	yyvstop+173,
yycrank+920,	0,		0,	
yycrank+0,	yysvec+83,	yyvstop+176,
yycrank+-2100,	yysvec+17,	yyvstop+178,
yycrank+-2167,	yysvec+17,	yyvstop+180,
0,	0,	0};
struct yywork *yytop = yycrank+2294;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,04  ,01  ,01  ,01  ,
010 ,011 ,012 ,01  ,011 ,011 ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,'#' ,01  ,'%' ,01  ,047 ,
047 ,047 ,01  ,'+' ,047 ,'+' ,'.' ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,047 ,01  ,01  ,01  ,01  ,
'@' ,'A' ,'A' ,'A' ,'A' ,'E' ,'A' ,'@' ,
'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,
'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,
'X' ,'@' ,'@' ,'[' ,0134,'[' ,'@' ,'@' ,
'[' ,'A' ,'A' ,'A' ,'A' ,'E' ,'A' ,'@' ,
'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,
'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,'@' ,
'X' ,'@' ,'@' ,'[' ,'@' ,'[' ,'@' ,0177,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
