/*
 * tmConverters.c -
 *	This module implements all the Xt Converters to and
 *	from Strings needed by Tm
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 */

/* #include "tmFuncs.h" */
#ifndef MOTIF11
#include <Xm/RepType.h>
#include <Xm/DragDrop.h>
#endif
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>		/* for CoreRec */
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <KlLib.h>

/* escape char for XmString formatting */
#define TM_FORMAT_CHAR '@'

#define done(address, type)                               \
    {                                                   \
        if(toVal->addr)                                 \
        {                                               \
            if(toVal->size < sizeof(type))              \
            {                                           \
                toVal->size = sizeof(type);             \
                return( FALSE) ;                        \
            }                                           \
            else                                        \
            {   *((type *) (toVal->addr)) = *address;   \
            }                                           \
        }                                               \
        else                                            \
        {                                               \
            toVal->addr = (XPointer) address;           \
        }                                               \
        toVal->size = sizeof(type);                     \
    }













/*
 *--------------------------------------------------------------
 *
 * Tm_CvtBooleanToString --
 *
 *	Converter from Boolean to String type
 *
 * Results:
 *
 *	changes the "toVal" arg to contain the new value.
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */

Boolean
Tm_CvtBooleanToString(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    static char *buf;
    Boolean boolVal;
 
    boolVal = *(Boolean *) (fromVal->addr);

    if (boolVal) {
	buf = "true";
    } else {
	buf = "false";
    } 
 
    done(&buf, char *);

    return True;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_CvtIntToString --
 *
 *	Converter from Int to String type
 *
 * Results:
 *
 *	changes the "toVal" arg to contain the new value.
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */

Boolean
Tm_CvtIntToString(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    static char *buf = NULL;
    int intVal;
 
    intVal = *(int *) (fromVal->addr);

    if (buf == NULL) {
        buf = XtMalloc(16);
    }
    sprintf(buf, "%d", intVal);
 
    done(&buf, char *);

    return True;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_CvtUnsignedIntToString --
 *
 *	Converter from UnsignedInt to String type
 *
 * Results:
 *
 *	changes the "toVal" arg to contain the new value.
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */

Boolean
Tm_CvtUnsignedIntToString(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    static char *buf = NULL;
    unsigned int intVal;
 
    intVal = *(int *) (fromVal->addr);

    if (buf == NULL)
        buf = XtMalloc(16);
    sprintf(buf, "%u", intVal);
 
    done(&buf, char *);

    return True;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_CvtDimensionToString --
 *
 *	Converter from Dimension to String type
 *
 * Results:
 *
 *	changes the "toVal" arg to contain the new value.
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */

Boolean
Tm_CvtDimensionToString(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    static char *buf = NULL;
    Dimension dimVal;
 
    dimVal = *(Dimension *) (fromVal->addr);

    if (buf == NULL)
        buf = XtMalloc(16);
    sprintf(buf, "%hu", dimVal);
 
    done(&buf, char *);

    return True;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_CvtShortToString --
 *
 *	Converter from Short to String type
 *
 * Results:
 *
 *	changes the "toVal" arg to contain the new value.
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */

Boolean
Tm_CvtShortToString(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    static char *buf = NULL;
    Dimension shortVal;
 
    shortVal = *(short *) (fromVal->addr);

    if (buf == NULL)
        buf = XtMalloc(16);
    sprintf(buf, "%hd", shortVal);
 
    done(&buf, char *);

    return True;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_CvtLongToString --
 *
 *	Converter from Long to String type
 *
 * Results:
 *
 *	changes the "toVal" arg to contain the new value.
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */

Boolean
Tm_CvtLongToString(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    static char *buf = NULL;
    Dimension shortVal;
 
    shortVal = *(short *) (fromVal->addr);

    if (buf == NULL)
        buf = XtMalloc(16);
    sprintf(buf, "%ld", shortVal);
 
    done(&buf, char *);

    return True;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_CvtPixelToString --
 *
 *	Converter from Pixel to String type
 *	gives result in #RGB form
 *
 * Results:
 *
 *	changes the "toVal" arg to contain the new value.
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */

Boolean
Tm_CvtPixelToString(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    static char *buf = NULL;
    Pixel pixelVal;
    Screen *screen;
    Colormap colormap;
    XColor color;
 
    color.pixel = *(unsigned long *) fromVal->addr;
    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);

    XQueryColor(DisplayOfScreen(screen), colormap, &color);

    if (buf == NULL)
        buf = XtMalloc(32);
    sprintf(buf, "#%04x%04x%04x", color.red, color.green, color.blue);

    done(&buf, char *);

    return True;
}







Boolean
Tm_CvtXmStringToString(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    XmStringContext context;
    static char *buf = NULL;
    char *p, *text;
    XmStringCharSet charset;
    XmStringDirection direction;
    Boolean separator;
    int size;
    int current_len, segment_len;
    XmString xmstr;

    /* whatever buf has grown to, or started from, 
       make it a reasonable size
     */
    XtFree(buf);
    size = 128;
    buf = XtMalloc(size);
    p = buf;

    xmstr = *(XmString *) fromVal->addr;
    if (!XmStringInitContext(&context, xmstr)) {
	return False;
    }
    while (XmStringGetNextSegment(context, &text, &charset,
		&direction, &separator)) {
	XtFree(charset);
	segment_len = strlen(text);
	if (p + segment_len >= buf + size) {
	    /* string too large, double space */
	    current_len = p - buf;
	    size *= 2;
	    buf = XtRealloc(buf, size);
	    p = buf + current_len;
	}
	strcpy(p, text);
	p += segment_len;
	if (separator == True) {
	    *p++ = '\n';
	}
	*p = 0;
	XtFree(text);
    }
    XmStringFreeContext(context);

    /* destroy the XmString we started from */
    XmStringFree(xmstr);
 
    done(&buf, char *);

    return True;
}



/*
 *--------------------------------------------------------------
 *
 * Tm_XmStringToString --
 *
 * Results:
 *
 *	returns the Ascii string rep of the XmString
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */
String
Tm_XmStringToString(xmstr)
    XmString xmstr;
{
    XmStringContext context;
    static char *buf = NULL;
    char *p, *text;
    XmStringCharSet charset;
    XmStringDirection direction;
    Boolean separator;
    int size;
    int current_len, segment_len;

    /* whatever buf has grown to, or started from, 
       make it a reasonable size
     */
    XtFree(buf);
    size = 128;
    buf = XtMalloc(size);
    p = buf;

    if (!XmStringInitContext(&context, xmstr)) {
	return "";
    }
    while (XmStringGetNextSegment(context, &text, &charset,
		&direction, &separator)) {
	XtFree(charset);
	segment_len = strlen(text);
	if (p + segment_len >= buf + size) {
	    /* string too large, double space */
	    current_len = p - buf;
	    size *= 2;
	    buf = XtRealloc(buf, size);
	    p = buf + current_len;
	}
	strcpy(p, text);
	p += segment_len;
	if (separator == True) {
	    *p++ = '\n';
	}
	*p = 0;
	XtFree(text);
    }
    XmStringFreeContext(context);

    return buf;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_CvtXmStringTableToString --
 *
 *	Converter from XmStringTable to String type
 *
 * Results:
 *
 *	changes the "toVal" arg to contain the new value.
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */

Boolean
Tm_CvtXmStringTableToString(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    static KlList list = NULL;
    int n, len, item_count;
    char *p, *end;
    char *dummy;
    XmString *xmstrs = *(XmString **) fromVal->addr;
    Arg arg;
    Widget w = *((Widget *) args[0].addr);
    char *size_resource;
    /* this should come in via args, but Xt doesn't give it */
    extern char *Tm_Resource;

    if (Tm_Resource== NULL)
	return False;
    if (strcmp (Tm_Resource, XmNitems) == 0) {
        size_resource = XmNitemCount;
    } else
    if (strcmp (Tm_Resource, XmNselectedItems) == 0) {
        size_resource = XmNselectedItemCount;
    } else
    return False;

    XtSetArg(arg, size_resource, &item_count);
    XtGetValues(w, &arg, 1);
    Tm_Resource = NULL; /* make sure under our control */

    len= 0;

    list = (KlList)NIL;
    if (item_count != 0) {
	char *item;
        list = KlListNMake(item_count);
        for (n = 0; n < item_count; n++) {
	    item = Tm_XmStringToString(xmstrs[n]);
	    list->list[n] = (KlO)KlStringMake(XtNewString(item));
	    KlIncRef(list->list[n]);
        }
    }
    

    done(&list, void *);


    return True;
}



/*
 *--------------------------------------------------------------
 *
 * Tm_RegisterConverters --
 *
 *	Register all extra converters with Xt.
 *
 * Results:
 *
 * Side effects:
 *
 *	Modifies the Xt converter lists.
 *--------------------------------------------------------------
 */

void
Tm_RegisterConverters(interp, appContext)
    void *interp;
    XtAppContext appContext;
{
    XtConvertArgRec convert_arg;
    XtConvertArgRec convert_args[128];
 
    /*
     * Register the type converters we need
     * This implementation installs everything, 
     * even if it is never used. A smarter method
     * would be to install on demand. Maybe someday...
     */


    
    /* 
     * XmString to String
     */
    XtSetTypeConverter(
		XmRXmString, XtRString,
		Tm_CvtXmStringToString,
		NULL,
		0,
		XtCacheNone,
		NULL);
   


    /* 
     * Boolean to String
     */
    XtSetTypeConverter(
		XmRBoolean, XtRString,
		Tm_CvtBooleanToString,
		NULL,
		0,
		XtCacheNone,
		NULL);

    /* 
     * Set to String
     */
    XtSetTypeConverter(
		XmRSet, XtRString,
		Tm_CvtBooleanToString,
		NULL,
		0,
		XtCacheNone,
		NULL);




    
    /* 
     * XmStringTable to String
     */
    convert_arg.address_mode = XtWidgetBaseOffset;
    convert_arg.address_id = (XtPointer) XtOffsetOf(CoreRec, core.self);
    convert_arg.size = sizeof(CoreWidget);

    XtSetTypeConverter(
		XmRXmStringTable, XtRString,
		Tm_CvtXmStringTableToString,
		&convert_arg,
		1,
		XtCacheNone,
		NULL);
   

    /* 
     * Pixel to String
     */
    convert_args[0].address_mode = XtWidgetBaseOffset;
    convert_args[0].address_id = (XtPointer) XtOffsetOf(WidgetRec, core.screen);
    convert_args[0].size = sizeof(Screen *);

    convert_args[1].address_mode = XtWidgetBaseOffset;
    convert_args[1].address_id = (XtPointer) XtOffsetOf(CoreRec, core.colormap);
    convert_args[1].size = sizeof(Colormap);

    XtSetTypeConverter(
		XmRPixel, XmRString,
		Tm_CvtPixelToString,
		convert_args,
		2,
		XtCacheNone,
		NULL);

}
