/*****************************************************************************\
*                                                                             *
* 				    klone2ic                                   *
*                                                                             *
\*****************************************************************************/
/* V 1.0 July 9 1991 Colas Nahaboo Copyright 1991 Groupe Bull
 */

char *USAGE[] = {
    "klone2ic string-name klone-files...",
    "Converts to a C string of name <string-name> klone files given as the",
    "other arguments. Writes result on stdout",
    0
};

#include <stdio.h>

#define in_string 1
#define in_comment 2
#define in_back 3

main(argc, argv)
    int argc;
    char *argv[];

{
    char *stringname, *filename;
    FILE *fd;
    int i, c;
    int curcol = 4;
    int state;

    if (argc < 2) {
	char **help_line = USAGE;

	while (*help_line) {
	    puts(*help_line);
	    help_line++;
	}
	exit(1);
    }
    /* echo header */
    stringname = argv[1];
    printf("/* C-included KLONE code generated by klone2ic from files:\n * ");
    for (i = 2; i < argc; i++) {
	printf("%s ", argv[i]);
    }

    printf("\n */\n\nchar %s[] = {\n  ", stringname);

    for (i = 2; i < argc; i++) {
	filename = argv[i];
	if (!(fd = fopen(filename, "r"))) {
	    fprintf(stderr, "%s: Cannot open file %s -- Aborting\n",
		argv[0], filename);
	    exit(1);
	}
	state = 0;
	while ((c = getc(fd)) != EOF) {
	    /* strip comments */
	    switch (state) {
	    case 0:
		if (c == ';') {
		    state = in_comment;
		    continue;
		} else if (c == '"') {
		    state = in_string;
		}
		break;
	    case in_comment:
		if (c == '\n') {
		    state = 0;
		}
		continue;
		break;
	    case in_string:
		if (c == '\\') {
		    state = in_back;
		} else if (c == '"') {
		    state = 0;
		}
		break;
	    case in_back:
		state = in_string;
	    }

	    if (c < 10)
		curcol += 2;
	    else if (c < 100)
		curcol += 3;
	    else
		curcol += 4;
	    if (curcol > 75) {
		curcol = 2;
		printf("\n  ");
	    }
	    printf("%d,", c);
	}
    }
    printf("\n  0};\n");
    exit(0);
}
