/* Copyright 1995 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: kl_motif.c,v 0.0.1.1 1995/04/07 12:06:50 oarsac Exp $ */


#include <Xm/Xm.h>
#include <Xm/XmAll.h>
#ifdef USE_CANVAS
#include <Kn/Knvas.h>
#endif /* USE_CANVAS */
#include "kl_widget.h"



#ifdef USE_CANVAS

KlWidget KlKnvas(KlWidget canvas, KlString name)
{
    Widget w;
    w = CreateKnvas(canvas->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}


KlO KlLayer(KlWidget canvas)
{
    return (KlO) KnLayerMake(canvas->w);
}


KlO KlLine(KlO parent, KlNumber x, KlNumber y, KlNumber w, KlNumber h)
{
    return (KlO) KnLineMake(0, parent, x->number, y->number, w->number, h->number);
}


KlO KlRect(KlO parent, KlNumber x, KlNumber y, KlNumber w, KlNumber h)
{
    return (KlO) KnRectMake(0, parent, x->number, y->number, w->number, h->number);
}


KlO KlFRect(KlO parent, KlNumber x, KlNumber y, KlNumber w, KlNumber h)
{
    return (KlO) KnFRectMake(0, parent, x->number, y->number, w->number, h->number);
}


KlO KlCircle(KlO parent, KlNumber x, KlNumber y, KlNumber w, KlNumber h)
{
    return (KlO) KnCircleMake(0, parent, x->number, y->number, w->number, h->number);
}


KlO KlFCircle(KlO parent, KlNumber x, KlNumber y, KlNumber w, KlNumber h)
{
    return (KlO) KnFCircleMake(0, parent, x->number, y->number, w->number, h->number);
}


KlO KlTag(KlWidget parent, KlString name)
{
    return (KlO) KnTagMake(parent->w, name->string);
}


KlO KlMoveInteractor(KlWidget canvas)
{
    return (KlO) KnInteractorMake(canvas->w, opaqueMoveBehavior);
}

KlO KlAddInteractor(KlWidget canvas, KnO kno, KnInteractor kni)
{
    KnAddInteractor(canvas->w, kno, kni);
}
		    

#endif /* USE_CANVAS */



KlWidget KlArrowButton( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateArrowButton(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlBulletinBoard( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateBulletinBoard(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlBulletinBoardDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateBulletinBoardDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlCascadeButton( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateCascadeButton(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlCommand( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateCommand(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlCommandDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateCommandDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlDialogShell( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateDialogShell(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlDragIcon( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateDragIcon(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlDrawingArea( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateDrawingArea(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlDrawnButton( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateDrawnButton(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlFileSelectionBox( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateFileSelectionBox(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlFileSelectionDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateFileSelectionDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlForm( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateForm(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlFormDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateFormDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlFrame( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateFrame(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlLabel( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateLabel(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlItemList( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateList(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlScrolledList( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateScrolledList(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlMainWindow( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateMainWindow(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlMenuShell( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateMenuShell(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlMessageBox( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateMessageBox(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlMessageDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateMessageDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlErrorDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateErrorDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlInformationDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateInformationDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlQuestionDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateQuestionDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlWarningDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateWarningDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlWorkingDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateWorkingDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlTemplateDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateTemplateDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlPanedWindow( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreatePanedWindow(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlPushButton( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreatePushButton(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlRowColumn( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateRowColumn(parent->w, name->string, 0, 0);
    XtVaSetValues(w, XmNpacking, XmPACK_COLUMN,
		  XmNorientation, XmHORIZONTAL,
		  0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlVerticalPacker( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateRowColumn(parent->w, name->string, 0, 0);
    XtVaSetValues(w, XmNpacking, XmPACK_COLUMN,
		  XmNorientation, XmVERTICAL,
		  0);
    XtManageChild(w);
    return KlWidgetMake(w);
}



KlWidget KlHorizontalPacker( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateRowColumn(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlWorkArea( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateWorkArea(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlRadioBox( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateRadioBox(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlOptionMenu( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateOptionMenu(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlMenuBar( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateMenuBar(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlPopupMenu( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreatePopupMenu(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlPulldownMenu( KlWidget parent, KlString name)
{
    Widget w, menu;
    Arg args[1];
    char menuname[64];
    sprintf(menuname, "%s_menu", name->string);
    menu = XmCreatePulldownMenu(parent->w, menuname, 0, 0);
    XtSetArg(args[0], XmNsubMenuId, menu);
    w = XmCreateCascadeButton(parent->w, name->string, args, 1);
    XtManageChild(w);
    return KlWidgetMake(menu);
}




KlWidget KlScale( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateScale(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlScrollBar( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateScrollBar(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlScrolledWindow( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateScrolledWindow(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlSelectionBox( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateSelectionBox(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlSelectionDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateSelectionDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlPromptDialog( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreatePromptDialog(parent->w, name->string, 0, 0);
    return KlWidgetMake(w);
}




KlWidget KlSeparator( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateSeparator(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlScrolledText( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateScrolledText(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlText( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateText(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlTextField( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateTextField(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}




KlWidget KlToggleButton( KlWidget parent, KlString name)
{
    Widget w;
    w = XmCreateToggleButton(parent->w, name->string, 0, 0);
    XtManageChild(w);
    return KlWidgetMake(w);
}





