/* Copyright 1995 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: kl_classes.c,v 0.0.1.1 1995/04/07 12:06:49 oarsac Exp $ */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "kl_widget.h"
#include "kl_motif.h"
#include "kl_classes.h"


static KlHash classes_table;

static KlWidgetClassRec classes[] = {
    {
	"XmArrowButton",
	KlArrowButton,
	"ArrowButton",
	NULL,
	0
    },
    {
	"XmBulletinBoard",
	KlBulletinBoard,
	"BulletinBoard",
	NULL,
	0
    },
    {
	"XmBulletinBoardDialog",
	KlBulletinBoardDialog,
	"BulletinBoardDialog",
	NULL,
	0
    },
    {
	"XmCascadeButton",
	KlCascadeButton,
	"CascadeButton",
	NULL,
	0
    },
    {
	"XmCommand",
	KlCommand,
	"Command",
	NULL,
	0
    },
    {
	"XmCommandDialog",
	KlCommandDialog,
	"CommandDialog",
	NULL,
	0
    },
    {
	"XmDialogShell",
	KlDialogShell,
	"DialogShell",
	NULL,
	0
    },
    {
	"XmDragIcon",
	KlDragIcon,
	"DragIcon",
	NULL,
	0
    },
    {
	"XmDrawingArea",
	KlDrawingArea,
	"DrawingArea",
	NULL,
	0
    },
    {
	"XmDrawnButton",
	KlDrawnButton,
	"DrawnButton",
	NULL,
	0
    },
    {
	"XmFileSelectionBox",
	KlFileSelectionBox,
	"FileSelectionBox",
	NULL,
	0
    },
    {
	"XmFileSelectionDialog",
	KlFileSelectionDialog,
	"FileSelectionDialog",
	NULL,
	0
    },
    {
	"XmForm",
	KlForm,
	"Form",
	NULL,
	0
    },
    {
	"XmFormDialog",
	KlFormDialog,
	"FormDialog",
	NULL,
	0
    },
    {
	"XmFrame",
	KlFrame,
	"Frame",
	NULL,
	0
    },
    {
	"XmLabel",
	KlLabel,
	"Label",
	NULL,
	0
    },
    {
	"XmList",
	KlItemList,
	"ItemList",
	NULL,
	0
    },
    {
	"XmScrolledList",
	KlScrolledList,
	"ScrolledList",
	NULL,
	0
    },
    {
	"XmMainWindow",
	KlMainWindow,
	"MainWindow",
	NULL,
	0
    },
    {
	"XmMenuShell",
	KlMenuShell,
	"MenuShell",
	NULL,
	0
    },
    {
	"XmMessageBox",
	KlMessageBox,
	"MessageBox",
	NULL,
	0
    },
    {
	"XmMessageDialog",
	KlMessageDialog,
	"MessageDialog",
	NULL,
	0
    },
    {
	"XmErrorDialog",
	KlErrorDialog,
	"ErrorDialog",
	NULL,
	0
    },
    {
	"XmInformationDialog",
	KlInformationDialog,
	"InformationDialog",
	NULL,
	0
    },
    {
	"XmQuestionDialog",
	KlQuestionDialog,
	"QuestionDialog",
	NULL,
	0
    },
    {
	"XmWarningDialog",
	KlWarningDialog,
	"WarningDialog",
	NULL,
	0
    },
    {
	"XmWorkingDialog",
	KlWorkingDialog,
	"WorkingDialog",
	NULL,
	0
    },
    {
	"XmTemplateDialog",
	KlTemplateDialog,
	"TemplateDialog",
	NULL,
	0
    },
    {
	"XmPanedWindow",
	KlPanedWindow,
	"PanedWindow",
	NULL,
	0
    },
    {
	"XmPushButton",
	KlPushButton,
	"PushButton",
	NULL,
	0
    },
    {
	"XmVPack",
	KlVerticalPacker,
	"VPack",
	NULL,
	0
    },
    {
	"XmHPack",
	KlHorizontalPacker,
	"HPack",
	NULL,
	0
    },
    {
	"XmRowColumn",
	KlRowColumn,
	"RowColumn",
	NULL,
	0
    },
    {
	"XmWorkArea",
	KlWorkArea,
	"WorkArea",
	NULL,
	0
    },
    {
	"XmRadioBox",
	KlRadioBox,
	"RadioBox",
	NULL,
	0
    },
    {
	"XmOptionMenu",
	KlOptionMenu,
	"OptionMenu",
	NULL,
	0
    },
    {
	"XmMenuBar",
	KlMenuBar,
	"MenuBar",
	NULL,
	0
    },
    {
	"XmPopupMenu",
	KlPopupMenu,
	"PopupMenu",
	NULL,
	0
    },
    {
	"XmPulldownMenu",
	KlPulldownMenu,
	"PulldownMenu",
	NULL,
	0
    },
    {
	"XmScale",
	KlScale,
	"Scale",
	NULL,
	0
    },
    {
	"XmScrollBar",
	KlScrollBar,
	"ScrollBar",
	NULL,
	0
    },
    {
	"XmScrolledWindow",
	KlScrolledWindow,
	"ScrolledWindow",
	NULL,
	0
    },
    {
	"XmSelectionBox",
	KlSelectionBox,
	"SelectionBox",
	NULL,
	0
    },
    {
	"XmSelectionDialog",
	KlSelectionDialog,
	"SelectionDialog",
	NULL,
	0
    },
    {
	"XmPromptDialog",
	KlPromptDialog,
	"PromptDialog",
	NULL,
	0
    },
    {
	"XmSeparator",
	KlSeparator,
	"Separator",
	NULL,
	0
    },
    {
	"XmScrolledText",
	KlScrolledText,
	"ScrolledText",
	NULL,
	0
    },
    {
	"XmText",
	KlText,
	"Text",
	NULL,
	0
    },
    {
	"XmTextField",
	KlTextField,
	"TextField",
	NULL,
	0
    },
    {
	"XmToggleButton",
	KlToggleButton,
	"ToggleButton",
	NULL,
	0
    },
};


void
KlRegisterWidgetClasses()
{
    Cardinal n;
    KlList list;

    list = KlListNMake(0);
    classes_table = KlHashMake(list);
    KlIncRef(classes_table);
    classes_table->ref_counted &= ~(KlHashRefK | KlHashRefV);
    for(n = 0;  n < XtNumber(classes); n++) {
	KlDeclareSubr(classes[n].constructor, classes[n].name, 2);
	KlHashPut(classes_table,
		  XrmStringToQuark(classes[n].class),
		  &(classes[n]));
    }
}    



KlWidgetClass
KlGetWidgetClass(KlWidget klw)
{
    char *name;
    name = klw->w->core.widget_class->core_class.class_name;
    return (KlWidgetClass) KlHashGet(classes_table,
				     XrmStringToQuark(name),
				     NULL);
}    
