/* Copyright 1995 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: getval.c,v 0.0.1.1 1995/04/07 12:06:49 oarsac Exp $ */


#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include "kl_widget.h"
#include "kl_classes.h"
#include "kl_convert.h"


char *Tm_Resource;		/* required for some converters */

typedef KlO (*KlConverterProc)(Widget w, String value);
typedef KlO (*KlWidgetProc)(Widget w);

typedef struct _KlConverterRec {
    String type;		/* representation type */
    String from;		/* representation used for SetVal conversion */
    String to;			/* representation used for GetVal conversion */
    KlConverterProc proc;	/* post conversion proc */
} KlConverterRec, *KlConverter;


typedef struct _KlPseudoResourceRec {
    String name;
    KlWidgetProc proc;
} KlPseudoResourceRec, KlPseudoResource;


KlO
CvtStringToKlNumber(String value)
{
    return (KlO) KlNumberMake(atoi(value));
}    


KlO
CvtStringToKlBoolean(Widget w, String value)
{
    if ( ! strcmp (value, "true"))
	return TRU;
    else
	return NIL;
}


/* some converters returns a KlO. use this post conversion function to return
   the value "as is" */
KlO
CvtAsIs(Widget w, String value)
{
    return (KlO)value;
}    



/* special converters table. Could be a Hash table maybe. */
/* This table contains the get and set representation types that are expected.
   from is unused. to contains the representation type that must be returned by
   XtGetValue. The default type (if a reprensentation is not found) is
   XtString. The postConverter field specifies a conversion routine that may be
   call after XtGetValue and before returning result. */
static KlConverterRec converters[] = {
    {	XmRDimension,		0,	XtRKlNumber,	0    },
    {	XmRHorizontalDimension,	0,	XtRKlNumber,	0    },
    {	XmRVerticalDimension,	0,	XtRKlNumber,	0    },    
    {	XmRInt,			0,	XtRKlNumber,	0    },
    {	XmRCardinal,		0,	XtRKlNumber,	0    },
    {	XmRHorizontalInt,	0,	XtRKlNumber,	0    },
    {	XmRVerticalInt,		0,	XtRKlNumber,	0    },
    {	XmRPosition,		0,	XtRKlNumber,	0    },
    {	XmRHorizontalPosition,	0,	XtRKlNumber,	0    },
    {	XmRVerticalPosition,	0,	XtRKlNumber,	0    },
    {	XmRTextPosition,	0,	XtRKlNumber,	0    },
    {	XmRShort,		0,	XtRKlNumber,	0    },
    {	XmRBooleanDimension,	0,	XtRKlNumber,	0    },

    {	XmRSet, XtRString, XtRString, CvtStringToKlBoolean  },
    {	XmRSet, XtRString, XtRString, CvtStringToKlBoolean  },
    
    {	XmRXmStringTable, XtRString, XtRString, CvtAsIs  },
    {	XmRWidgetList, XtRString, XtRKlList, CvtAsIs  },
};




/* pseudo resources table: These resource are used to access special values
   from widgets */
static KlPseudoResourceRec pseudo_resources[] = {
    {	"name", 	KlWidgetGetName,	},
    {	"parent", 	KlWidgetGetParent,	},
    {	"class", 	KlWidgetGetClass,	},
    {	"window", 	KlWidgetGetWindow,	},
    {	"managed", 	KlWidgetIsManaged,	},
    {	"realized", 	KlWidgetIsRealized,	},
};





KlO
KlWidgetGetValue(KlWidget klw, char *name)
{
    char *value = NULL;
    Cardinal i;
    KlWidgetClass wc = NULL;
    XtResource *res;
    KlConverter conv;
    XtResourceList resources;
    Cardinal num;
    Boolean need_free = False;

    wc = (KlWidgetClass)KlGetWidgetClass(klw);
    if(wc && wc->resources) {
	/* We cache the per class resource list, so that we do it only once for
           each class. The resource list is kept in the class record. */
	resources = wc->resources;
	num = wc->num;
    }
    else {
	XtGetResourceList(klw->w->core.widget_class,
			  &resources, &num);
	if(wc) {
	    wc->resources = resources;
	    wc->num = num;
	}
	else {
	    need_free = True;
	}
    }
    res = NULL;
    for(i = 0; i < num; i++) {
	if ( ! strcmp (resources[i].resource_name, name)) {
	    res = &(resources[i]);
	}
    }
    if(! res) {
	/* if the resource is not found, It may be a klm pseudo resource */
	for(i = 0; i < XtNumber(pseudo_resources); i++) {
	    if ( ! strcmp (pseudo_resources[i].name, name)) {
		return (*(pseudo_resources[i].proc))(klw->w);
	    }
	}
    }
    if(! res) {
	fprintf(stderr, "klm: Cannot find resource named '%s'.\n", name);
	return NIL;
    }
    /* Is there a special converter for this rep type ? */
    conv = NULL;
    for(i = 0; i < XtNumber(converters); i++) {
	if ( ! strcmp (converters[i].type, res->resource_type)) {
	    conv = &(converters[i]);
	    break;
	}
    }
    Tm_Resource = name;
    XtVaGetValues(klw->w, XtVaTypedArg,
		  name, (conv ? conv->to : XtRString),
		  (XtArgVal)&value, sizeof(char *),
		  0);

    if(need_free) {
	XtFree ((char *) resources);
    }
    if(! value)
	return NIL;
    if(conv && conv->proc) {
	/* there is a post converter, call it */
	return (*conv->proc)(klw->w, value);
    }
    if(!conv || (! strcmp(conv->to, XtRString))) {
	/* If There is no special converter, or if the returned type is a
           String, build a KlO */
	return (KlO)KlStringMake(value);
    }
    /* else, the returned value is already a KlO */
    return (KlO)value;
}    





