#ifndef EMLINK_H
#define EMLINK_H
#include "struct.h"

typedef struct EmLinkTable {
    AssocTable *patLeftToRight;
    AssocTable *patRightToLeft;
}           EmLinkTable;


typedef int (*EmLinkCmpFunc) (void *, void *);
typedef int (*EmLinkHashFunc) (void *);
typedef void (*EmLinkFreeFunc) (void *);
typedef void (*EmLinkPrintFunc) (void *);



/**************************************************************** Prototypes */


/* Given the left part of a link
 *
 * Return:  The right one if any
 */
void * EmLinkGetRight ( EmLinkTable * plt, void *pLeft );

/* Given the right part of a link
 *
 * Return: The left one if any
 */
void * EmLinkGetLeft ( EmLinkTable * plt, void *pRight );

/* Make a link between left and right
 *
 * Warning: links using these parts are losts.
 * Use EmAlreadyLinked to check it before
 *
 * Example: link("a","b"); link("z","b") getleft("b")->"z"; "a" is lost
 */
void EmLinkMake ( EmLinkTable * plt, void *pLeft, void *pRight );

/* Check if one of these two parts is already linked in plt
 */
Bools EmAlreadyLinked ( EmLinkTable * plt, void *pLeft, void *pRight );

/* See printLeft. The same
		      but on the right part. */
EmLinkTable * EmLinkTableCreate ( int size, EmLinkCmpFunc compareLeft, EmLinkCmpFunc compareRight, EmLinkHashFunc hashLeft, EmLinkHashFunc hashRight, EmLinkFreeFunc freeLeft, EmLinkFreeFunc freeRight, EmLinkPrintFunc printLeft, EmLinkPrintFunc printRight );

/* Free a EmLinkTable (call free on its two hashtables)
 */
void EmLinkTableFree ( EmLinkTable * plt );

/************************************************************ End Prototypes */



#endif					/* EMLINK_H */
