#include "emall.h"

/* ?? TODO replace the std hashtable with a dynamic one */

static HashTable *AHashTable;


/**************************************************************** Prototypes */

/* hash an EmAttrib variable
 */
static int EmHashAttrib ( EmAttrib * pa, int sz );
/* sort two EmAttrib variables
 */
static int EmOrdAttribVal ( EmAttrib * pa1, EmAttrib * pa2 );

/******************************************************************** Bodies */

/* */

/* hash an EmAttrib variable
 */
static int
EmHashAttrib(EmAttrib * pa, int sz)
{
    int s = 0;
    char *pc;

    pc = pa->pname;
    while (*pc)
	s += *(pc++);

    return (s + (int) pa->pgrp + (int) pa->pnod) % sz;
}

/* sort two EmAttrib variables
 */
static int
EmOrdAttribVal(EmAttrib * pa1, EmAttrib * pa2)
{
    return ((pa1->pnod - pa2->pnod) + (pa1->pgrp - pa2->pgrp) + strcmp(pa1->pname, pa2->pname));
}

/* Add an attribute and its value into the AHashTable.
 */
void
EmAHashPut(EmAttrib * pa)
{
    EmAttrib *paDup;


    if (!pa->pgrp)
	pa->pgrp = EmRootGroup;
    paDup = UNew(EmAttrib);
    *paDup = *pa;
    paDup->pname = UStrDup(pa->pname);
    KlIncRef(pa->val);
    htInsert(AHashTable, paDup, True);
}

/* Get an attributes's value from the AHashTable.
 */
EmAttrib *
EmAHashGet(EmAttrib * pa)
{
    if (!pa->pgrp)
	pa->pgrp = EmRootGroup;
    return htSearchKey(AHashTable, pa);
}

/* Delete an attribute from the AHashTable.
 * Attribute is freed if needed (Klone GC).
 */
void
EmAHashDel(EmAttrib * pa)
{
    if (!pa->pgrp)
	pa->pgrp = EmRootGroup;
    /* ?? TODO decref */
    htDelKey(AHashTable, pa, True);
}

/* Init the AHashTable.
 */
void
EmAHashInit(void)
{
    AHashTable = htCreate(1000, keySame, EmOrdAttribVal, EmFreeAttrib, EmHashAttrib, EmPrintAttrib);
}
