#ifndef EMCOMM_H
#define EMCOMM_H

#include "emall.h"

#define EmCheckError(f) {int ECEStatus; if((ECEStatus=(f))){EmCommErrorKl(ECEStatus);return NIL;}}

/**************************************************************** Prototypes */


/* Call KlError. */
int EmCommErrorKl ( int errCode );

/* Init the server.
 *
 * Must be called before any call to other function of this lib.
 *
 * Return: NIL
 *
 * Warning: This function set the signal handler for SIG_PIPE to SIG_IGN
 *
 * Wrapper: for int USInit(int portNum, char *serverName);
 */
KlO EmInitCommServKl ( KlO portNum, KlO serverName );

/* The line */
KlO EmCloseLineKl ( KlO id );

/* Check if new applications are requesting for lines.
 * Accept the first one.
 *
 * Return: return the id of the first line or NIL if none
 *
 * Warning: This function must be called periodicaly to insure that connection
 * requests aren't ignored.
 *
 * Wrapper: for int USAcceptNewLine(int *pId, int *pGotLine);
 */
KlO EmAcceptNewLineKl ( void );

/* Wait until new applications are requesting for lines.
 * Accept the first one and return its id
 *
 * Warning: this function is blocking
 *
 * Wrapper: for int USWaitForNewLine(int *pId, int *pGotLine);
 */
KlO EmWaitForNewLineKl ( void );

/* Send a message (on at least store it in a buffer).
 *
 * Return: NIL
 *
 * Wrapper: for int USSend(int id, void *msg, int len);
 */
KlO EmSendKl ( KlO id, KlO msg );

/* Send all messages which may have been buffered by server line (id) (if any)
 * (ie flush actual packet (if needed)).
 *
 * Return: NIL
 *
 * Wrapper: for int USFlush(int id);
 */
KlO EmFlushKl ( KlO id );

/* Flush messages waiting to be send for all clients.
 *
 * Return: NIL
 *
 * Wrapper for :int USFlushAllClients(void);
 */
KlO EmFlushAllClientsKl ( void );

/* How many messages are waiting for a read.
 *
 * Return imediatly if messages are already queued.
 * If no message queued, flush buffer and wait for roundtrip
 * (ie be sure no message are kept in other line end buffer).
 *
 * Return: number of waiting mesg
 *
 * Warning: may block a bit if correspondant is too busy.
 *
 * Wrapper: for int USPendingMsg(int id, int *pNbMsg);
 */
KlO EmPendingMsgKl ( KlO id );

/*
 * How many messages are waiting for a read
 *
 * Checks for waiting packets abd return
 * nether blocks
 *
 * Return: number of waiting mesg.
 *
 * Wrapper: for int USCheckPendingMsg(int id, int *pNbMsg);
 */
KlO EmCheckPendingMsgKl ( KlO id );

/* Checks if there is something waiting for a read on all connected lines.
 *
 * Do the check as fast as possible (only one select)
 * nether blocks
 *
 * Wrapper: for int USCheckAllLines(int *pIsMsg);
 */
KlO EmCheckAllLinesKl ( void );

/* Get next message.
 *
 * If no message in waiting queue;
 * Flush this line-end
 * Make periodics roundtrip to insure no messages are in buffer at the
 * other line-end
 *
 * Return: got message.
 *
 * Warning: It's a blocking call.
 *
 * Wrapper: for int USGetNextMsg(int id, char **ppMsg, int *pLen);
 */
KlO EmGetNextMsgKl ( KlO id );

/* Peek next message (message is not removed from queue).
 *
 * If no message in waiting queue;
 * Flush this line-end
 * Make periodics roundtrip to insure no messages are in buffer at the
 * other line-end
 *
 * Return: NIL or message.
 *
 * Warning: It's a blocking call.
 *
 * Wrapper: for int USPeekNextMsg(int id, char **ppMsg, int *pLen);
 */
KlO EmPeekNextMsgKl ( KlO id );

/* String which must be the head of
			    matching message */
KlO EmGetFirstMatchingMsgKl ( KlO id, KlO head );

/* String which must be the head of
			     matching message */
KlO EmPeekFirstMatchingMsgKl ( KlO id, KlO head );

/* Return id associated to line nammed (lineName)
 * or NIL if no such line.
 *
 * Wrapper: for int USNameToId(char *lineName);
 */
KlO EmNameToCommIdKl ( KlO lineName );

/* Return name of line identified by id
 * or NIL if no such line.
 *
 * Wrapper for :char *USIdToName(int id);
 */
KlO EmIdToNameKl ( KlO id );

/* Init the communication module.
 */
void EmCommInit ( void );

/************************************************************ End Prototypes */

#endif					/* EMCOMM_H */
