#include "emall.h"


/**************************************************************** Prototypes */

/* auxiliary function
 */
static EmAttrib * EmAGetAux ( EmAttrib * pa );
/* auxiliary function
 */
static void EmASetAux ( EmAttrib * pa );

/******************************************************************** Bodies */

/* Free an attrib
 */
void
EmFreeAttrib(EmAttrib * pa)
{
    free(pa->pname);
    if (pa->val)
	KlDecRef(pa->val);
    free(pa);
}

/* Print an attrib
 */
void
EmPrintAttrib(EmAttrib * pa /* attribute to print */ ,
	      int printVal /* if not 0 print value of attribute */ )
{
    if (pa) {
	printf("(g)%s ", (char *) EmLinkGetRight(EmGroupNameLink, pa->pgrp));
	if (pa->pnod)
	    printf("(n)%d(%s) %s : ", pa->pnod, EmNodeTypeToString(pa->pnod->type), pa->pname);
	else
	    printf("(n)gate %s : ", pa->pname);
	if (printVal) {
	    if (pa->val)
		KlPrint(pa->val);
	    else
		printf("(NULL)");
	}
    }
    else
	printf("(EmAttrib* NULL)");
}

/* Get value of an attrib but only if it is localy set
 * (ie no inheritance using node/group trees)
 */
EmAttribVal
EmAGetLocal(EmAttrib * pa)
{
    EmAttrib *pares;
    char trace = 0;

    if (!pa->pgrp)
	pa->pgrp = EmRootGroup;
    pares = (EmAttrib *) EmAHashGet(pa);
#ifdef TRACE_ATTRIB_GET
    if (strncmp(pa->pname, "**", 2)) {
	if (!pares) {
	    printf("Warning: get failed: ");
	    EmPrintAttrib(pa, 0);
	    printf("\n");
	}
	else {
	    if (!EmAGetC(pa->pgrp, pa->pnod, "**tg-all")) {
		char n[MAX_CHAR_TMP];	/* ?? grumpf... alloca? */

		strcpy(n, "**tg-");
		strcat(n, pa->pname);
		if (EmAGetC(pa->pgrp, pa->pnod, n))
		    trace = 1;
	    }
	    else
		trace = 1;
	    if (trace) {
		printf("get: ");
		EmPrintAttrib(pares, 1);
		printf("\n");
	    }
	}
    }
#endif
    return (pares) ? pares->val : (EmAttribVal) NULL;
}


/* See EmAGetLocal. this version is designed to be called from C.
 */
EmAttribVal
EmAGetLocalC(EmGroup * pg /* group searched */ ,
	     EmNode * pn		/* nod searched (or NIL for gate
	         node) */ ,
	     char *pname /* name of the searched attribute */ )
{
    EmAttrib atmp;

    atmp.pgrp = pg;
    atmp.pnod = pn;
    atmp.pname = pname;
    return EmAGetLocal(&atmp);
}

/* Wrapper:
 */
KlO
EmAGetLocalKl(KlO grp, KlO nod, KlO name)
{
    KlO ro;
    EmAttrib atmp;

    KlMustBeIntOrConstInt(grp, 0);
    if (KlFalseP(nod)) {
	atmp.pnod = NULL;
    }
    else {
	KlMustBeIntOrConstInt(nod, 1);
	atmp.pnod = KlNumToPtr(nod);
    }
    KlMustBeStringOrConstString(name, 2);
    atmp.pgrp = KlNumToPtr(grp);
    atmp.pnod = KlNumToPtr(nod);
    atmp.pname = KlStringToCharPtr(name);
    ro = EmAGetLocal(&atmp);
    if (ro) {
	return ro;
    }
    return NIL;
}

/* auxiliary function
 */
static EmAttrib *
EmAGetAux(EmAttrib * pa)
{
    EmAttrib *pares = NULL;

    while (!pares && pa->pnod) {
	pares = EmAHashGet(pa);
	pa->pnod = EmFatherNode(pa->pnod);
    }
    if (!pares)				/* think to check the root node (ie
					 * NULL node) */
	pares = EmAHashGet(pa);
    return pares;
}

/* Get an attribute.
 * if attribute is not set on the requested node search through all
 * the ancestors of this node.
 * if didn't sucess then restart on this node but using the father of
 * requested group (and so on until rootGroup is reached or attribute is found)
 * return NULL if nothing found
 */
EmAttribVal
EmAGet(EmAttrib * pa)
{
    EmNode *pn;
    EmAttrib *pares = NULL;
    char trace = 0;

    if (!pa->pgrp)
	pa->pgrp = EmRootGroup;
    pa->val = NULL;
    pn = pa->pnod;
    while (!pares && pa->pgrp) {
	pares = EmAGetAux(pa);
	pa->pnod = pn;
	pa->pgrp = EmFatherGroup(pa->pgrp);
    }
#ifdef TRACE_ATTRIB_GET
    if (strncmp(pa->pname, "**", 2)) {
	if (!pares) {
	    printf("Warning: get failed: ");
	    EmPrintAttrib(pa, 0);
	    printf("\n");
	}
	else {
	    if (!EmAGetC(pa->pgrp, pa->pnod, "**tg-all")) {
		char n[MAX_CHAR_TMP];	/* ?? grumpf... alloca? */

		strcpy(n, "**tg-");
		strcat(n, pa->pname);
		if (EmAGetC(pa->pgrp, pa->pnod, n))
		    trace = 1;
	    }
	    else
		trace = 1;
	    if (trace) {
		printf("get: ");
		EmPrintAttrib(pares, 1);
		printf("\n");
	    }
	}
    }
#endif
    return (pares) ? pares->val : (EmAttribVal) NULL;
}


/* See EmAGet. this version is designed to be called from C.
 */
EmAttribVal
EmAGetC(EmGroup * pg /* group searched */ ,
	EmNode * pn			/* nod searched (or NIL for gate
	    node) */ ,
	char *pname /* name of the searched attribute */ )
{
    EmAttrib atmp;

    atmp.pgrp = pg;
    atmp.pnod = pn;
    atmp.pname = pname;
    return EmAGet(&atmp);
}

/* Wrapper:
 */
KlO
EmAGetKl(KlO grp /* group searched */ ,
	 KlO nod			/* nod searched (or NIL for gate
	     node) */ ,
	 KlO name /* name of the searched attribute */ )
{
    KlO ro;
    EmAttrib atmp;
    EmAttrib *pares = NULL;

    if (KlFalseP(grp)) {
	atmp.pgrp = NULL;
    }
    else {
	KlMustBeIntOrConstInt(grp, 0);
	atmp.pgrp = KlNumToPtr(grp);
    }

    if (KlFalseP(nod)) {
	atmp.pnod = NULL;
    }
    else {
	KlMustBeIntOrConstInt(nod, 1);
	atmp.pnod = KlNumToPtr(nod);
    }

    KlMustBeStringOrConstString(name, 2);
    atmp.pname = KlStringToCharPtr(name);

    ro = (KlO) EmAGet(&atmp);
    return (ro) ? ro : NIL;
}

/* Set an attribute value (but localy, don't overwrite instance of same
 * attribute which may be set lower in the inheritance tree
 */
void
EmASetLocal(EmAttrib * pa,
	    EmAttribVal val)
{

    if (!pa->pgrp)
	pa->pgrp = EmRootGroup;
    pa->val = val;
    EmAHashPut(pa);
#ifdef TRACE_ATTRIB_SET
    if (!EmAGetC(pa->pgrp, pa->pnod, "**ts-all")) {
	char n[MAX_CHAR_TMP];

	strcpy(n, "**ts-");
	strcat(n, pa->pname);
	if (!EmAGetC(pa->pgrp, pa->pnod, n))
	    return;
    }
    printf("set local: ");
    EmPrintAttrib(pa, 1);
    printf("\n");
#endif
}

/* Wrapper:
 */
KlO
EmASetLocalKl(KlO grp /* group searched */ ,
	      KlO nod			/* nod searched (or NIL for gate
	          node) */ ,
	      KlO name /* name of the searched attribute */ ,
	      KlO val /* value to set */ )
{
    EmAttrib atmp;

    if (KlFalseP(grp)) {
	atmp.pgrp = NULL;
    }
    else {
	KlMustBeIntOrConstInt(grp, 0);
	atmp.pgrp = KlNumToPtr(grp);
    }

    if (KlFalseP(nod)) {
	atmp.pnod = NULL;
    }
    else {
	KlMustBeIntOrConstInt(nod, 1);
	atmp.pnod = KlNumToPtr(nod);
    }
    KlMustBeStringOrConstString(name, 2);
    atmp.pgrp = KlNumToPtr(grp);
    atmp.pnod = KlNumToPtr(nod);
    atmp.pname = KlStringToCharPtr(name);
    EmASetLocal(&atmp, val);
    KlIncRef(val);
    return val;
}


/* See EmASetLocal. this version is designed to be called from C.
 */
void
EmASetLocalC(EmGroup * pg /* group searched */ ,
	     EmNode * pn		/* nod searched (or NIL for gate
	         node) */ ,
	     char *pname /* name of the searched attribute */ ,
	     EmAttribVal val /* value to set */ )
{
    EmAttrib atmp;

    atmp.pgrp = pg;
    atmp.pnod = pn;
    atmp.pname = pname;
    EmASetLocal(&atmp, val);
}


/* auxiliary function
 */
static void
EmASetAux(EmAttrib * pa)
{
    int nbs, i;
    EmAttrib atmp;

    atmp = *pa;
    EmAHashDel(pa);
    nbs = EmNbSonGroups(pa->pgrp);
    for (i = 0; i < nbs; i++) {
	if ((atmp.pgrp = EmNthSonGroup(pa->pgrp, i))) {
	    EmASetAux(&atmp);
	}
    }
}


/* Set an attribute value
 * overwrite instance of same attribute which may be set lower
 * in the inheritance group tree
 */
void
EmASet(EmAttrib * pa /* attribute to set */ ,
       EmAttribVal val /* value to set */ )
{
    if (!pa->pgrp)
	pa->pgrp = EmRootGroup;
    pa->val = val;
    EmASetAux(pa);
    EmAHashPut(pa);
#ifdef TRACE_ATTRIB_SET
    if (!EmAGetC(pa->pgrp, pa->pnod, "**ts-all")) {
	char n[MAX_CHAR_TMP];

	strcpy(n, "**ts-");
	strcat(n, pa->pname);
	if (!EmAGetC(pa->pgrp, pa->pnod, n))
	    return;
    }
    printf("set: ");
    EmPrintAttrib(pa, 1);
    printf("\n");
#endif
}

/* Wrapper:
 */
KlO
EmASetKl(KlO grp			/* group searched (or NIL for root
	     group) */ ,
	 KlO nod			/* nod searched (or NIL for gate
	     node) */ ,
	 KlO name /* name of the searched attribute */ ,
	 KlO val /* value to set */ )
{
    EmAttrib atmp;

    if (KlFalseP(grp)) {
	atmp.pgrp = NULL;
    }
    else {
	KlMustBeIntOrConstInt(grp, 0);
	atmp.pgrp = KlNumToPtr(grp);
    }

    if (KlFalseP(nod)) {
	atmp.pnod = NULL;
    }
    else {
	KlMustBeIntOrConstInt(nod, 1);
	atmp.pnod = KlNumToPtr(nod);
    }

    KlMustBeStringOrConstString(name, 2);
    atmp.pname = KlStringToCharPtr(name);

    EmASet(&atmp, val);
    KlIncRef(val);
    return val;
}

/* See EmASet. this version is designed to be called from C.
 */
void
EmASetC(EmGroup * pg, EmNode * pn, char *pname, EmAttribVal val)
{
    EmAttrib atmp;

    atmp.pgrp = pg;
    atmp.pnod = pn;
    atmp.pname = pname;
    EmASet(&atmp, val);
}



/* Unset an attribute (but localy, don't unset instance of same
 * attribute which may be set lower in the inheritance tree
 */
void
EmAUnsetLocal(EmAttrib * pa)
{

    if (!pa->pgrp)
	pa->pgrp = EmRootGroup;
    pa->val = NULL;
    EmAHashDel(pa);
#ifdef TRACE_ATTRIB_SET
    if (!EmAGetC(pa->pgrp, pa->pnod, "**tus-all")) {
	char n[MAX_CHAR_TMP];

	strcpy(n, "**tus-");
	strcat(n, pa->pname);
	if (!EmAGetC(pa->pgrp, pa->pnod, n))
	    return;
    }
    printf("unset local: ");
    EmPrintAttrib(pa, 0);
    printf("\n");
#endif
}

/* Wrapper:
 */
KlO
EmAUnsetLocalKl(KlO grp /* group searched */ ,
		KlO nod			/* nod searched (or NIL for gate
		    node) */ ,
		KlO name /* name of the searched attribute */ )
{
    EmAttrib atmp;

    if (KlFalseP(grp)) {
	atmp.pgrp = NULL;
    }
    else {
	KlMustBeIntOrConstInt(grp, 0);
	atmp.pgrp = KlNumToPtr(grp);
    }

    if (KlFalseP(nod)) {
	atmp.pnod = NULL;
    }
    else {
	KlMustBeIntOrConstInt(nod, 1);
	atmp.pnod = KlNumToPtr(nod);
    }
    KlMustBeStringOrConstString(name, 2);
    atmp.pgrp = KlNumToPtr(grp);
    atmp.pnod = KlNumToPtr(nod);
    atmp.pname = KlStringToCharPtr(name);
    EmAUnsetLocal(&atmp);
    return NIL;
}



/* Unset an attribute value
 * unset instance of same attribute which may be set lower
 * in the inheritance group tree
 */
void
EmAUnset(EmAttrib * pa /* attribute to set */ )
{
    if (!pa->pgrp)
	pa->pgrp = EmRootGroup;
    pa->val = NULL;
    EmASetAux(pa);
    EmAUnsetLocal(pa);
}

/* Wrapper:
 */
KlO
EmAUnsetKl(KlO grp			/* group searched (or NIL for root
	       group) */ ,
	   KlO nod			/* nod searched (or NIL for gate
	       node) */ ,
	   KlO name /* name of the searched attribute */ )
{
    EmAttrib atmp;

    if (KlFalseP(grp)) {
	atmp.pgrp = NULL;
    }
    else {
	KlMustBeIntOrConstInt(grp, 0);
	atmp.pgrp = KlNumToPtr(grp);
    }

    if (KlFalseP(nod)) {
	atmp.pnod = NULL;
    }
    else {
	KlMustBeIntOrConstInt(nod, 1);
	atmp.pnod = KlNumToPtr(nod);
    }

    KlMustBeStringOrConstString(name, 2);
    atmp.pname = KlStringToCharPtr(name);

    EmAUnset(&atmp);
    return NIL;
}


/* Initialize all attributes functions for Klone
 */
void
EmAttribInit(void)
{
    EmAHashInit();
    KlDeclareSubr(EmAGetLocalKl, "aget-local", 3);
    KlDeclareSubr(EmAGetKl, "aget", 3);
    KlDeclareSubr(EmASetLocalKl, "aset-local", 4);
    KlDeclareSubr(EmASetKl, "aset", 4);
    KlDeclareSubr(EmAUnsetLocalKl, "aunset-local", 3);
    KlDeclareSubr(EmAUnsetLocalKl, "aunset", 3);
}
