#include <X11/Intrinsic.h>
#include "emall.h"

Display *EmDisplay;			/* ?? remove */

/* how many dispatch before assuming that there is a cycle in last installed translation table */
#define MAX_DISPATCH_TRY 10

/* maximum number of fields in a XEvent struct */
#define MAX_SLOT_XEVENT 15

/**************************************************************** Prototypes */

/* Define all XEvents Class.
 */
static void EmXEventsClassMake(void);

/* Setq symbols for all useful X Masks.
 */
static void EmDefXEventMask(void);

/* Setq symbols for all useful XEvents Types.
 */
static void EmDefXEventType(void);

/* Wrapper:
 * like XSelectInput
 * (done on EmDisplay sorry ;)
 */
static KlO EmXSelectInputKl(KlO window, KlO mask);

/* Wrapper:
 * like XSync(EmDisplay, False);
 */
static KlO EmXSyncKl(void);

/* set or unset synchronization (t or
		     ()) */
static KlO EmXSynchronizeKl(KlO onOff);

/* Wrapper:
 * like XPending(EmDisplay)
 */
static KlO EmXPendingKl(void);

/* Wrapper:
 * like XNextEvent
 */
static KlO EmXNextEventKl(void);

/* event mask to apply */
static KlO EmXCheckWindowEventKl(KlO window, KlO mask);

/* Wrapper:
 * like XLookupString
 */
static KlO EmXLookupStringKl(KlO ev);

/* Wrapper: for XDrawLine(d, gc, x1, y1, x2, y2)
 */
static KlO EmXDrawLineKl(int argc, KlO * argv);

/* Wrapper: for XBell(display, percent)
 */
static KlO EmXBellKl(KlO dpy, KlO num);

/* Dispatch all pending X events using Xt mechanism
 *
 * call XtDispatchEvent while attrib *dont-gobble-event*
 * is set on group corresponding to widget concerned by event.
 */
static KlO EmXTDispatchEventsKl(void);

/* preparse an Xt translation table (aka xttt) given in its human readable form
 */
static KlO EmXTParseTranslationTableKl(KlO xttt);

/* the preparsed xt translation table
			          to install */
static KlO EmXTInstallTranslationTableKl(KlO widget, KlO xttt);

/* install xttt on this
				    widget */
static KlO EmXTUninstallTranslationTableKl(KlO widget);

/******************************************************************** Bodies */

/* X and Xt structs for Klone */


/* XEvents equivalent Class for Klone */
KlStructClass EmXKeyEventClass;
KlStructClass EmXButtonEventClass;
KlStructClass EmXMotionEventClass;
KlStructClass EmXGraphicsExposeEventClass;
KlStructClass EmXCreateWindowEventClass;
KlStructClass EmXCrossingEventClass;
KlStructClass EmXFocusChangeEventClass;
KlStructClass EmXKeymapEventClass;
KlStructClass EmXExposeEventClass;
KlStructClass EmXNoExposeEventClass;
KlStructClass EmXVisibilityEventClass;
KlStructClass EmXDestroyWindowEventClass;
KlStructClass EmXUnmapEventClass;
KlStructClass EmXMapEventClass;
KlStructClass EmXMapRequestEventClass;
KlStructClass EmXReparentEventClass;
KlStructClass EmXConfigureEventClass;
KlStructClass EmXGravityEventClass;
KlStructClass EmXResizeRequestEventClass;
KlStructClass EmXConfigureRequestEventClass;
KlStructClass EmXCirculateEventClass;
KlStructClass EmXCirculateRequestEventClass;
KlStructClass EmXPropertyEventClass;
KlStructClass EmXSelectionClearEventClass;
KlStructClass EmXSelectionRequestEventClass;
KlStructClass EmXColormapEventClass;
KlStructClass EmXMappingEventClass;
KlStructClass EmXSelectionEventClass;
KlStructClass EmXErrorEventClass;
KlStructClass EmXAnyEventClass;

/* must be bigger than any event # */
#define MAX_XEVENT_TYPE LASTEvent
/* used for an easy access to Class definitions */
KlStructClass EmXEventClassArray[MAX_XEVENT_TYPE];


/* Define all XEvents Class.
 */
static void
EmXEventsClassMake(void)
{
#define EmDeclareXEventField(evType, type,  name, field) \
    KlDeclareStructClassSlot(Em##evType##Class, name, \
			     KlStructAccessorScalar[sizeof(type)], \
			     KlOffsetOf(evType,field), 0)





    /* XKeyEvent */

#define EmXKeyEventSlotsNumber 15
    KlIncRef(EmXKeyEventClass = KlStructClassMake("XKey", sizeof(XKeyEvent), EmXKeyEventSlotsNumber));
    EmXEventClassArray[KeyPress] = EmXKeyEventClass;
    EmXEventClassArray[KeyRelease] = EmXKeyEventClass;
    EmDeclareXEventField(XKeyEvent, int, "type", type);
    EmDeclareXEventField(XKeyEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XKeyEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XKeyEvent, Display *, "display", display);
    EmDeclareXEventField(XKeyEvent, Window, "window", window);
    EmDeclareXEventField(XKeyEvent, Window, "root", root);
    EmDeclareXEventField(XKeyEvent, Window, "subwindow", subwindow);
    EmDeclareXEventField(XKeyEvent, Time, "time", time);
    EmDeclareXEventField(XKeyEvent, int, "x", x);
    EmDeclareXEventField(XKeyEvent, int, "y", y);
    EmDeclareXEventField(XKeyEvent, int, "x_root", x_root);
    EmDeclareXEventField(XKeyEvent, int, "y_root", y_root);
    EmDeclareXEventField(XKeyEvent, unsigned int, "state", state);
    EmDeclareXEventField(XKeyEvent, unsigned int, "keycode", keycode);

    EmDeclareXEventField(XKeyEvent, Bool, "same_screen", same_screen);
#undef EmXKeyEventSlotsNumber


    /* XButtonEvent */

#define EmXButtonEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXButtonEventClass = KlStructClassMake("XButton", sizeof(XButtonEvent), EmXButtonEventSlotsNumber));
    EmXEventClassArray[ButtonPress] = EmXButtonEventClass;
    EmXEventClassArray[ButtonRelease] = EmXButtonEventClass;
    EmDeclareXEventField(XButtonEvent, int, "type", type);
    EmDeclareXEventField(XButtonEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XButtonEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XButtonEvent, Display *, "display", display);
    EmDeclareXEventField(XButtonEvent, Window, "window", window);
    EmDeclareXEventField(XButtonEvent, Window, "root", root);
    EmDeclareXEventField(XButtonEvent, Window, "subwindow", subwindow);
    EmDeclareXEventField(XButtonEvent, Time, "time", time);
    EmDeclareXEventField(XButtonEvent, int, "x", x);
    EmDeclareXEventField(XButtonEvent, int, "y", y);
    EmDeclareXEventField(XButtonEvent, int, "x_root", x_root);
    EmDeclareXEventField(XButtonEvent, int, "y_root", y_root);
    EmDeclareXEventField(XButtonEvent, unsigned int, "state", state);
    EmDeclareXEventField(XButtonEvent, unsigned int, "button", button);

    EmDeclareXEventField(XButtonEvent, Bool, "same_screen", same_screen);
#undef EmXButtonEventSlotsNumber


    /* XMotionEvent */

#define EmXMotionEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXMotionEventClass = KlStructClassMake("XMotion", sizeof(XMotionEvent), EmXMotionEventSlotsNumber));
    EmXEventClassArray[MotionNotify] = EmXMotionEventClass;
    EmDeclareXEventField(XMotionEvent, int, "type", type);
    EmDeclareXEventField(XMotionEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XMotionEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XMotionEvent, Display *, "display", display);
    EmDeclareXEventField(XMotionEvent, Window, "window", window);
    EmDeclareXEventField(XMotionEvent, Window, "root", root);
    EmDeclareXEventField(XMotionEvent, Window, "subwindow", subwindow);
    EmDeclareXEventField(XMotionEvent, Time, "time", time);
    EmDeclareXEventField(XMotionEvent, int, "x", x);
    EmDeclareXEventField(XMotionEvent, int, "y", y);
    EmDeclareXEventField(XMotionEvent, int, "x_root", x_root);
    EmDeclareXEventField(XMotionEvent, int, "y_root", y_root);
    EmDeclareXEventField(XMotionEvent, unsigned int, "state", state);
    EmDeclareXEventField(XMotionEvent, char, "is_hint", is_hint);

    EmDeclareXEventField(XMotionEvent, Bool, "same_screen", same_screen);
#undef EmXMotionEventSlotsNumber


    /* XCrossingEvent */

#define EmXCrossingEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXCrossingEventClass = KlStructClassMake("XCrossing", sizeof(XCrossingEvent), EmXCrossingEventSlotsNumber));
    EmXEventClassArray[EnterNotify] = EmXCrossingEventClass;
    EmXEventClassArray[LeaveNotify] = EmXCrossingEventClass;
    EmDeclareXEventField(XCrossingEvent, int, "type", type);
    EmDeclareXEventField(XCrossingEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XCrossingEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XCrossingEvent, Display *, "display", display);
    EmDeclareXEventField(XCrossingEvent, Window, "window", window);
    EmDeclareXEventField(XCrossingEvent, Window, "root", root);
    EmDeclareXEventField(XCrossingEvent, Window, "subwindow", subwindow);
    EmDeclareXEventField(XCrossingEvent, Time, "time", time);
    EmDeclareXEventField(XCrossingEvent, int, "x", x);
    EmDeclareXEventField(XCrossingEvent, int, "y", y);
    EmDeclareXEventField(XCrossingEvent, int, "x_root", x_root);
    EmDeclareXEventField(XCrossingEvent, int, "y_root", y_root);
    EmDeclareXEventField(XCrossingEvent, int, "mode", mode);
    EmDeclareXEventField(XCrossingEvent, int, "detail", detail);

    EmDeclareXEventField(XCrossingEvent, Bool, "same_screen", same_screen);
    EmDeclareXEventField(XCrossingEvent, Bool, "focus", focus);
    EmDeclareXEventField(XCrossingEvent, unsigned int, "state", state);

#undef EmXCrossingEventSlotsNumber


    /* XFocusChangeEvent */

#define EmXFocusChangeEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXFocusChangeEventClass = KlStructClassMake("XFocusChange", sizeof(XFocusChangeEvent), EmXFocusChangeEventSlotsNumber));
    EmXEventClassArray[FocusIn] = EmXFocusChangeEventClass;
    EmXEventClassArray[FocusOut] = EmXFocusChangeEventClass;
    EmDeclareXEventField(XFocusChangeEvent, int, "type", type);
    EmDeclareXEventField(XFocusChangeEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XFocusChangeEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XFocusChangeEvent, Display *, "display", display);
    EmDeclareXEventField(XFocusChangeEvent, Window, "window", window);
    EmDeclareXEventField(XFocusChangeEvent, int, "mode", mode);
    EmDeclareXEventField(XFocusChangeEvent, int, "detail", detail);

#undef EmXFocusChangeEventSlotsNumber


    /* XKeymapEvent */

#define EmXKeymapEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXKeymapEventClass = KlStructClassMake("XKeymap", sizeof(XKeymapEvent), EmXKeymapEventSlotsNumber));
    EmXEventClassArray[KeymapNotify] = EmXKeymapEventClass;
    EmDeclareXEventField(XKeymapEvent, int, "type", type);
    EmDeclareXEventField(XKeymapEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XKeymapEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XKeymapEvent, Display *, "display", display);
    EmDeclareXEventField(XKeymapEvent, Window, "window", window);
#undef EmXKeymapEventSlotsNumber


    /* XExposeEvent */

#define EmXExposeEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXExposeEventClass = KlStructClassMake("XExpose", sizeof(XExposeEvent), EmXExposeEventSlotsNumber));
    EmXEventClassArray[Expose] = EmXExposeEventClass;
    EmDeclareXEventField(XExposeEvent, int, "type", type);
    EmDeclareXEventField(XExposeEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XExposeEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XExposeEvent, Display *, "display", display);
    EmDeclareXEventField(XExposeEvent, Window, "window", window);
    EmDeclareXEventField(XExposeEvent, int, "x", x);
    EmDeclareXEventField(XExposeEvent, int, "y", y);
    EmDeclareXEventField(XExposeEvent, int, "width", width);
    EmDeclareXEventField(XExposeEvent, int, "height", height);
    EmDeclareXEventField(XExposeEvent, int, "count", count);

#undef EmXExposeEventSlotsNumber


    /* XGraphicsExposeEvent */

#define EmXGraphicsExposeEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXGraphicsExposeEventClass = KlStructClassMake("XGraphicsExpose", sizeof(XGraphicsExposeEvent), EmXGraphicsExposeEventSlotsNumber));
    EmXEventClassArray[GraphicsExpose] = EmXGraphicsExposeEventClass;
    EmDeclareXEventField(XGraphicsExposeEvent, int, "type", type);
    EmDeclareXEventField(XGraphicsExposeEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XGraphicsExposeEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XGraphicsExposeEvent, Display *, "display", display);
    EmDeclareXEventField(XGraphicsExposeEvent, Drawable, "drawable", drawable);
    EmDeclareXEventField(XGraphicsExposeEvent, int, "x", x);
    EmDeclareXEventField(XGraphicsExposeEvent, int, "y", y);
    EmDeclareXEventField(XGraphicsExposeEvent, int, "width", width);
    EmDeclareXEventField(XGraphicsExposeEvent, int, "height", height);
    EmDeclareXEventField(XGraphicsExposeEvent, int, "count", count);
    EmDeclareXEventField(XGraphicsExposeEvent, int, "major_code", major_code);
    EmDeclareXEventField(XGraphicsExposeEvent, int, "minor_code", minor_code);

#undef EmXGraphicsExposeEventSlotsNumber


    /* XNoExposeEvent */

#define EmXNoExposeEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXNoExposeEventClass = KlStructClassMake("XNoExpose", sizeof(XNoExposeEvent), EmXNoExposeEventSlotsNumber));
    EmXEventClassArray[NoExpose] = EmXNoExposeEventClass;
    EmDeclareXEventField(XNoExposeEvent, int, "type", type);
    EmDeclareXEventField(XNoExposeEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XNoExposeEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XNoExposeEvent, Display *, "display", display);
    EmDeclareXEventField(XNoExposeEvent, Drawable, "drawable", drawable);
    EmDeclareXEventField(XNoExposeEvent, int, "major_code", major_code);
    EmDeclareXEventField(XNoExposeEvent, int, "minor_code", minor_code);

#undef EmXNoExposeEventSlotsNumber


    /* XVisibilityEvent */

#define EmXVisibilityEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXVisibilityEventClass = KlStructClassMake("XVisibility", sizeof(XVisibilityEvent), EmXVisibilityEventSlotsNumber));
    EmXEventClassArray[VisibilityNotify] = EmXVisibilityEventClass;
    EmDeclareXEventField(XVisibilityEvent, int, "type", type);
    EmDeclareXEventField(XVisibilityEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XVisibilityEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XVisibilityEvent, Display *, "display", display);
    EmDeclareXEventField(XVisibilityEvent, Window, "window", window);
    EmDeclareXEventField(XVisibilityEvent, int, "state", state);

#undef EmXVisibilityEventSlotsNumber


    /* XCreateWindowEvent */

#define EmXCreateWindowEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXCreateWindowEventClass = KlStructClassMake("XCreateWindow", sizeof(XCreateWindowEvent), EmXCreateWindowEventSlotsNumber));
    EmXEventClassArray[CreateNotify] = EmXCreateWindowEventClass;
    EmDeclareXEventField(XCreateWindowEvent, int, "type", type);
    EmDeclareXEventField(XCreateWindowEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XCreateWindowEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XCreateWindowEvent, Display *, "display", display);
    EmDeclareXEventField(XCreateWindowEvent, Window, "parent", parent);
    EmDeclareXEventField(XCreateWindowEvent, Window, "window", window);
    EmDeclareXEventField(XCreateWindowEvent, int, "x", x);
    EmDeclareXEventField(XCreateWindowEvent, int, "y", y);
    EmDeclareXEventField(XCreateWindowEvent, int, "width", width);
    EmDeclareXEventField(XCreateWindowEvent, int, "height", height);
    EmDeclareXEventField(XCreateWindowEvent, int, "border_width", border_width);

    EmDeclareXEventField(XCreateWindowEvent, Bool, "override_redirect", override_redirect);
#undef EmXCreateWindowEventSlotsNumber


    /* XDestroyWindowEvent */

#define EmXDestroyWindowEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXDestroyWindowEventClass = KlStructClassMake("XDestroyWindow", sizeof(XDestroyWindowEvent), EmXDestroyWindowEventSlotsNumber));
    EmXEventClassArray[DestroyNotify] = EmXDestroyWindowEventClass;
    EmDeclareXEventField(XDestroyWindowEvent, int, "type", type);
    EmDeclareXEventField(XDestroyWindowEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XDestroyWindowEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XDestroyWindowEvent, Display *, "display", display);
    EmDeclareXEventField(XDestroyWindowEvent, Window, "event", event);
    EmDeclareXEventField(XDestroyWindowEvent, Window, "window", window);
#undef EmXDestroyWindowEventSlotsNumber


    /* XUnmapEvent */

#define EmXUnmapEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXUnmapEventClass = KlStructClassMake("XUnmap", sizeof(XUnmapEvent), EmXUnmapEventSlotsNumber));
    EmXEventClassArray[UnmapNotify] = EmXUnmapEventClass;
    EmDeclareXEventField(XUnmapEvent, int, "type", type);
    EmDeclareXEventField(XUnmapEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XUnmapEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XUnmapEvent, Display *, "display", display);
    EmDeclareXEventField(XUnmapEvent, Window, "event", event);
    EmDeclareXEventField(XUnmapEvent, Window, "window", window);
    EmDeclareXEventField(XUnmapEvent, Bool, "from_configure", from_configure);
#undef EmXUnmapEventSlotsNumber


    /* XMapEvent */

#define EmXMapEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXMapEventClass = KlStructClassMake("XMap", sizeof(XMapEvent), EmXMapEventSlotsNumber));
    EmXEventClassArray[MapNotify] = EmXMapEventClass;
    EmDeclareXEventField(XMapEvent, int, "type", type);
    EmDeclareXEventField(XMapEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XMapEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XMapEvent, Display *, "display", display);
    EmDeclareXEventField(XMapEvent, Window, "event", event);
    EmDeclareXEventField(XMapEvent, Window, "window", window);
    EmDeclareXEventField(XMapEvent, Bool, "override_redirect", override_redirect);
#undef EmXMapEventSlotsNumber


    /* XMapRequestEvent */

#define EmXMapRequestEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXMapRequestEventClass = KlStructClassMake("XMapRequest", sizeof(XMapRequestEvent), EmXMapRequestEventSlotsNumber));
    EmXEventClassArray[MapRequest] = EmXMapRequestEventClass;
    EmDeclareXEventField(XMapRequestEvent, int, "type", type);
    EmDeclareXEventField(XMapRequestEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XMapRequestEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XMapRequestEvent, Display *, "display", display);
    EmDeclareXEventField(XMapRequestEvent, Window, "parent", parent);
    EmDeclareXEventField(XMapRequestEvent, Window, "window", window);
#undef EmXMapRequestEventSlotsNumber


    /* XReparentEvent */

#define EmXReparentEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXReparentEventClass = KlStructClassMake("XReparent", sizeof(XReparentEvent), EmXReparentEventSlotsNumber));
    EmXEventClassArray[ReparentNotify] = EmXReparentEventClass;
    EmDeclareXEventField(XReparentEvent, int, "type", type);
    EmDeclareXEventField(XReparentEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XReparentEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XReparentEvent, Display *, "display", display);
    EmDeclareXEventField(XReparentEvent, Window, "event", event);
    EmDeclareXEventField(XReparentEvent, Window, "window", window);
    EmDeclareXEventField(XReparentEvent, Window, "parent", parent);
    EmDeclareXEventField(XReparentEvent, int, "x", x);
    EmDeclareXEventField(XReparentEvent, int, "y", y);

    EmDeclareXEventField(XReparentEvent, Bool, "override_redirect", override_redirect);
#undef EmXReparentEventSlotsNumber


    /* XConfigureEvent */

#define EmXConfigureEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXConfigureEventClass = KlStructClassMake("XConfigure", sizeof(XConfigureEvent), EmXConfigureEventSlotsNumber));
    EmXEventClassArray[ConfigureNotify] = EmXConfigureEventClass;
    EmDeclareXEventField(XConfigureEvent, int, "type", type);
    EmDeclareXEventField(XConfigureEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XConfigureEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XConfigureEvent, Display *, "display", display);
    EmDeclareXEventField(XConfigureEvent, Window, "event", event);
    EmDeclareXEventField(XConfigureEvent, Window, "window", window);
    EmDeclareXEventField(XConfigureEvent, int, "x", x);
    EmDeclareXEventField(XConfigureEvent, int, "y", y);
    EmDeclareXEventField(XConfigureEvent, int, "width", width);
    EmDeclareXEventField(XConfigureEvent, int, "height", height);
    EmDeclareXEventField(XConfigureEvent, int, "border_width", border_width);

    EmDeclareXEventField(XConfigureEvent, Window, "above", above);
    EmDeclareXEventField(XConfigureEvent, Bool, "override_redirect", override_redirect);
#undef EmXConfigureEventSlotsNumber


    /* XGravityEvent */

#define EmXGravityEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXGravityEventClass = KlStructClassMake("XGravity", sizeof(XGravityEvent), EmXGravityEventSlotsNumber));
    EmXEventClassArray[GravityNotify] = EmXGravityEventClass;
    EmDeclareXEventField(XGravityEvent, int, "type", type);
    EmDeclareXEventField(XGravityEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XGravityEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XGravityEvent, Display *, "display", display);
    EmDeclareXEventField(XGravityEvent, Window, "event", event);
    EmDeclareXEventField(XGravityEvent, Window, "window", window);
    EmDeclareXEventField(XGravityEvent, int, "x", x);
    EmDeclareXEventField(XGravityEvent, int, "y", y);

#undef EmXGravityEventSlotsNumber


    /* XResizeRequestEvent */

#define EmXResizeRequestEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXResizeRequestEventClass = KlStructClassMake("XResizeRequest", sizeof(XResizeRequestEvent), EmXResizeRequestEventSlotsNumber));
    EmXEventClassArray[ResizeRequest] = EmXResizeRequestEventClass;
    EmDeclareXEventField(XResizeRequestEvent, int, "type", type);
    EmDeclareXEventField(XResizeRequestEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XResizeRequestEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XResizeRequestEvent, Display *, "display", display);
    EmDeclareXEventField(XResizeRequestEvent, Window, "window", window);
    EmDeclareXEventField(XResizeRequestEvent, int, "width", width);
    EmDeclareXEventField(XResizeRequestEvent, int, "height", height);

#undef EmXResizeRequestEventSlotsNumber


    /* XConfigureRequestEvent */

#define EmXConfigureRequestEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXConfigureRequestEventClass = KlStructClassMake("XConfigureRequest", sizeof(XConfigureRequestEvent), EmXConfigureRequestEventSlotsNumber));
    EmXEventClassArray[ConfigureRequest] = EmXConfigureRequestEventClass;
    EmDeclareXEventField(XConfigureRequestEvent, int, "type", type);
    EmDeclareXEventField(XConfigureRequestEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XConfigureRequestEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XConfigureRequestEvent, Display *, "display", display);
    EmDeclareXEventField(XConfigureRequestEvent, Window, "parent", parent);
    EmDeclareXEventField(XConfigureRequestEvent, Window, "window", window);
    EmDeclareXEventField(XConfigureRequestEvent, int, "x", x);
    EmDeclareXEventField(XConfigureRequestEvent, int, "y", y);
    EmDeclareXEventField(XConfigureRequestEvent, int, "width", width);
    EmDeclareXEventField(XConfigureRequestEvent, int, "height", height);
    EmDeclareXEventField(XConfigureRequestEvent, int, "border_width", border_width);

    EmDeclareXEventField(XConfigureRequestEvent, Window, "above", above);
    EmDeclareXEventField(XConfigureRequestEvent, int, "detail", detail);
    EmDeclareXEventField(XConfigureRequestEvent, unsigned long, "value_mask", value_mask);

#undef EmXConfigureRequestEventSlotsNumber


    /* XCirculateEvent */

#define EmXCirculateEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXCirculateEventClass = KlStructClassMake("XCirculate", sizeof(XCirculateEvent), EmXCirculateEventSlotsNumber));
    EmXEventClassArray[CirculateNotify] = EmXCirculateEventClass;
    EmDeclareXEventField(XCirculateEvent, int, "type", type);
    EmDeclareXEventField(XCirculateEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XCirculateEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XCirculateEvent, Display *, "display", display);
    EmDeclareXEventField(XCirculateEvent, Window, "event", event);
    EmDeclareXEventField(XCirculateEvent, Window, "window", window);
    EmDeclareXEventField(XCirculateEvent, int, "place", place);

#undef EmXCirculateEventSlotsNumber


    /* XCirculateRequestEvent */

#define EmXCirculateRequestEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXCirculateRequestEventClass = KlStructClassMake("XCirculateRequest", sizeof(XCirculateRequestEvent), EmXCirculateRequestEventSlotsNumber));
    EmXEventClassArray[CirculateRequest] = EmXCirculateRequestEventClass;
    EmDeclareXEventField(XCirculateRequestEvent, int, "type", type);
    EmDeclareXEventField(XCirculateRequestEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XCirculateRequestEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XCirculateRequestEvent, Display *, "display", display);
    EmDeclareXEventField(XCirculateRequestEvent, Window, "parent", parent);
    EmDeclareXEventField(XCirculateRequestEvent, Window, "window", window);
    EmDeclareXEventField(XCirculateRequestEvent, int, "place", place);

#undef EmXCirculateRequestEventSlotsNumber


    /* XPropertyEvent */

#define EmXPropertyEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXPropertyEventClass = KlStructClassMake("XProperty", sizeof(XPropertyEvent), EmXPropertyEventSlotsNumber));
    EmXEventClassArray[PropertyNotify] = EmXPropertyEventClass;
    EmDeclareXEventField(XPropertyEvent, int, "type", type);
    EmDeclareXEventField(XPropertyEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XPropertyEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XPropertyEvent, Display *, "display", display);
    EmDeclareXEventField(XPropertyEvent, Window, "window", window);
    EmDeclareXEventField(XPropertyEvent, Atom, "atom", atom);
    EmDeclareXEventField(XPropertyEvent, Time, "time", time);
    EmDeclareXEventField(XPropertyEvent, int, "state", state);

#undef EmXPropertyEventSlotsNumber


    /* XSelectionClearEvent */

#define EmXSelectionClearEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXSelectionClearEventClass = KlStructClassMake("XSelectionClear", sizeof(XSelectionClearEvent), EmXSelectionClearEventSlotsNumber));
    EmXEventClassArray[SelectionClear] = EmXSelectionClearEventClass;
    EmDeclareXEventField(XSelectionClearEvent, int, "type", type);
    EmDeclareXEventField(XSelectionClearEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XSelectionClearEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XSelectionClearEvent, Display *, "display", display);
    EmDeclareXEventField(XSelectionClearEvent, Window, "window", window);
    EmDeclareXEventField(XSelectionClearEvent, Atom, "selection", selection);
    EmDeclareXEventField(XSelectionClearEvent, Time, "time", time);
#undef EmXSelectionClearEventSlotsNumber


    /* XSelectionRequestEvent */

#define EmXSelectionRequestEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXSelectionRequestEventClass = KlStructClassMake("XSelectionRequest", sizeof(XSelectionRequestEvent), EmXSelectionRequestEventSlotsNumber));
    EmXEventClassArray[SelectionRequest] = EmXSelectionRequestEventClass;
    EmDeclareXEventField(XSelectionRequestEvent, int, "type", type);
    EmDeclareXEventField(XSelectionRequestEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XSelectionRequestEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XSelectionRequestEvent, Display *, "display", display);
    EmDeclareXEventField(XSelectionRequestEvent, Window, "owner", owner);
    EmDeclareXEventField(XSelectionRequestEvent, Window, "requestor", requestor);
    EmDeclareXEventField(XSelectionRequestEvent, Atom, "selection", selection);
    EmDeclareXEventField(XSelectionRequestEvent, Atom, "target", target);
    EmDeclareXEventField(XSelectionRequestEvent, Atom, "property", property);
    EmDeclareXEventField(XSelectionRequestEvent, Time, "time", time);
#undef EmXSelectionRequestEventSlotsNumber


    /* XSelectionEvent */

#define EmXSelectionEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXSelectionEventClass = KlStructClassMake("XSelection", sizeof(XSelectionEvent), EmXSelectionEventSlotsNumber));
    EmXEventClassArray[SelectionNotify] = EmXSelectionEventClass;
    EmDeclareXEventField(XSelectionEvent, int, "type", type);
    EmDeclareXEventField(XSelectionEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XSelectionEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XSelectionEvent, Display *, "display", display);
    EmDeclareXEventField(XSelectionEvent, Window, "requestor", requestor);
    EmDeclareXEventField(XSelectionEvent, Atom, "selection", selection);
    EmDeclareXEventField(XSelectionEvent, Atom, "target", target);
    EmDeclareXEventField(XSelectionEvent, Atom, "property", property);
    EmDeclareXEventField(XSelectionEvent, Time, "time", time);
#undef EmXSelectionEventSlotsNumber


    /* XColormapEvent */

#define EmXColormapEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXColormapEventClass = KlStructClassMake("XColormap", sizeof(XColormapEvent), EmXColormapEventSlotsNumber));
    EmXEventClassArray[ColormapNotify] = EmXColormapEventClass;
    EmDeclareXEventField(XColormapEvent, int, "type", type);
    EmDeclareXEventField(XColormapEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XColormapEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XColormapEvent, Display *, "display", display);
    EmDeclareXEventField(XColormapEvent, Window, "window", window);
    EmDeclareXEventField(XColormapEvent, Colormap, "colormap", colormap);
    EmDeclareXEventField(XColormapEvent, Bool, "new", new);
    EmDeclareXEventField(XColormapEvent, int, "state", state);

#undef EmXColormapEventSlotsNumber


    /* XMappingEvent */

#define EmXMappingEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXMappingEventClass = KlStructClassMake("XMapping", sizeof(XMappingEvent), EmXMappingEventSlotsNumber));
    EmXEventClassArray[MappingNotify] = EmXMappingEventClass;
    EmDeclareXEventField(XMappingEvent, int, "type", type);
    EmDeclareXEventField(XMappingEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XMappingEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XMappingEvent, Display *, "display", display);
    EmDeclareXEventField(XMappingEvent, Window, "window", window);
    EmDeclareXEventField(XMappingEvent, int, "request", request);
    EmDeclareXEventField(XMappingEvent, int, "first_keycode", first_keycode);
    EmDeclareXEventField(XMappingEvent, int, "count", count);

#undef EmXMappingEventSlotsNumber


    /* XErrorEvent */

#define EmXErrorEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXErrorEventClass = KlStructClassMake("XError", sizeof(XErrorEvent), EmXErrorEventSlotsNumber));
    EmXEventClassArray[1] = EmXErrorEventClass;
    EmDeclareXEventField(XErrorEvent, int, "type", type);

    EmDeclareXEventField(XErrorEvent, Display *, "display", display);
    EmDeclareXEventField(XErrorEvent, XID, "resourceid", resourceid);
    EmDeclareXEventField(XErrorEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XErrorEvent, Byte, "error_code", error_code);
    EmDeclareXEventField(XErrorEvent, Byte, "request_code", request_code);
    EmDeclareXEventField(XErrorEvent, Byte, "minor_code", minor_code);
#undef EmXErrorEventSlotsNumber


    /* XAnyEvent */

#define EmXAnyEventSlotsNumber MAX_SLOT_XEVENT
    KlIncRef(EmXAnyEventClass = KlStructClassMake("XAny", sizeof(XAnyEvent), EmXAnyEventSlotsNumber));
    EmXEventClassArray[0] = EmXAnyEventClass;
    EmDeclareXEventField(XAnyEvent, int, "type", type);
    EmDeclareXEventField(XAnyEvent, unsigned long, "serial", serial);

    EmDeclareXEventField(XAnyEvent, Bool, "send_event", send_event);
    EmDeclareXEventField(XAnyEvent, Display *, "display", display);
    EmDeclareXEventField(XAnyEvent, Window, "window", window);
#undef EmXAnyEventSlotsNumber

#undef EmDeclareXEventField
}


/* Setq symbols for all useful X Masks.
 */
static void
EmDefXEventMask(void)
{
    KlConstantMake("x:KeyPressMask", KlNumberMake(1L << 0));
    KlConstantMake("x:KeyReleaseMask", KlNumberMake(1L << 1));
    KlConstantMake("x:ButtonPressMask", KlNumberMake(1L << 2));
    KlConstantMake("x:ButtonReleaseMask", KlNumberMake(1L << 3));
    KlConstantMake("x:EnterWindowMask", KlNumberMake(1L << 4));
    KlConstantMake("x:LeaveWindowMask", KlNumberMake(1L << 5));
    KlConstantMake("x:PointerMotionMask", KlNumberMake(1L << 6));
    KlConstantMake("x:PointerMotionHintMask", KlNumberMake(1L << 7));
    KlConstantMake("x:Button1MotionMask", KlNumberMake(1L << 8));
    KlConstantMake("x:Button2MotionMask", KlNumberMake(1L << 9));
    KlConstantMake("x:Button3MotionMask", KlNumberMake(1L << 10));
    KlConstantMake("x:Button4MotionMask", KlNumberMake(1L << 11));
    KlConstantMake("x:Button5MotionMask", KlNumberMake(1L << 12));
    KlConstantMake("x:ButtonMotionMask", KlNumberMake(1L << 13));
    KlConstantMake("x:KeymapStateMask", KlNumberMake(1L << 14));
    KlConstantMake("x:ExposureMask", KlNumberMake(1L << 15));
    KlConstantMake("x:VisibilityChangeMask", KlNumberMake(1L << 16));
    KlConstantMake("x:StructureNotifyMask", KlNumberMake(1L << 17));
    KlConstantMake("x:ResizeRedirectMask", KlNumberMake(1L << 18));
    KlConstantMake("x:SubstructureNotifyMask", KlNumberMake(1L << 19));
    KlConstantMake("x:SubstructureRedirectMask", KlNumberMake(1L << 20));
    KlConstantMake("x:FocusChangeMask", KlNumberMake(1L << 21));
    KlConstantMake("x:PropertyChangeMask", KlNumberMake(1L << 22));
    KlConstantMake("x:ColormapChangeMask", KlNumberMake(1L << 23));
    KlConstantMake("x:OwnerGrabButtonMask", KlNumberMake(1L << 24));
    KlConstantMake("x:ShiftMask", KlNumberMake(1 << 0));
    KlConstantMake("x:LockMask", KlNumberMake(1 << 1));
    KlConstantMake("x:ControlMask", KlNumberMake(1 << 2));
    KlConstantMake("x:Mod1Mask", KlNumberMake(1 << 3));
    KlConstantMake("x:Mod2Mask", KlNumberMake(1 << 4));
    KlConstantMake("x:Mod3Mask", KlNumberMake(1 << 5));
    KlConstantMake("x:Mod4Mask", KlNumberMake(1 << 6));
    KlConstantMake("x:Mod5Mask", KlNumberMake(1 << 7));
    KlConstantMake("x:Button1Mask", KlNumberMake(1 << 8));
    KlConstantMake("x:Button2Mask", KlNumberMake(1 << 9));
    KlConstantMake("x:Button3Mask", KlNumberMake(1 << 10));
    KlConstantMake("x:Button4Mask", KlNumberMake(1 << 11));
    KlConstantMake("x:Button5Mask", KlNumberMake(1 << 12));
    KlConstantMake("x:CWEventMask", KlNumberMake(1L << 11));
    KlConstantMake("x:GCPlaneMask", KlNumberMake(1L << 1));
    KlConstantMake("x:GCClipMask", KlNumberMake(1L << 19));
}

/* Setq symbols for all useful XEvents Types.
 */
static void
EmDefXEventType(void)
{
    KlConstantMake("x:KeyPress", KlNumberMake(2));
    KlConstantMake("x:KeyRelease", KlNumberMake(3));
    KlConstantMake("x:ButtonPress", KlNumberMake(4));
    KlConstantMake("x:ButtonRelease", KlNumberMake(5));
    KlConstantMake("x:MotionNotify", KlNumberMake(6));
    KlConstantMake("x:EnterNotify", KlNumberMake(7));
    KlConstantMake("x:LeaveNotify", KlNumberMake(8));
    KlConstantMake("x:FocusIn", KlNumberMake(9));
    KlConstantMake("x:FocusOut", KlNumberMake(10));
    KlConstantMake("x:KeymapNotify", KlNumberMake(11));
    KlConstantMake("x:Expose", KlNumberMake(12));
    KlConstantMake("x:GraphicsExpose", KlNumberMake(13));
    KlConstantMake("x:NoExpose", KlNumberMake(14));
    KlConstantMake("x:VisibilityNotify", KlNumberMake(15));
    KlConstantMake("x:CreateNotify", KlNumberMake(16));
    KlConstantMake("x:DestroyNotify", KlNumberMake(17));
    KlConstantMake("x:UnmapNotify", KlNumberMake(18));
    KlConstantMake("x:MapNotify", KlNumberMake(19));
    KlConstantMake("x:MapRequest", KlNumberMake(20));
    KlConstantMake("x:ReparentNotify", KlNumberMake(21));
    KlConstantMake("x:ConfigureNotify", KlNumberMake(22));
    KlConstantMake("x:ConfigureRequest", KlNumberMake(23));
    KlConstantMake("x:GravityNotify", KlNumberMake(24));
    KlConstantMake("x:ResizeRequest", KlNumberMake(25));
    KlConstantMake("x:CirculateNotify", KlNumberMake(26));
    KlConstantMake("x:CirculateRequest", KlNumberMake(27));
    KlConstantMake("x:PropertyNotify", KlNumberMake(28));
    KlConstantMake("x:SelectionClear", KlNumberMake(29));
    KlConstantMake("x:SelectionRequest", KlNumberMake(30));
    KlConstantMake("x:SelectionNotify", KlNumberMake(31));
    KlConstantMake("x:ColormapNotify", KlNumberMake(32));
    KlConstantMake("x:ClientMessage", KlNumberMake(33));
    KlConstantMake("x:MappingNotify", KlNumberMake(34));
    KlConstantMake("x:Processed", KlNumberMake(40));
}

/* Wrapper:
 * like XSelectInput
 * (done on EmDisplay sorry ;)
 */
static KlO
EmXSelectInputKl(KlO window, KlO mask)
{
    KlMustBeIntOrConstInt(window, 0);
    KlMustBeIntOrConstInt(mask, 1);

    XSelectInput(EmDisplay, KlNumToInt(window), KlNumToInt(mask));
    return NIL;
}

/* Wrapper:
 * like XSync(EmDisplay, False);
 */
static KlO
EmXSyncKl(void)
{
    if (EmDisplay)
	XSync(EmDisplay, False);
    return NIL;
}

/* Wrapper:
 * like XSynchronize
 * (done on EmDisplay sorry ;)
 */
static KlO
EmXSynchronizeKl(KlO onOff		/* set or unset synchronization (t or
		     ()) */ )
{
    Bool oo;

    oo = KlTrueP(onOff);
    if (EmDisplay)
	XSynchronize(EmDisplay, oo);
    return NIL;
}




/* Wrapper:
 * like XPending(EmDisplay)
 */
static KlO
EmXPendingKl(void)
{
    if (EmDisplay && XPending(EmDisplay))
	return TRU;
    else
	return NIL;
}


/* Wrapper:
 * like XNextEvent
 */
static KlO
EmXNextEventKl(void)
{
    KlO ro;
    XEvent *pXEvent;

    if (EmDisplay) {
	pXEvent = UNew(XEvent);
	XNextEvent(EmDisplay, pXEvent);
	ro = (KlO) KlStructMake(EmXEventClassArray[pXEvent->type], pXEvent);
	return ro;
    }
    else
	return NIL;
}



/* Wrapper:
 * like XCheckWindowEvent
 */
static KlO
EmXCheckWindowEventKl(KlO window /* window to check */ ,
		      KlO mask /* event mask to apply */ )
{
    KlO ro;
    XEvent *pXEvent;
    XEvent event;
    Bools eventFound;

    KlMustBeIntOrConstInt(window, 0);
    KlMustBeIntOrConstInt(mask, 1);

    eventFound = XCheckWindowEvent(EmDisplay, KlNumToInt(window), KlNumToInt(mask), &event);
    if (eventFound) {
	pXEvent = UNew(XEvent);
	memcpy(pXEvent, &event, sizeof(XEvent));
	ro = (KlO) KlStructMake(EmXEventClassArray[pXEvent->type], pXEvent);
	return ro;
    }
    else
	return NIL;
}


/* Wrapper:
 * like XLookupString
 */
static KlO
EmXLookupStringKl(KlO ev)
{
    char tmp[MAX_KEYSYM_LENGTH];
    KlO ro;
    int l;

    /* ?? TODO: check for event struct */
    l = XLookupString((XKeyEvent *) (((KlStruct) ev)->ptr), tmp, MAX_KEYSYM_LENGTH, NULL, NULL);
    tmp[l] = '\0';
    ro = (KlO) KlStringMake(tmp);
    return ro;
}


/* Wrapper: for XDrawLine(d, gc, x1, y1, x2, y2)
 */
static KlO
EmXDrawLineKl(int argc, KlO * argv)
{
    int i;
    Drawable d;
    GC gc;
    int x1, y1, x2, y2;


    if (argc != 6)
	return KlBadNumberOfArguments((char *) argc);
    for (i = 0; i < argc; i++)
	KlMustBeIntOrConstInt(argv[i], i);

    d = KlNumToInt(argv[0]);
    gc = KlNumToPtr(argv[1]);
    x1 = KlNumToInt(argv[2]);
    y1 = KlNumToInt(argv[3]);
    x2 = KlNumToInt(argv[4]);
    y2 = KlNumToInt(argv[5]);
    XDrawLine(EmDisplay, d, gc, x1, y1, x2, y2);
    return NIL;
}


/* Wrapper: for XBell(display, percent)
 */
static KlO
EmXBellKl(KlO dpy, KlO num)
{
    KlMustBeIntOrConstInt(dpy, 0);
    KlMustBeIntOrConstInt(num, 1);

    XBell(KlNumToPtr(dpy), KlNumToInt(num));
    return NIL;
}

/* Dispatch all pending X events using Xt mechanism
 *
 * call XtDispatchEvent while attrib *dont-gobble-event*
 * is set on group corresponding to widget concerned by event.
 */
static KlO
EmXTDispatchEventsKl(void)
{
    XEvent xev;
    EmGroup *pg;
    int nbDispatch;

    if (EmDisplay) {
	while (XPending(EmDisplay)) {
	    XNextEvent(EmDisplay, &xev);
	    nbDispatch = 0;
	    pg = EmWinToGroup(xev.xany.window);
	    do {
		EmASetLocalC(pg, NULL, "*dont-gobble-event*", NIL);
		XtDispatchEvent(&xev);
		nbDispatch++;
	    } while ((nbDispatch < MAX_DISPATCH_TRY) &&
	    (KlTrueP((KlO) EmAGetLocalC(pg, NULL, "*dont-gobble-event*"))));
	    if (nbDispatch >= MAX_DISPATCH_TRY)
		UIError("EmXTDispatchEventsKl", "there must be a cycle in last installed translation table. this X Event has been dispatched %d time without been gobbled!", MAX_DISPATCH_TRY);
	}
    }
    return NIL;
}


/* preparse an Xt translation table (aka xttt) given in its human readable form
 */
static KlO
EmXTParseTranslationTableKl(KlO xttt)
{
    KlO ro;

    ro = (KlO) KlNumberMake((long) XtParseTranslationTable(KlStringToCharPtr(xttt)));
    return ro;
}


/* install a preparsed Xt translation table in a widget
 */
static KlO
EmXTInstallTranslationTableKl(KlO widget /* install xttt on this widget */ ,
			      KlO xttt	/* the preparsed xt translation table
			          to install */ )
{
    KlMustBeNumber(widget, 0);
    KlMustBeNumber(xttt, 1);


    XtOverrideTranslations(KlNumToWidget(widget), (XtTranslations) KlNumToPtr(xttt));
    return NIL;
}

/* install a preparsed Xt translation table in a widget
 */
static KlO
EmXTUninstallTranslationTableKl(KlO widget	/* install xttt on this
				    widget */ )
{
    KlMustBeNumber(widget, 0);

    XtUninstallTranslations(KlNumToWidget(widget));
    return NIL;
}


/* Initialize the X module.
 *
 * Create all the X classes. Define all the X subroutines.
 */
void
EmXInit(void)
{
    EmXEventsClassMake();
    EmDefXEventMask();
    EmDefXEventType();
    KlDeclareSubr(EmXSelectInputKl, "x:select-input", 2);
    KlDeclareSubr(EmXPendingKl, "x:pending", 0);
    KlDeclareSubr(EmXSyncKl, "x:sync", 0);
    KlDeclareSubr(EmXSynchronizeKl, "x:synchronize", 1);
    KlDeclareSubr(EmXNextEventKl, "x:next-event", 0);
    KlDeclareSubr(EmXCheckWindowEventKl, "x:check-window-event", 2);
    KlDeclareSubr(EmXDrawLineKl, "x:draw-line", NARY);
    KlDeclareSubr(EmXBellKl, "x:xbell", 2);
    KlDeclareSubr(EmXLookupStringKl, "x:lookup-string", 1);
    KlDeclareSubr(EmXTDispatchEventsKl, "xt:dispatch-events", 0);
    KlDeclareSubr(EmXTParseTranslationTableKl, "xt:parse-translation-table", 1);
    KlDeclareSubr(EmXTInstallTranslationTableKl, "xt:install-translation-table", 2);
    KlDeclareSubr(EmXTUninstallTranslationTableKl, "xt:uninstall-translation-table", 1);
}
