#ifndef EMSELECT_H
#define EMSELECT_H

#include "emall.h"


/**************************************************************** Prototypes */


/* Initialize the selection mecanism.
 */
void EmInitSelection(Display * dpy);

/* Make Selected formula available from other applications
 * via the cut and paste in X environment.
 */
void EmOwnSelection(Widget w, Time timestamp, char *msg);

/* Wrapper: for EmOwnSelection(Widget w, Time timestamp, char *msg)
 */
KlO EmOwnSelectionKl(KlO g, KlO timestamp, KlO msg);

/* Out */
Boolean selectionRequestCB(Widget w, Atom * selection, Atom * target, Atom * type, XtPointer * value, unsigned long *length, int *format);

/*
 * User asked to get PRIMARY selection.
 * First find out what formats are available.
 */
void EmGetPrimary(Widget w, Time timestamp);

/* Wrapper: for EmOwnSelection(Widget w, Time timestamp, char *msg)
 */
KlO EmGetPrimaryKl(KlO g, KlO timestamp);

/*
 * Pick the best format from the list available and ask
 * for a conversion to that target.
 */
void targetCB(Widget w, XtPointer client_data, Atom * selection, Atom * type, XtPointer value, unsigned long *length, int *format);

/*
 * We got the data, let's tack it on to our string.
 */
void valueCB(Widget w, XtPointer client_data, Atom * selection, Atom * type, XtPointer value, unsigned long *length, int *format);

/*
 * Put up a dialog with the given message.
 */
void my_error_dialog(char *str);

/* Init converters
 */
void EmSelectionInit(void);

/************************************************************ End Prototypes */

#endif
