#include "emall.h"
#include <X11/Shell.h>

static EmGroup *EmDisplayGroup = NULL;	/* ?? TODO use a link for
					 * multidisplay version */


/* a rough guess of the number of windows used by en application (optimize hashtable access but not critical */
#define EM_NB_WIN_GUESS 50


/* assoc table for association between thread and windows */
static AssocTable *EmAtWinThread;

/* assoc table for association between thread and widgets */
static AssocTable *EmAtWidThread;


static EmLinkTable *EmWidgetNameLink;
static EmLinkTable *EmDisplayNameLink;

/* List of groups for runing windows */
List *EmListOfWindows;

/* only one AppContext per emath-server so keep it in this global variable
 * to avoid useless call overhead due to klone->C->klone conversion
 */
XtAppContext EmAppContext;

/* the real application root-group... one per server */
EmGroup *EmAppRootGroup = NULL;


/**************************************************************** Prototypes */


/******************************************************************** Bodies */


/* Record the application managed by this server.
 *
 * appName and appClass are used for later X resources parsing.
 * Create a root-group associated with this application.
 * This group is the global var EmAppRootGroup.
 * No initialisation for X resources done at creation
 * but attribs like app-class and app-name are stored
 *
 * Return: id of the app root group.
 */
EmId
EmRecordApp(char *appName /* name of application to record */ ,
	    char *appClass /* class of application to record */ )
{
    /* build corresponding root-group */
    EmAppRootGroup = EmCreateGroup(appName, EmRootGroup);	/* no father */
    EmASetC(EmAppRootGroup, EmGateNode, "*app-name*", KlStringMakeIncRef(appName));
    EmASetC(EmAppRootGroup, EmGateNode, "*app-class*", KlStringMakeIncRef(appClass));
    /* fill some default attributes for displaying functions */
    EmGBoxFDA(EmAppRootGroup, EmGateNode);
    return EmAppRootGroup;
}

/* Wrapper for : EmRecordApp(char *appName, char *appClass)
 */
KlO
EmRecordAppKl(KlO appName, KlO appClass)
{
    KlO ro;

    KlMustBeStringOrConstString(appClass, 0);
    KlMustBeStringOrConstString(appName, 1);
    ro = (KlO) KlNumberMake(EmRecordApp(KlStringToCharPtr(appName),
					KlStringToCharPtr(appClass)));
    KlExecuteStringNoReturn("(init-appli)");
    return ro;
}

/* Open the X connection (and initialize Xt) with given display.
 *
 * Create a group associated with this display.
 * Its name is derived from the display name.
 * Fill this group with std attrib and with attribs founds in the X
 * resource data base.
 * (attribs like: app{name|class}.*.main.background: white).
 * Create a default unmanaged widget used as convenience parameter
 * in Xt function calls.
 * This widget is also set as attrib "dpy-widget"
 *
 * Return: id of the created group
 */
EmId
EmRecordDisplay(char *dpyAddress	/* is used for Xt initialization
					 * (appname and class are known since
		    EmRecordApp) */ ,
		char *name		/* can be used to retrieve this
		    display using EmNameToDisplay */ )
{
    int dummy = 0;
    Display *display;
    Widget topLevel, selectionWidget;
    EmGroup *pg;
    char *appClass, *appName;
    Arg args[10];
    int n;

    appName = KlStringToCharPtr(EmAGetC(EmAppRootGroup, EmGateNode, "*app-name*"));
    appClass = KlStringToCharPtr(EmAGetC(EmAppRootGroup, EmGateNode, "*app-class*"));
    XtToolkitInitialize();
    topLevel = XtAppInitialize(&EmAppContext, (char *) appClass,
			       (XrmOptionDescRec *) NULL, (Cardinal) 0,
			       &dummy, (String *) NULL,
		      (String *) EmFallbacks, (ArgList) NULL, (Cardinal) 0);
    EmDisplay = XtDisplay(topLevel);

    EmLinkMake(EmDisplayNameLink, EmDisplay, UStrDup(name));

    /* build corresponding display group */
    /* each display group is linked to the application root-group */
    pg = EmCreateGroup(name, EmAppRootGroup);
    EmDisplayGroup = pg;

    /* create a widget to store selection */
    selectionWidget = XtVaCreateManagedWidget("selection-widget", topLevelShellWidgetClass, topLevel, NULL);
    n = 0;
    XtSetArg(args[n], XtNheight, 10);
    n++;
    XtSetArg(args[n], XtNwidth, 10);
    n++;
    XtSetValues(selectionWidget, args, n);
    XtRealizeWidget(selectionWidget);
    EmASetC(pg, EmGateNode, "*selection-widget*", (KlO) KlNumberMake(selectionWidget));

    /* store this attrib */
    EmASetC(pg, EmGateNode, "*dpy-widget*", (KlO) KlNumberMake(topLevel));

    /* keep display as attrib for easier access from clients */
    EmASetC(pg, EmGateNode, "*display*", (KlO) KlNumberMake(EmDisplay));

    /* convert X resources to emath attributes */
    EmXResToGroupAttrib(pg);

    /* initialize attributes for X selection */
    EmInitSelection(EmDisplay);

    return pg;
}

/* Wrapper for : EmRecordDisplay(char *dpyAddress, char *name)
 */
KlO
EmRecordDisplayKl(KlO dpyAddress, KlO name)
{
    KlO ro;

    KlMustBeStringOrConstString(dpyAddress, 0);
    KlMustBeStringOrConstString(name, 1);
    ro = (KlO) KlNumberMake(EmRecordDisplay(KlStringToCharPtr(dpyAddress),
					    KlStringToCharPtr(name)));
    return ro;
}

/* Record this window (client application is responsible for its creation)
 *
 * - Create a group associated with this window.
 * Its name is derived from the window name
 * - Fill this group with attribs founds in the X resource data base.
 * (attribs like: app.*.big.background: black)
 * - Encapsulate this window in a widget used as convenience parameter
 * in Xt function calls
 * - Add this window-group to the list of runing windows
 * This widget is also set as attrib "*widget*"
 *
 * Return: id of the created group
 *
 * Example: EmRecordWindow(dpyWidget,win,"big").
 * Results in a group named big.
 */
EmId
EmRecordWindow(EmGroup * fatherGroup	/* Will become its father in group
	           tree */ ,
	       Window win /* window id to record */ ,
	       char *name		/* can be used to retrieve this
	           window using EmNameToWindow */ ,
	       KlO emtt /* the translation table to use */ ,
	       KlO initialState /* initial state in the translation */ )
{
    Widget wid, dpyWid;
    EmGroup *pg;
    Display *dpy;
    Td *ptd;
    int dummy;
    unsigned int udummy;
    Window wdummy;
    EmNode *rootNode;

    dpyWid = KlNumToPtr(EmAGetC(fatherGroup, EmGateNode, "*dpy-widget*"));
    wid = XtVaCreateManagedWidget(name, windowWidgetClass, dpyWid,
				  XtNwindow, win, NULL);

    XtRealizeWidget(wid);
    EmLinkMake(EmWidgetNameLink, wid, UStrDup(name));

    /* build corresponding group */
    pg = EmCreateGroup(name, fatherGroup);
    /* and add it to the list of runing windows */
    lAdd(EmListOfWindows, pg);

    /* convert X resources to emath attributes */
    EmXResToGroupAttrib(pg);

    dpy = XtDisplay(wid);
    ptd = EmTpCreateNewThread(EmDrawWindow);
    ptd->dpy = dpy;
    ptd->win = win;
    ptd->wid = wid;
    ptd->pg = pg;
    ptd->wx = ptd->wy = 0;		/* start at ul corner */
    XGetGeometry(dpy, (Drawable) win, &wdummy, &dummy, &dummy, &(ptd->ww), &(ptd->wh), &udummy, &udummy);

    atInsert(EmAtWinThread, &(ptd->win), ptd, True);
    atInsert(EmAtWidThread, wid, ptd, True);
    rootNode = EmCreateNode(NTColumn);
    ptd->pn = rootNode;

    EmASetC(pg, EmGateNode, "*root-node*", KlPtrMakeIncRef(rootNode));
    EmASetC(pg, EmGateNode, "*current-node*", KlPtrMakeIncRef(rootNode));
    EmASetC(pg, EmGateNode, "*em-translation-table*", emtt);
    EmASetC(pg, EmGateNode, "*window*", (KlO) KlNumberMake(win));
    EmASetC(pg, EmGateNode, "*widget*", (KlO) KlNumberMake(wid));

    KlApply3(KlIntern("set-state"), KlNumberMake(EmWidToGroup(wid)), NIL, initialState);

    return pg;
}


/* Wrapper
 */
KlO
EmRecordWindowKl(KlO fg, KlO win, KlO name, KlO emtt, KlO initialState)
{
    KlO ro;

    KlMustBeIntOrConstInt(fg, 0);
    KlMustBeIntOrConstInt(win, 1);
    KlMustBeStringOrConstString(name, 2);
    ro = (KlO) KlNumberMake(EmRecordWindow(KlNumToGrp(fg),
					   (Window) KlNumToInt(win),
					   KlStringToCharPtr(name),
					   emtt, initialState));
    return ro;
}


/* Add a formula to a window
 * This will trigger its draw in the specified window (window must have been previously managed)
 */
void
EmAddFormulaToWindow(EmNode * pn /* formula to manage */ ,
		     Window win /* the window */ )
{
    EmGroup *pg;
    EmNode *rootNode, *container;

    pg = EmWinToGroup(win);
    rootNode = EmIdToNodePtr(EmAGetC(pg, EmGateNode, "*root-node*"));
    container = EmCreateNode(NTContainer);
    EmAddSonNode(rootNode, container);
    EmAddSonNode(container, pn);
}

/* Wrapper:
 */
KlO
EmAddFormulaToWindowKl(KlO pn, KlO win)
{

    KlMustBeIntOrConstInt(pn, 0);
    KlMustBeIntOrConstInt(win, 1);
    EmAddFormulaToWindow(EmIdToNodePtr(pn),
			 (Window) KlNumToInt(win));
    return pn;
}


/* Return the group of this wigdet
 * or nil if widget unknown
 */
EmGroup *
EmWidToGroup(Widget wid /* searched widget */ )
{
    Td *ptd;

    ptd = EmWidToThread(wid);
    if (ptd)
	return ptd->pg;
    else
	return NULL;
}

/* Wrapper:
 */
KlO
EmWidToGroupKl(KlO wid /* searched widget */ )
{
    KlMustBeIntOrConstInt(wid, 0);
    return (KlO) KlNumberMake(EmWidToGroup(KlNumToWidget(wid)));
}

/* Return the group linked to a display
 */
EmGroup *
EmDisplayToGroup(Display * dpy)
{
    return EmDisplayGroup;		/* ?? TODO a real link here to enable
					 * multi display */
}

/* Return the display given its name
 */
Display *
EmNameToDisplay(char *name /* searched name */ )
{
    return (Display *) EmLinkGetLeft(EmDisplayNameLink, name);
}

/* Return the name of a display
 */
char *
EmDisplayToName(Display * dpy /* searched display */ )
{
    return (char *) EmLinkGetRight(EmDisplayNameLink, dpy);
}

/* Return a widget given its name
 */
EmId
EmNameToWidget(char *name /* searched name */ )
{
    return (EmId) EmLinkGetLeft(EmWidgetNameLink, name);
}

/* Wrapper:
 */
KlO
EmNameToWidgetKl(KlO name /* searched name */ )
{
    return (KlO) KlNumberMake(EmNameToWidget(KlStringToCharPtr(name)));
}

/* Return thread structure associated to window.
 */
Td *
EmWinToThread(Window win /* searched window */ )
{
    return (Td *) atSearch(EmAtWinThread, &win);
}

/* Return the group of this window
 * or nil if window unknown
 */
EmGroup *
EmWinToGroup(Window win /* searched window */ )
{
    Td *ptd;

    ptd = EmWinToThread(win);
    if (ptd)
	return ptd->pg;
    else
	return NULL;
}


/* Wrapper:
 */
KlO
EmWinToGroupKl(KlO win /* searched widget */ )
{
    KlMustBeIntOrConstInt(win, 0);
    return (KlO) KlNumberMake(EmWinToGroup((Window) KlNumToInt(win)));
}

/* Return thread structure associated to widget
 */
Td *
EmWidToThread(Widget wid /* searched widget */ )
{
    return (Td *) atSearch(EmAtWidThread, wid);
}


/* unmanage a window... mark thread as dying... next schedule will sweep it
 * TODO modify... is that useful? probably... so must check
 */
void
EmTpUnmanageWindow(Window win)
{
    Td *ptd;

    ptd = EmWinToThread(win);
    ptd->status = EM_TP_DYING;
}

/* Wrapper: for void EmTpUnmanageWindow(Window win);
 * unmanage a window... mark thread as dying... next schedule will sweep it
 */
KlO
EmTpUnmanageWindowKl(KlO winId)
{
    KlMustBeIntOrConstInt(winId, 0);
    EmTpUnmanageWindow(KlNumToLong(winId));
    return NIL;
}

/* init record module
 */
void
EmRecordInit(void)
{

    /* create the linksused to retrive window or dispalys from their names */
    EmWidgetNameLink =
    EmLinkTableCreate(EM_NB_WINDOW_GUESS,
		      (EmLinkCmpFunc) ordVoid,
		      (EmLinkCmpFunc) ordString,
		      (EmLinkHashFunc) hashVoid,
		      (EmLinkHashFunc) hashString,
		      (EmLinkFreeFunc) nullFunc,
		      (EmLinkFreeFunc) UFree,
		      (EmLinkPrintFunc) printVoid,
		      (EmLinkPrintFunc) printString);

    EmDisplayNameLink =
	EmLinkTableCreate(EM_NB_DISPLAY_GUESS,
			  (EmLinkCmpFunc) ordVoid,
			  (EmLinkCmpFunc) ordString,
			  (EmLinkHashFunc) hashVoid,
			  (EmLinkHashFunc) hashString,
			  (EmLinkFreeFunc) nullFunc,
			  (EmLinkFreeFunc) UFree,
			  (EmLinkPrintFunc) printVoid,
			  (EmLinkPrintFunc) printString);

    /* create the association assoctable thread<->window & thread<->widget */
    EmAtWinThread = atCreate(EM_NB_WIN_GUESS, hashInt, ordInt, nullFunc, nullFunc, printInt, EmTpTdPrint);
    EmAtWidThread = atCreate(EM_NB_WIN_GUESS, hashVoid, ordVoid, nullFunc, nullFunc, printVoid, EmTpTdPrint);

    /* create the list of window-groups fir all runing windows */
    EmListOfWindows = lCreate(keyVoid, ordVoid, nullFunc, EmPrintGroup);

    /* declare some functions callable from Klone */
    KlDeclareSubr(EmRecordAppKl, "record-app", 2);
    KlDeclareSubr(EmRecordDisplayKl, "record-display", 2);
    KlDeclareSubr(EmRecordWindowKl, "record-window", 5);
    KlDeclareSubr(EmAddFormulaToWindowKl, "add-formula-to-window", 2);
    KlDeclareSubr(EmWidToGroupKl, "group-of-wid", 1);
    KlDeclareSubr(EmWinToGroupKl, "group-of-win", 1);
    KlDeclareSubr(EmNameToWidgetKl, "widget-of-name", 1);
}
