/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: Window.c,v 0.3 1995/06/14 12:33:10 oarsac Exp $ */


#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "WindowP.h"

static void Realize();
static void Initialize();

extern EmCallKloneFromXttm();
static XtActionsRec actionsList[] =
{
    {"callKloneFromXttm", (XtActionProc) EmCallKloneFromXttm}
};

static char defaultTranslations[] = "";



static Boolean
       SetValues(Widget cw, Widget rw, Widget nw, ArgList args, Cardinal * num_args);

static XtResource resources[] =
{
#define offset(field) XtOffsetOf(WindowRec, window.field)
    {
	XtNwindow, XtCWindow,
	XtRWindow, sizeof(Window),
	offset(window), XtRWindow, None
    },
#undef offset
};


WindowClassRec windowClassRec =
{
    {					/* core fields */
	 /* superclass		 */ (WidgetClass) & widgetClassRec,
	 /* class_name		 */ "Window",
	 /* widget_size		 */ sizeof(WindowRec),
	 /* class_initialize		 */ NULL,
	 /* class_part_initialize	 */ NULL,
	 /* class_inited		 */ FALSE,
	 /* initialize		 */ Initialize,
	 /* initialize_hook		 */ NULL,
	 /* realize			 */ Realize,
	 /* actions			 */ actionsList,
	/* num_actions		 */
	XtNumber(actionsList),
	 /* resources		 */ resources,
	 /* num_resources		 */ XtNumber(resources),
	 /* xrm_class		 */ NULLQUARK,
	 /* compress_motion		 */ TRUE,
	 /* compress_exposure	 */ TRUE,
	 /* compress_enterleave	 */ TRUE,
	 /* visible_interest		 */ FALSE,
	 /* destroy			 */ NULL,
	 /* resize			 */ NULL,
	 /* expose			 */ NULL,
	 /* set_values		 */ SetValues,
	 /* set_values_hook		 */ NULL,
	 /* set_values_almost	 */ XtInheritSetValuesAlmost,
	 /* get_values_hook		 */ NULL,
	 /* accept_focus		 */ NULL,
	 /* version			 */ XtVersion,
	 /* callback_private		 */ NULL,
	 /* tm_table			 */ defaultTranslations,
	 /* query_geometry		 */ XtInheritQueryGeometry,
	 /* display_accelerator	 */ XtInheritDisplayAccelerator,
	 /* extension		 */ NULL
    },
    {					/* window fields */
	 /* empty			 */ 0
    }
};

WidgetClass windowWidgetClass = (WidgetClass) & windowClassRec;

/* initialize what else?
 * but unset the window of this widget
 */
static void
Initialize(Widget w)
{
    w->core.window = None;
}

/* realize the widget
 */
static void
Realize(Widget w, XtValueMask * value_mask,
	XSetWindowAttributes * attributes)
{
    WindowWidget win = (WindowWidget) w;
    XWindowAttributes values;

    win->core.window = win->window.window;
    if (None != win->core.window) {
	XGetWindowAttributes(XtDisplay(w), win->core.window, &values);
	win->core.width = values.width;
	win->core.width = values.height;
    }


};

/* set values
 */
static Boolean
SetValues(Widget cw,
	  Widget rw,
	  Widget nw,
	  ArgList args,
	  Cardinal * num_args)
{
    WindowWidget nww = (WindowWidget) nw;
    WindowWidget cww = (WindowWidget) cw;

    if (nww->window.window != cww->window.window) {
	nww->core.window = nww->window.window;
    }
    return False;
}
