#include "emall.h"

static AssocTable *EmConvertersATable;

/**************************************************************** Prototypes */

/* static function not documented...
 */
static void 
EmCvtStringToKlO(void);

/* static function not documented...
 */
static void 
EmNameAConverter(AssocTable * pat, char *name, char *type);

/* Must be called before EmInstallNewConverters and EmXResToGroupAttrib
 */
static void 
EmNameStdConverters(void);

/* ??TODO
 */
static void 
EmInstallNewConverters(void);

/******************************************************************** Bodies */


/* static function not documented...
 */
static void
EmCvtStringToKlO(void)
{
}

/* static function not documented...
 */
static void
EmNameAConverter(AssocTable * pat, char *name, char *type)
{
    atInsert(pat, name, type, True);
}

/* Must be called before EmInstallNewConverters and EmXResToGroupAttrib
 */
static void
EmNameStdConverters(void)
{
    EmConvertersATable = atCreate(EM_NB_CONVERTERS_GUESS, hashString, ordString, nullFunc, UFree, printString, printInt);

    EmNameAConverter(EmConvertersATable, "AcceleratorTable", XtRAcceleratorTable);
    EmNameAConverter(EmConvertersATable, "Atom", XtRAtom);
    EmNameAConverter(EmConvertersATable, "Bitmap", XtRBitmap);
    EmNameAConverter(EmConvertersATable, "Bool", XtRBool);
    EmNameAConverter(EmConvertersATable, "Boolean", XtRBoolean);
    EmNameAConverter(EmConvertersATable, "Callback", XtRCallback);
    EmNameAConverter(EmConvertersATable, "CallProc", XtRCallProc);
    EmNameAConverter(EmConvertersATable, "Cardinal", XtRCardinal);
    EmNameAConverter(EmConvertersATable, "Color", XtRColor);
    EmNameAConverter(EmConvertersATable, "Colormap", XtRColormap);
    EmNameAConverter(EmConvertersATable, "Cursor", XtRCursor);
    EmNameAConverter(EmConvertersATable, "Dimension", XtRDimension);
    EmNameAConverter(EmConvertersATable, "Display", XtRDisplay);
    EmNameAConverter(EmConvertersATable, "EditMode", XtREditMode);
    EmNameAConverter(EmConvertersATable, "Enum", XtREnum);
    EmNameAConverter(EmConvertersATable, "File", XtRFile);
    EmNameAConverter(EmConvertersATable, "Float", XtRFloat);
    EmNameAConverter(EmConvertersATable, "Font", XtRFont);
    EmNameAConverter(EmConvertersATable, "FontStruct", XtRFontStruct);
    EmNameAConverter(EmConvertersATable, "Function", XtRFunction);
    EmNameAConverter(EmConvertersATable, "Geometry", XtRGeometry);
    EmNameAConverter(EmConvertersATable, "Immediate", XtRImmediate);
    EmNameAConverter(EmConvertersATable, "InitialState", XtRInitialState);
    EmNameAConverter(EmConvertersATable, "Int", XtRInt);
    EmNameAConverter(EmConvertersATable, "Justify", XtRJustify);
    EmNameAConverter(EmConvertersATable, "Object", XtRObject);
    EmNameAConverter(EmConvertersATable, "Orientation", XtROrientation);
    EmNameAConverter(EmConvertersATable, "Pixel", XtRPixel);
    EmNameAConverter(EmConvertersATable, "Pixmap", XtRPixmap);
    EmNameAConverter(EmConvertersATable, "Pointer", XtRPointer);
    EmNameAConverter(EmConvertersATable, "Position", XtRPosition);
    EmNameAConverter(EmConvertersATable, "Screen", XtRScreen);
    EmNameAConverter(EmConvertersATable, "Short", XtRShort);
    EmNameAConverter(EmConvertersATable, "String", XtRString);
    EmNameAConverter(EmConvertersATable, "StringArray", XtRStringArray);
    EmNameAConverter(EmConvertersATable, "StringTable", XtRStringTable);
    EmNameAConverter(EmConvertersATable, "UnsignedChar", XtRUnsignedChar);
    EmNameAConverter(EmConvertersATable, "TranslationTable", XtRTranslationTable);
    EmNameAConverter(EmConvertersATable, "Visual", XtRVisual);
    EmNameAConverter(EmConvertersATable, "Widget", XtRWidget);
    EmNameAConverter(EmConvertersATable, "WidgetClass", XtRWidgetClass);
    EmNameAConverter(EmConvertersATable, "WidgetList", XtRWidgetList);
    EmNameAConverter(EmConvertersATable, "Window", XtRWindow);
    EmNameAConverter(EmConvertersATable, "FontSet", XtRFontSet);
}

/* ??TODO
 */
static void
EmInstallNewConverters(void)
{
/* ?? TODO   XtSetTypeConverter(XtRString, XtRKlone, EmCvtStringToKlO, NULL, 0, XtCacheNone, NULL);
    EmNameAConverter(EmConvertersATable, "KlO", XtRKlone);*/

}

/* For all attributes names found in attrib list-of-attributes-name
 * Parse the xrdb to find their value.
 * Convert it depending on converter name find in this list.
 * Create an attribute with this name and value.
 *
 * Example:list-of-attributes-name -> ((background Pixel)
 *                                     (body-font FontStruct)
 *                                     (drag-cb KlO)).
 * applied for group 'zoom' (direct descendant of display group 'main')
 * in application 'test' (class Test)
 * parse resources like test.main.zoom.background
 *                      Test.main.zoom.background
 *                      test.main.zoom.body-font and so on
 * if a value has been found for background
 *   convert it to a pixel (using string-to-pixel)
 *   set attribute background on gate-node of group zoom with this pixel
 */
void
EmXResToGroupAttrib(EmGroup * pg)
{
    XrmDatabase resDB;
    XrmValue value, convValue;
    String toType;
    Widget wid;
    KlList lAttributes, att;
    char *appName, *appClass, *groupPath;
    char *strType;
    char *attName, appRes[MAX_CHAR_TMP], classRes[MAX_CHAR_TMP];
    int i;
    char *pv;

    wid = KlNumToWidget(EmAGetC(pg, EmGateNode, "*dpy-widget*"));
    resDB = XrmGetDatabase(XtDisplay(wid));

    groupPath = EmGroupPath(pg);
    appName = KlStringToCharPtr(EmAGetC(EmAppRootGroup, EmGateNode, "*app-name*"));
    appClass = KlStringToCharPtr(EmAGetC(EmAppRootGroup, EmGateNode, "*app-class*"));
    /* first find the ressource defining all the attributes */
    sprintf(appRes, "%s.%s.%s", appName, groupPath, "list-of-attributes");
    sprintf(classRes, "%s.%s.%s", appClass, groupPath, "list-of-attributes");
    XrmGetResource(resDB, appRes, classRes, &strType, &value);
    if (value.size) {			/* this ressource is defined */
	XtConvert(wid, XtRString, &value, XtRString, &convValue);
#ifdef TRACE_XRES
	printf("got ressource :%s -> %s\n", appRes, value.addr);
#endif
	pv = UMalloc(convValue.size + 2);
	memcpy(pv + 1, convValue.addr, convValue.size);
	pv[0] = '\'';
	lAttributes = (KlList) KlExecuteString(pv);
	UFree(pv);
	for (i = 0; i < lAttributes->size; i++) {
	    att = (KlList) lAttributes->list[i];
	    attName = KlStringToCharPtr(att->list[0]);
	    sprintf(appRes, "%s.%s.%s", appName, groupPath, attName);
	    sprintf(classRes, "%s.%s.%s", appClass, groupPath, attName);
	    XrmGetResource(resDB, appRes, classRes, &strType, &value);
	    if (value.size) {		/* this ressource is defined */
		/* into which type must it be converted */
		toType = atSearch(EmConvertersATable, KlStringToCharPtr(att->list[1]));
		/* do the convertion */
		XtConvert(wid, XtRString, &value, toType, &convValue);
		/* set this attributes (override default value if any) */
		/* store this result for later use */
                /* if size is less or equal to size of void* make it a number */
                /* else duplicate it and store the pointer to copy */
                if (convValue.addr <= sizeof(void*)){
                    EmASetC(pg, EmGateNode, attName, (KlO) KlNumberMake(*((int*)convValue.addr)));
                }
                else{
                    pv = UMalloc(convValue.size);
                    memcpy(pv, convValue.addr, convValue.size);
                    EmASetC(pg, EmGateNode, attName, (KlO) KlNumberMake(pv));
                }
#ifdef TRACE_XRES
		printf("got ressource :%s -> %s converted to:\n", appRes, value.addr);
                UKlPrint(EmAGetC(pg,EmGateNode, attName));
#endif

	    }
	}
    }
    else {
	UIWarning("EmXResToGroupAttrib", "resource \'list-of-attributes\' is unknown... this is probably due to an incomplete installation of Emath or else to a poorly defined set of X environement variables (like XAPPLRESDIR or XFILESEARCHPATH)");
    }
    UFree(groupPath);
}

/* Wrapper:
 * No effect becoz Xrd is not reparsed by Xt... ?? TODO
 */
KlO
EmXResToGroupAttribKl(KlO idgrp)
{
    KlO ro;

    KlMustBeIntOrConstInt(idgrp, 0);
    EmXResToGroupAttrib(KlNumToGrp(idgrp));
    return NIL;
}

/* Init converters
 */
void
EmResInit(void)
{
    EmNameStdConverters();
    EmInstallNewConverters();
    KlDeclareSubr(EmXResToGroupAttribKl, "reparse-xres-group", 1);
}
