#ifndef EMGBOX_H
#define EMGBOX_H


/* max number of GBox cells that are kept in the garbage list */
/* more than that => they are freed */
#define EM_MAX_GBOX_GARBAGE 4096


/* divider of font height used to compute hline box height */
#define EM_GB_HLINE_VRATIO 6

/* some parametres for drawing symbols... */
#define EM_GB_ROOT_VCLEAR_RATIO 10
#define EM_GB_ROOT_HCLEAR_RATIO EM_GB_ROOT_VCLEAR_RATIO
#define EM_GB_ROOT_WSL_RATIO 2
#define EM_GB_ROOT_WBL_RATIO 2

#define EM_GB_MATRIX_VCLEAR_RATIO 2
#define EM_GB_MATRIX_HCLEAR_RATIO EM_GB_MATRIX_VCLEAR_RATIO

#define EM_GB_COLLEFT_VSTEP 30
#define EM_GB_COLLEFT_HSTEP 30


#define GBAscent(pgb) (pgb->h - pgb->descent)

typedef enum GBoxType {
    GBBad = 0,
    GBRow, GBRowCut, GBColLeft, GBColCenter,
    GBIndex, GBUp, GBDown,
    GBVector, GBMatrix,
    GBDiv, GBRoot,
    GBChar, GBSymb, GBRootSymb, GBHLine, GBMultSymb,
    GBUMinus,
    GBTemplate, GBContainer
}        GBoxType;

/* this box must be rebuild (correxponding EmNode or relevants attributes changed) */
#define EM_GB_REBUILD_MASK 1<<0

/* this box has a descendant that must be rebuild */
#define EM_GB_SONREBUILD_MASK 1<<1

/* this box must be refilled? (ie some of the nodes of the bounded tree have been modified (or created) */
#define EM_GB_REFILL_MASK 1<<2

/* this box must be redrawnfilled? (ie some of the nodes of the bounded tree have been modified (or created) */
#define EM_GB_REDRAW_MASK 1<<3

/* this box has been discarded (probably to reduce mem usage of GBox Tree) */
#define EM_GB_DISCARDED_MASK 1<<4

/* this box has been cached */
#define EM_GB_CACHED_MASK 1<<5

/* rebuild */
#define EmGBRebuildP(pgb) (((pgb)->stateMask) & EM_GB_REBUILD_MASK)
#define EmGBRebuildT(pgb) ((pgb)->stateMask |= EM_GB_REBUILD_MASK)
#define EmGBRebuildF(pgb) ((pgb)->stateMask &= ~EM_GB_REBUILD_MASK)

/* sonRebuild */
#define EmGBSonRebuildP(pgb) (((pgb)->stateMask) & EM_GB_SONREBUILD_MASK)
#define EmGBSonRebuildT(pgb) ((pgb)->stateMask |= EM_GB_SONREBUILD_MASK)
#define EmGBSonRebuildF(pgb) ((pgb)->stateMask &= ~EM_GB_SONREBUILD_MASK)

/* refill */
#define EmGBRefillP(pgb) (((pgb)->stateMask) & EM_GB_REFILL_MASK)
#define EmGBRefillT(pgb) ((pgb)->stateMask |= EM_GB_REFILL_MASK)
#define EmGBRefillF(pgb) ((pgb)->stateMask &= ~EM_GB_REFILL_MASK)

/* redraw */
#define EmGBRedrawP(pgb) (((pgb)->stateMask) & EM_GB_REDRAW_MASK)
#define EmGBRedrawT(pgb) ((pgb)->stateMask |= EM_GB_REDRAW_MASK)
#define EmGBRedrawF(pgb) ((pgb)->stateMask &= ~EM_GB_REDRAW_MASK)

/* discard */
#define EmGBDiscardedP(pgb) (((pgb)->stateMask) & EM_GB_DISCARDED_MASK)
#define EmGBDiscardedT(pgb) ((pgb)->stateMask |= EM_GB_DISCARDED_MASK)
#define EmGBDiscardedF(pgb) ((pgb)->stateMask &= ~EM_GB_DISCARDED_MASK)

/* cached */
#define EmGBCachedP(pgb) (((pgb)->stateMask) & EM_GB_CACHED_MASK)
#define EmGBCachedT(pgb) ((pgb)->stateMask |= EM_GB_CACHED_MASK)
#define EmGBCachedF(pgb) ((pgb)->stateMask &= ~EM_GB_CACHED_MASK)






/* does pgb bound the (x,y) point ? */
#define GbBoundP(pgb,cx,cy,xp,yp)\
                      (((cx) <= (xp)) && ((cx) + (pgb)->w) >= (xp) && \
                       ((cy) <= (yp)) && ((cy) + (pgb)->h) >= (yp))

/* is pgb bounded by the rectangle (ulx,uly,w,hk) ? */
#define GbBoundedP(pgb,cx,cy,ulx,uly,w,h)\
                      (((ulx) <= (cx)) && ((ulx) + (w) >= (cx) + (pgb)->w) && \
                       ((uly) <= (cy)) && ((uly) + (h) >= (cy) + (pgb)->h))



typedef enum EmFillConstraint {
    GBCBad = 0, GBCNone, GBCStrict, GBCHeightFixed
}                EmFillConstraint;

typedef struct GBox {
    GBoxType type;			/* type ... or what else ;) */
    Byte stateMask;			/* mask to store state of this box */
    unsigned short w, h;		/* size of this box */
    short descent;			/* base line position of thsi box */
    unsigned int x, y;			/* UL corner coords relative to the *
					 * virtual formula window */
    EmNode *pn;				/* which formula node is this box
					 * derived from */
    void *pFather;			/* father gbox, ie bounding box */
    struct GBox *pBrother;		/* first brother */
    struct GBox *pSon;			/* first son, ie first bounded box */
    void *pVal;				/* for a leaf gbox used to store a
					 * value used at fill or draw time */
}

     GBox;


/* type of function used to build the gbox tree */
typedef GBox *(*EmBuildGBoxFuncType) (EmGroup * pg, EmNode * pn, GBox *pgb);

/* type of function used to fill the geometric fields of the gbox tree */
typedef void (*EmFillGBoxFuncType) (EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* type of function used to draw the gbox tree */
typedef void (*EmDrawGBoxFuncType) (EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel);


/**************************************************************** Prototypes */


/* Allocate a new gbox (not cleared).
 *
 * Allocation may be avoided if garbage list is not empty.
 */
GBox * EmAllocGBox ( void );

/* Free a GBox.
 *
 * Freed GBoxes are linked with their pSon pointers to form a garbage list.
 */
void EmFreeGBox ( GBox * pgb );

/* Node searched */
GBox * EmNodeToGBox ( EmGroup * pg, EmNode * pn );

/* GBox to link */
GBox * EmLinkGBoxToNode ( EmGroup * pg, EmNode * pn, GBox * pgb );

/* GBox to unlink */
void EmUnLinkGBoxToNode ( EmGroup * pg, EmNode * pn, GBox * pgb );

/* height */
GBox * EmRectangleToGBoxes ( EmGroup * pg, GBox * pgb, int vx, int vy, int ulx, int uly, int w, int h );

/* Wrapper:
 */
KlO EmRectangleToGBoxesKl ( int argc, KlO * argv );

/* height */
GBox * EmRectangleToBigestGBox ( EmGroup * pg, GBox * pgb, int vx, int vy, int ulx, int uly, int w, int h );

/* Wrapper:
 */
KlO EmRectangleToBigestGBoxKl ( int argc, KlO * argv );

/* height */
GBox * EmRectangleToHighestGBox ( EmGroup * pg, GBox * pgb, int vx, int vy, int ulx, int uly, int w, int h );

/* Wrapper:
 */
KlO EmRectangleToHighestGBoxKl ( int argc, KlO * argv );

/* point ygiven in virtual window
	          coordinates */
GBox * EmCoordToGBox ( EmGroup * pg, GBox * pgb, int vx, int vy, int x, int y );

/* Wrapper:
 */
KlO EmCoordToGBoxKl ( int argc, KlO * argv );

/* Searched Gbox */
EmNode * EmGBoxToNode ( EmGroup * pg, GBox * pgb );

/* Searched Gbox */
KlO EmGBoxToNodeKl ( KlO pg, KlO pgb );

/* Node to fill */
void EmGBoxFDA ( EmGroup * pg, EmNode * pn );

/* init the GBox module
 */
void EmGBoxInit ( void );

/************************************************************ End Prototypes */



#endif					/* EMGBOX_H */
