#include "emall.h"

static GBox *gboxGarbage = NULL;
static int gboxGarbageCount = 0;
static HashTable *NodGbHashTable;

typedef struct NodGBox {
    EmNode *pn;
    EmGroup *pg;
    GBox *pgb;
}       NodGBox;


/**************************************************************** Prototypes */

static int EmGBOrdNodGb(NodGBox * png1, NodGBox * png2);
static void EmFreeNodGb(NodGBox * png);
static int EmHashNodGb(NodGBox * png, int sz);
static void EmPrintNodGb(NodGBox * png);

/******************************************************************** Bodies */

/* are two NodGBox struct equal ? */
static int
EmGBOrdNodGb(NodGBox * png1, NodGBox * png2)
{
    return (png1->pn - png2->pn) + (png1->pg - png2->pg);
}

/* free a NodGBox struct */
static void
EmFreeNodGb(NodGBox * png)
{
    UFree(png);				/* ??TODO bettre allocations..
					 * garbage list? */
}


/* hash a NodGBox struct */
static int
EmHashNodGb(NodGBox * png, int sz)
{
    return ((int) png->pn + (int) png->pg) % sz;
}

/* print a NodGBox struct */
static void
EmPrintNodGb(NodGBox * png)
{
    EmPrintGroup(png->pg);

}




/* Allocate a new gbox (not cleared).
 *
 * Allocation may be avoided if garbage list is not empty.
 */
GBox *
EmAllocGBox(void)
{
    GBox *pgb;

    if (gboxGarbageCount) {
	pgb = (GBox *) gboxGarbage;
	gboxGarbage = (GBox *) gboxGarbage->pSon;
	gboxGarbageCount--;
    }
    else
	pgb = UNew(GBox);
    bzero(pgb, sizeof(GBox));		/* ?? only during debug ? */
    EmGBRefillT(pgb);			/* well this box will be modified of
					 * course */
    return pgb;
}

/* Free a GBox.
 *
 * Freed GBoxes are linked with their pSon pointers to form a garbage list.
 */
void
EmFreeGBox(GBox * pgb)
{
    if (gboxGarbageCount++ < EM_MAX_GBOX_GARBAGE) {
	bzero(pgb, sizeof(GBox));	/* ?? only during debug ? */
	pgb->pSon = (void *) gboxGarbage;
	gboxGarbage->pSon = pgb;
    }
    else {
	UFree(pgb);
    }
}



/* Find the GBox linked to a Node
   return the main GBox of this Node or NULL if none registred
 */
GBox *
EmNodeToGBox(EmGroup * pg		/* Group of Window to which GBox are
	         linked */ ,
	     EmNode * pn /* Node searched */ )
{
    NodGBox ngb, *pngb;

    assert(pg && pn);
    ngb.pg = pg;
    ngb.pn = pn;
    ngb.pgb = NULL;
    pngb = (NodGBox *) htSearchKey(NodGbHashTable, &ngb);
    if (pngb)
	return pngb->pgb;
    else
	return NULL;
}

/* Link a Gbox to a Node (given the group of it's window)
 * Delete previous link between this node/window/gbox
 * free this GBox (and its sons sharing same node)
 */
GBox *
EmLinkGBoxToNode(EmGroup * pg		/* Group of Window to which GBox will
		     be linked */ ,
		 EmNode * pn /* Node to link */ ,
		 GBox * pgb /* GBox to link */ )
{

    GBox *poldgb;
    NodGBox ngb, *pngb;

    assert(pg && pn && pgb);
    poldgb = EmNodeToGBox(pg, pn);
    if (poldgb) {
	EmUnLinkGBoxToNode(pg, pn, poldgb);
    }

    pngb = UNew(NodGBox);
    pngb->pg = pg;
    pngb->pn = pn;
    pngb->pgb = pgb;
    htInsert(NodGbHashTable, pngb, True);
    return pgb;
}

/* Unlink a Gbox to a Node (given the group of it's window)
 * Delete link between this node/window/gbox
 * free this GBox (and its sons sharing same node)
 */
void
EmUnLinkGBoxToNode(EmGroup * pg		/* Group of Window to which GBox will
		       be unlinked */ ,
		   EmNode * pn /* Node to unlink */ ,
		   GBox * rpgb /* GBox to unlink */ )
{
    GBox *pgb, *psgb, *pnsgb;
    NodGBox ngb, *pngb;

    assert(pg && pn && rpgb);

    /* delete all sons gboxes sharing same EmNode */
    pgb = EmNodeToGBox(pg, pn);
    assert(rpgb == pgb);

    if (pgb) {
	psgb = pgb->pSon;
	while (psgb) {
	    pnsgb = psgb->pBrother;
	    if (psgb->pn == pn) {
		/*
		 * that's a pseudo Gbox for same EmNode as its father eg:
		 * symbol '+'
		 */
		EmFreeGBox(psgb);
	    }
	    psgb = pnsgb;
	}
	EmFreeGBox(pgb);
    }

    /* remove this entry from hashtable */
    ngb.pg = pg;
    ngb.pn = pn;
    ngb.pgb = NULL;
    htDelKey(NodGbHashTable, &ngb, True);
}



/* Find the set of GBox bounded by a rectangle
 */
GBox *
EmRectangleToGBoxes(EmGroup * pg /* Group to use for attributes */ ,
		    GBox * pgb /* Root box of filled tree */ ,
		    int vx		/* ul corner x of pgb (0 if pgb is
		        real root) */ ,
		    int vy		/* ul corner y of pgb (0 if pgb is
		        real root) */ ,
		    int ulx		/* upper left corner x (in virtual
		        window coordinates) */ ,
		    int uly		/* upper left corner y (in virtual
		        window coordinates) */ ,
		    int w /* width */ ,
		    int h /* height */ )
{
    GBox *psgb, *prgb;

    assert(pgb && pg);
    assert(w >= 0 && h >= 0);
    UNIW;				/* ?? TODO */
    return pgb;
}



/* This EmNode has been modified or added.
 * Set states of all boxes linked to this node and all their ancestors
 * to reflect this modification (this mean doing this for all runing windows)
 */
void
EmGbUpdateState(EmNode * pn)
{
    int i, nbw;
    EmGroup *pg;
    GBox *pgb;

    nbw = lNbElts(EmListOfWindows);
    /* for all windows */
    for (i = 0; i < nbw; i++) {
	pg = lLookNth(EmListOfWindows, i);
	pgb = EmNodeToGBox(pg, pn);
	if (pgb) {			/* probably a moved node */
	    EmGBRebuildT(pgb);
	    pgb = pgb->pFather;
	}
	if (pgb) {			/* father must be rebuild too */
	    EmGBRebuildT(pgb);
	}
	while (pgb && !EmGBSonRebuildP(pgb)) {
	    /*
	     * ancestors must know that one of their descents has been
	     * modified
	     */
	    EmGBSonRebuildT(pgb);
	    pgb = pgb->pFather;
	}
    }
}


/* Wrapper:
 */
KlO
EmRectangleToGBoxesKl(int argc, KlO * argv)
{
    GBox *pgbres;
    int i;

    if (argc != 8)
	return KlBadNumberOfArguments((char *) argc);

    for (i = 0; i < argc; i++)
	KlMustBeIntOrConstInt(argv[i], i);

    pgbres = EmRectangleToGBoxes(KlNumToGrp(argv[0]), KlNumToGBox(argv[1]),
				 KlNumToInt(argv[2]), KlNumToInt(argv[3]),
				 KlNumToInt(argv[4]), KlNumToInt(argv[5]),
				 KlNumToInt(argv[6]), KlNumToInt(argv[7]));

    if (pgbres)
	return (KlO) KlNumberMake(pgbres);
    else
	return NIL;
}

/* Find the bigest GBox bounded by a rectangle
 */
GBox *
EmRectangleToBigestGBox(EmGroup * pg /* Group to use for attributes */ ,
			GBox * pgb /* Root box of filled tree */ ,
			int vx		/* ul corner x of pgb (0 if pgb is
			    real root) */ ,
			int vy		/* ul corner y of pgb (0 if pgb is
			    real root) */ ,
			int ulx		/* upper left corner x (in virtual
			    window coordinates) */ ,
			int uly		/* upper left corner y (in virtual
			    window coordinates) */ ,
			int w /* width */ ,
			int h /* height */ )
{
    GBox *psgb, *prgb, *pbgb = NULL;
    int area = 0, tmp;

    assert(pgb && pg);
    assert(w >= 0 && h >= 0);
    if (GbBoundedP(pgb, vx, vy, ulx, uly, w, h)) {
	return pgb;
    }
    else {
	if ((psgb = pgb->pSon)) {
	    while (psgb) {
		if ((prgb = EmRectangleToBigestGBox(pg, psgb,
						    vx + psgb->x,
						    vy + psgb->y,
						    ulx, uly, w, h))) {
		    if ((tmp = (prgb->w * prgb->h)) > area) {
			area = tmp;
			pbgb = prgb;
		    }
		}
		psgb = psgb->pBrother;
	    }
	}
	else if (EmGBDiscardedP(pgb)) {
	    UNIW;
	}
	return pbgb;
    }
}

/* Wrapper:
 */
KlO
EmRectangleToBigestGBoxKl(int argc, KlO * argv)
{
    GBox *pgbres;
    int i;

    if (argc != 8)
	return KlBadNumberOfArguments((char *) argc);

    for (i = 0; i < argc; i++)
	KlMustBeIntOrConstInt(argv[i], i);

    pgbres = EmRectangleToBigestGBox(KlNumToGrp(argv[0]), KlNumToGBox(argv[1]),
				   KlNumToInt(argv[2]), KlNumToInt(argv[3]),
				   KlNumToInt(argv[4]), KlNumToInt(argv[5]),
				  KlNumToInt(argv[6]), KlNumToInt(argv[7]));
    if (pgbres)
	return (KlO) KlNumberMake(pgbres);
    else
	return NIL;
}


/* Find the highest GBox bounded by a rectangle
 * highest means that the EmNode the gbox is orginated from is higher in tree
 * than other bounded GBoxes
 */
GBox *
EmRectangleToHighestGBox(EmGroup * pg /* Group to use for attributes */ ,
			 GBox * pgb /* Root box of filled tree */ ,
			 int vx		/* ul corner x of pgb (0 if pgb is
			     real root) */ ,
			 int vy		/* ul corner y of pgb (0 if pgb is
			     real root) */ ,
			 int ulx	/* upper left corner x (in virtual
			     window coordinates) */ ,
			 int uly	/* upper left corner y (in virtual
			     window coordinates) */ ,
			 int w /* width */ ,
			 int h /* height */ )
{
    GBox *psgb, *prgb, *pbgb = NULL;
    int level = INT_MAX;

    assert(pgb && pg);
    assert(w >= 0 && h >= 0);
    if (GbBoundedP(pgb, vx, vy, ulx, uly, w, h)) {
	return pgb;
    }
    else {
	if ((psgb = pgb->pSon)) {
	    while (psgb) {
		if ((prgb = EmRectangleToHighestGBox(pg, psgb,
						     vx + psgb->x,
						     vy + psgb->y,
						     ulx, uly, w, h))) {
		    if (prgb->pn->level < level) {
			level = prgb->pn->level;
			pbgb = prgb;
		    }
		}
		psgb = psgb->pBrother;
	    }
	}
	else if (EmGBDiscardedP(pgb)) {
	    UNIW;
	}
	return pbgb;
    }
}

/* Wrapper:
 */
KlO
EmRectangleToHighestGBoxKl(int argc, KlO * argv)
{
    GBox *pgbres;
    int i;

    if (argc != 8)
	return KlBadNumberOfArguments((char *) argc);

    for (i = 0; i < argc; i++)
	KlMustBeIntOrConstInt(argv[i], i);

    pgbres = EmRectangleToHighestGBox(KlNumToGrp(argv[0]), KlNumToGBox(argv[1]),
				   KlNumToInt(argv[2]), KlNumToInt(argv[3]),
				   KlNumToInt(argv[4]), KlNumToInt(argv[5]),
				  KlNumToInt(argv[6]), KlNumToInt(argv[7]));
    if (pgbres)
	return (KlO) KlNumberMake(pgbres);
    else
	return NIL;
}



/* Find the GBox bounding a point
 */
GBox *
EmCoordToGBox(EmGroup * pg /* Group to use for attributes */ ,
	      GBox * pgb /* Root box of filled tree */ ,
	      int vx			/* ul corner x of pgb (0 if pgb is
	          real root) */ ,
	      int vy			/* ul corner y of pgb (0 if pgb is
	          real root) */ ,
	      int x			/* point x given in virtual window
	          coordinates */ ,
	      int y			/* point ygiven in virtual window
	          coordinates */ )
{
    GBox *psgb, *prgb;

    assert(pgb && pg);
    if (GbBoundP(pgb, vx, vy, x, y)) {
	if ((psgb = pgb->pSon)) {
	    while (psgb) {
		if ((prgb = EmCoordToGBox(pg, psgb,
					  vx + psgb->x, vy + psgb->y,
					  x, y))) {
		    return prgb;
		}
		psgb = psgb->pBrother;
	    }
	}
	else if (EmGBDiscardedP(pgb)) {
	    UNIW;
	}
	return pgb;
    }
    return (GBox *) NULL;
}

/* Wrapper:
 */
KlO
EmCoordToGBoxKl(int argc, KlO * argv)
{
    GBox *pgbres;
    int i;

    if (argc != 6)
	return KlBadNumberOfArguments((char *) argc);

    for (i = 0; i < argc; i++)
	KlMustBeIntOrConstInt(argv[i], i);

    pgbres = EmCoordToGBox(KlNumToGrp(argv[0]), KlNumToGBox(argv[1]),
			   KlNumToInt(argv[2]), KlNumToInt(argv[3]),
			   KlNumToInt(argv[4]), KlNumToInt(argv[5]));
    if (pgbres)
	return (KlO) KlNumberMake(pgbres);
    else
	return NIL;
}

/* Return the node associated to a GBox
 */
EmNode *
EmGBoxToNode(EmGroup * pg /* Group to use for attributes */ ,
	     GBox * pgb /* Searched Gbox */ )
{
    GBox *psgb, *prgb;

    assert(pgb && pg);
    return pgb->pn;
}


/* Wrapper:
 */
KlO
EmGBoxToNodeKl(KlO pg /* Group to use for attributes */ ,
	       KlO pgb /* Searched Gbox */ )
{
    KlMustBeIntOrConstInt(pg, 0);
    KlMustBeIntOrConstInt(pgb, 1);
    return (KlO) KlNumberMake(EmGBoxToNode(KlNumToGrp(pg), KlNumToGBox(pgb)));
}



/* Must fill all default attributes concerning GBoxes.
 */
void
EmGBoxFDA(EmGroup * pg /* Group to fill */ ,
	  EmNode * pn /* Node to fill */ )
{
    EmGBoxFDABuild(pg, pn);
    EmGBoxFDAFill(pg, pn);
    EmGBoxFDADraw(pg, pn);
}

/* init the GBox module
 */
void
EmGBoxInit(void)
{
    /* Init the garbage queue */
    gboxGarbageCount = 0;
    gboxGarbage = EmAllocGBox();

    NodGbHashTable = htCreate(1000, keySame, EmGBOrdNodGb, EmFreeNodGb, EmHashNodGb, EmPrintNodGb);

    KlDeclareSubr(EmCoordToGBoxKl, "coord-to-gbox", NARY);
    KlDeclareSubr(EmGBoxToNodeKl, "gbox-to-node", 2);
    KlDeclareSubr(EmRectangleToBigestGBoxKl, "rectangle-to-gboxes", NARY);
    KlDeclareSubr(EmRectangleToBigestGBoxKl, "rectangle-to-bigest-gbox", NARY);
    KlDeclareSubr(EmRectangleToHighestGBoxKl, "rectangle-to-highest-gbox", NARY);


}
