#include "emall.h"

static GBox *gboxGarbage = NULL;
static int gboxGarbageCount = 0;



/**************************************************************** Prototypes */

/* static function not documented...
 */
static void 
EmFillGBoxHLine(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxCharAux(EmGroup * pg, GBox * pgb, char *pc, XFontStruct * pFontBody);

/* static function not documented...
 */
static void 
EmFillGBoxChar(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxRowCut(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxColLeft(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxColCenter(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxRoot(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxContainer(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxIndexAux(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel, GBox * pgbInd);

/* static function not documented...
 */
static void 
EmFillGBoxIndex(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxSymb(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxDiv(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxVector(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxMatrix(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmFillGBoxTemplate(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel);

/******************************************************************** Bodies */

/* Search the *-font-* attributes for the correct font definition
 * if the searched size is not found search for *-font-smallest
 * *-font-0 and *-font-smallest must always exist
 */
XFontStruct *
EmFindFont(EmGroup * pg /* group used for attributes search */ ,
	   EmNode * pn			/* node used as seed for attribute
	       search */ ,
	   char *fontName /* name of the searched font ie */ ,
	   Byte sizeLevel		/* size level requested (0:normal
	       1:smaler and so on) */ )
{
    XFontStruct **ppfs;
    char tmp[MAX_ATTRIB_NAME_LEN];

    sprintf(tmp, "%s-font-%d", fontName, sizeLevel);
    ppfs = KlNumToPtr(EmAGetC(pg, pn, tmp));
    if (!ppfs)
	/* ?? TODO check for return of agetc */
	ppfs = KlNumToPtr(EmAGetC(pg, pn, "body-font-smallest"));
    return *ppfs;
}

/* static function not documented...
 */
static void
EmFillGBoxHLine(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    XFontStruct *pfs;

    pfs = EmFindFont(pg, pgb->pn, "body", sizeLevel);
    pgb->h = UMax(3, (pfs->ascent + pfs->descent) / EM_GB_HLINE_VRATIO);
    pgb->descent = pgb->h / 2 + 1;
};

/* static function not documented...
 */
static void
EmFillGBoxCharAux(EmGroup * pg, GBox * pgb, char *pc, XFontStruct * pFontBody)
{
    int directionReturn;
    int fontAscentReturn, fontDescentReturn;
    XCharStruct overallReturn;

    XTextExtents(pFontBody, pc, 1, &directionReturn, &fontAscentReturn, &fontDescentReturn, &overallReturn);
    pgb->w = overallReturn.width;
    pgb->h = overallReturn.ascent + overallReturn.descent;
    pgb->descent = overallReturn.descent;
};

/* static function not documented...
 */
static void
EmFillGBoxChar(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    return EmFillGBoxCharAux(pg, pgb,
			     pgb->pVal,
			     EmFindFont(pg, pgb->pn, "body", sizeLevel));
}

/* static function not documented...
 */
static void
EmFillGBoxRowCut(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    GBox *pgbs, *pFirstGbOfLine, *pgbaux;
    int maxLineAscent, maxLineDescent, nextSonX, boxHeight, boxWidth, boxAscent = 0;
    Bools sameLine;

    switch (constraint) {
    case GBCNone:{
	    /* compute h w descent for each son box */
	    /* use it to find ascent, descent, h and  w for this box */
	    /* able to find x for son boxes too */
	    pgbs = pgb->pSon;
	    maxLineDescent = maxLineAscent = 0;
	    nextSonX = 0;
	    while (pgbs) {
		EmFillGBox(pg, pgbs, GBCNone, wx, wy, ww, wh, nextSonX, cury, sizeLevel);
		maxLineDescent = UMax(maxLineDescent, pgbs->descent);
		maxLineAscent = UMax(maxLineAscent, pgbs->h - pgbs->descent);
		pgbs->x = nextSonX;
		nextSonX += pgbs->w;
		pgbs = pgbs->pBrother;
	    }
	    pgb->h = maxLineDescent + maxLineAscent;
	    pgb->w = nextSonX;
	    pgb->descent = maxLineDescent;

	    /* now compute y for son boxes */
	    pgbs = pgb->pSon;
	    while (pgbs) {
		pgbs->y = maxLineAscent + pgbs->descent - pgbs->h;
		pgbs = pgbs->pBrother;
	    }
	    return;
	    break;
	}
    case GBCStrict:{
	    boxHeight = boxWidth = 0;
	    pgbs = pgb->pSon;
	    while (pgbs) {
		sameLine = True;
		maxLineDescent = maxLineAscent = 0;
		nextSonX = 0;
		pFirstGbOfLine = pgbs;
		EmFillGBox(pg, pgbs, GBCNone, wx, wy, ww, wh, curx + nextSonX, cury + boxHeight, sizeLevel);
		if (pgbs->w + curx > wx + ww) {
		    /* this box wont fit even if it's alone on a line */
		    /* ask it to shrink strictly */
		    EmFillGBox(pg, pgbs, GBCStrict, wx, wy, ww, wh, curx, cury + boxHeight, sizeLevel);
		    pgbs->x = 0;
		    pgbs->y = boxHeight;
		    boxHeight += pgbs->h;
		    boxWidth = UMax(boxWidth, pgbs->w);
		    if (boxAscent == 0)	/* box ascent is first line ascent */
			boxAscent = boxHeight;
		    pgbs = pgbs->pBrother;
		}
		else {
		    /* this is a normal line start */
		    while (pgbs && sameLine) {
			pgbs->x = nextSonX;
			nextSonX += pgbs->w;
			if (nextSonX + curx < wx + ww) {
			    /*
			     * ok this box is small enough to fit on this
			     * line end 
			     */
			    maxLineDescent = UMax(maxLineDescent, pgbs->descent);
			    maxLineAscent = UMax(maxLineAscent, pgbs->h - pgbs->descent);
			    pgbs->x = nextSonX;
			    nextSonX += pgbs->w;
			    pgbs = pgbs->pBrother;
			}
			else {
			    /* this son box doesn't fit on this line */
			    sameLine = False;
			    /* compute y for this line boxes */
			    pgbaux = pFirstGbOfLine;
			    while (pgbaux) {
				pgbaux->y = maxLineAscent + pgbaux->descent - pgbaux->h;
			    }
			    boxHeight += maxLineAscent + maxLineDescent;
			    boxWidth = UMax(boxWidth, nextSonX);
			    if (boxAscent == 0)	/* box ascent is first line
						 * ascent */
				boxAscent = boxHeight;
			    /* and start a new line */
			}
		    }
		}
	    }
	    pgb->h = boxHeight;
	    pgb->w = boxWidth;
	    pgb->descent = boxHeight - boxAscent;
	    return;
	    break;
	}
    default:{
	    UIError("EmFillGBoxRowCutSymb", "unknown constraint %d", constraint);
	}
    }
}

/* static function not documented...
 */
static void
EmFillGBoxColLeft(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    GBox *pgbs;
    int nextSonY, boxWidth;

    switch (constraint) {
    case GBCNone:
    case GBCStrict:{
	    /* compute h w descent for each son box */
	    /* use it to find ascent, descent, h and w for this box */
	    /* able to find x for son boxes too */
	    pgbs = pgb->pSon;
	    boxWidth = 0;
	    nextSonY = EM_GB_COLLEFT_VSTEP;
	    while (pgbs) {
		EmFillGBox(pg, pgbs, constraint, wx, wy, ww, wh, curx, nextSonY, sizeLevel);
		pgbs->x = EM_GB_COLLEFT_HSTEP;
		pgbs->y = nextSonY;
		nextSonY += pgbs->h + EM_GB_COLLEFT_VSTEP;
		boxWidth = UMax(boxWidth, pgbs->w);
		pgbs = pgbs->pBrother;
	    }
	    pgb->h = nextSonY;
	    pgb->w = EM_GB_COLLEFT_HSTEP + boxWidth;
	    pgb->descent = nextSonY / 2;

	    return;
	    break;
	}
    }
}

/* static function not documented...
 */
static void
EmFillGBoxColCenter(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    GBox *pgbs;
    int nextSonY, boxWidth;

    switch (constraint) {
    case GBCNone:
    case GBCStrict:{
	    /* compute h w descent for each son box */
	    /* use it to find ascent, descent, h and  w for this box */
	    pgbs = pgb->pSon;
	    boxWidth = nextSonY = 0;
	    while (pgbs) {
		EmFillGBox(pg, pgbs, constraint, wx, wy, ww, wh, curx, nextSonY, sizeLevel);
		pgbs->y = nextSonY;
		nextSonY += pgbs->h;
		boxWidth = UMax(boxWidth, pgbs->w);
		pgbs = pgbs->pBrother;
	    }
	    pgb->h = nextSonY;
	    pgb->w = boxWidth;
	    pgb->descent = nextSonY / 2;

	    /* now able compute x shift for each box */
	    pgbs = pgb->pSon;
	    while (pgbs) {
		pgbs->x = (boxWidth - pgbs->w) / 2;
		pgbs = pgbs->pBrother;
	    }

	    return;
	    break;
	}
    }
}

/* static function not documented...
 */
static void
EmFillGBoxRoot(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    GBox *pgbSon, *pgbRootSymb;
    XFontStruct *pfs;
    int fontHeight, vclear, hclear, wroot;

    pfs = EmFindFont(pg, pgb->pn, "body", sizeLevel);
    fontHeight = pfs->ascent + pfs->descent;
    vclear = UMax(fontHeight / EM_GB_ROOT_VCLEAR_RATIO, 1);
    hclear = UMax(fontHeight / EM_GB_ROOT_HCLEAR_RATIO, 1);
    wroot = fontHeight / EM_GB_ROOT_WSL_RATIO + fontHeight / EM_GB_ROOT_WBL_RATIO;	/* no opt */
    pgbRootSymb = pgb->pSon;
    pgbSon = pgbRootSymb->pBrother;
    EmFillGBox(pg, pgbSon, constraint, wx, wy, ww, wh, curx, cury, sizeLevel);

    pgb->h = pgbSon->h + 2 * vclear;
    pgb->w = pgbSon->w + hclear + wroot;
    pgb->descent = pgbSon->descent + vclear;

    pgbSon->x = hclear + wroot;
    pgbSon->y = vclear;

    pgbRootSymb->x = pgbRootSymb->y = 0;
    pgbRootSymb->w = pgb->w;
    pgbRootSymb->h = pgb->h;

    return;
}

/* static function not documented...
 */
static void
EmFillGBoxContainer(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    GBox *pgbSon;

    pgbSon = pgb->pSon;
    EmFillGBox(pg, pgbSon, constraint, wx, wy, ww, wh, curx, cury, sizeLevel);
    pgbSon->x = pgbSon->y = 0;
    pgb->w = pgbSon->w;
    pgb->h = pgbSon->h;
    pgb->descent = pgbSon->descent;
}

/* static function not documented...
 */
static void
EmFillGBoxIndexAux(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel, GBox * pgbInd)
{
    GBox *pgbBody;
    int oldAscent, fracAscent;

    pgbBody = pgb->pSon;
    pgb->w = UMax(pgb->w, pgbInd->w + pgbBody->w);
    pgbInd->x = pgbBody->w;
    switch (pgbInd->type) {
    case GBUp:{
	    pgb->h = UMax(GBAscent(pgb), GBAscent(pgbBody) + GBAscent(pgbInd)) + pgb->descent;
	    pgbBody->y = GBAscent(pgb) - GBAscent(pgbBody);
	    break;
	}
    case GBDown:{
	    oldAscent = GBAscent(pgb);
	    fracAscent = 0.33 * GBAscent(pgbInd);
	    pgb->descent = UMax(pgb->descent, UMax(pgbBody->descent, fracAscent + pgbInd->descent));
	    pgb->h = oldAscent + pgb->descent;
	    break;
	}
    default:{
	    UIError("EmFillGBoxIndexAux", "unknown indice type %d", pgbInd->type);
	    break;
	}
    }
}

/* static function not documented...
 */
static void
EmFillGBoxIndex(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    GBox *pgbBody, *pgbInd1, *pgbInd2;

    pgbBody = pgb->pSon;
    EmFillGBox(pg, pgbBody, constraint, wx, wy, ww, wh, curx, cury, sizeLevel);
    pgb->h = pgbBody->h;
    pgb->descent = pgbBody->descent;
    pgbInd1 = pgbBody->pBrother;
    EmFillGBox(pg, pgbInd1, constraint, wx, wy, ww, wh, curx + pgbBody->w, cury, sizeLevel + 1);

    EmFillGBoxIndexAux(pg, pgb, constraint, wx, wy, ww, wh, curx, cury, sizeLevel + 1, pgbInd1);

    /* ?? TODO generalize to more than 2 indices */
    if (pgbInd2 = pgbInd1->pBrother) {
	assert(pgbInd2->pBrother == NULL);
	EmFillGBox(pg, pgbInd2, constraint, wx, wy, ww, wh, curx + pgbBody->w, cury, sizeLevel + 1);
	EmFillGBoxIndexAux(pg, pgb, constraint, wx, wy, ww, wh, curx, cury, sizeLevel + 1, pgbInd2);
    }

    /* fill the y fields of indices boxes linked with this body */
    pgbInd1 = pgbBody->pBrother;
    while (pgbInd1) {
	switch (pgbInd1->type) {
	case GBUp:
	    pgbInd1->y = GBAscent(pgb) - GBAscent(pgbBody) - GBAscent(pgbInd1);
	    break;
	case GBDown:
	    pgbInd1->y = GBAscent(pgb) - 0.66 * GBAscent(pgbInd1);
	    break;
	}
	pgbInd1 = pgbInd1->pBrother;
    }
    return;
}

/* static function not documented...
 */
static void
EmFillGBoxSymb(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    /* ?? TODO: make it font size dependant */
    switch (constraint) {
	case GBCHeightFixed:{
	    pgb->w = pgb->h / 5;
	    pgb->x = pgb->y = 0;
	    return;
	    break;
	}
    case GBCBad:
    default:{
	    UIError("EmFillGBoxSymb", "unknown constraint %d", constraint);
	    return;
	}
    }
}

/* static function not documented...
 */
static void
EmFillGBoxMultSymb(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    GBox cgbTmp;
    char plusChar = '+';

    switch (constraint) {
    case GBCNone:
    case GBCStrict:{
	    EmFillGBoxCharAux(pg, pgb,
			      &plusChar,
			      EmFindFont(pg, pgb->pn, "body", sizeLevel));
	    return;
	    break;
	}
    case GBCBad:
    default:{
	    UIError("EmFillGBoxMultSymb", "unknown constraint %d", constraint);
	    return;
	}
    }
}

/* static function not documented...
 */
static void
EmFillGBoxDiv(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    GBox *pgbUp, *pgbLine, *pgbBot, gbTmp;
    int nextSonY, boxWidth;
    char plusChar = '+';

    switch (constraint) {
    case GBCNone:
    case GBCStrict:{
	    pgbUp = pgb->pSon;
	    pgbLine = pgbUp->pBrother;
	    pgbBot = pgbLine->pBrother;
	    EmFillGBox(pg, pgbUp, constraint, wx, wy, ww, wh, curx, cury, sizeLevel);
	    EmFillGBox(pg, pgbLine, constraint, wx, wy, ww, wh, curx, cury + pgbUp->h, sizeLevel);
	    EmFillGBox(pg, pgbBot, constraint, wx, wy, ww, wh, curx, cury + pgbUp->h + pgbLine->h, sizeLevel);
	    boxWidth = UMax(pgbUp->w, pgbBot->w) + 2;

	    pgbUp->x = (boxWidth - pgbUp->w) / 2 + 1;
	    pgbUp->y = 0;

	    pgbLine->w = boxWidth;
	    pgbLine->x = 1;
	    pgbLine->y = pgbUp->h;

	    pgbBot->x = (boxWidth - pgbBot->w) / 2 + 1;
	    pgbBot->y = pgbUp->h + pgbLine->h;


	    pgb->h = pgbUp->h + pgbLine->h + pgbBot->h;
	    pgb->w = boxWidth + 2;
	    /*
	     * find the descent correction to apply if we want + aligned on _
	     * of fractions 
	     */
	    EmFillGBoxCharAux(pg, &gbTmp,
			      &plusChar,
			      EmFindFont(pg, pgb->pn, "body", sizeLevel));
	    pgb->descent = pgbBot->h + pgbLine->descent - (gbTmp.h / 2);

	    return;
	    break;
	}
    }
}

/* static function not documented...
 */
static void
EmFillGBoxVector(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    UNI;
}

/* static function not documented...
 */
static void
EmFillGBoxMatrix(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    GBox *pgbRow, *pgbCol, *pgbSymb;
    int nextColX, nextRowY, rowAscent, rowDescent, nbRow, row, sr;
    XFontStruct *pfs;
    int fontHeight, vclear, hclear;

    pfs = EmFindFont(pg, pgb->pn, "body", sizeLevel);
    fontHeight = pfs->ascent + pfs->descent;
    vclear = UMax(fontHeight / EM_GB_MATRIX_VCLEAR_RATIO, 1);
    hclear = UMax(fontHeight / EM_GB_MATRIX_HCLEAR_RATIO, 1);

    switch (constraint) {
    case GBCNone:
    case GBCStrict:{
	    /*
	     * compute maximum width (use fillbox for vectors ie: colcenter)
	     * for each Column 
	     */
	    pgbCol = pgb->pSon;
	    nextColX = hclear;
	    /* avoid the two embeding symbols () */
	    pgbCol = ((GBox *) (pgbCol->pBrother))->pBrother;
	    while (pgbCol) {
		EmFillGBox(pg, pgbCol, constraint, wx, wy, ww, wh, nextColX, cury, sizeLevel);
		pgbCol->y = 0;
		nextColX += pgbCol->w + hclear;
		pgbCol = pgbCol->pBrother;
	    }

	    /*
	     * compute maximum height for each row and put y for each cell in
	     * row 
	     */
	    nextRowY = vclear;
	    nbRow = ((GBox *) (pgb->pSon))->pn->nbsn;
	    /* for each row */
	    for (row = 0; row < nbRow; row++) {
		pgbCol = pgb->pSon;
		assert(pgbCol->pn->nbsn == nbRow);
		/* avoid the two embeding symbols () */
		pgbCol = ((GBox *) (pgbCol->pBrother))->pBrother;
		rowDescent = rowAscent = 0;
		/* find max height for each row */
		while (pgbCol) {
		    sr = 0;
		    pgbRow = pgbCol->pSon;
		    /* find the right cell in column (ie row'th) */
		    while (pgbRow && (sr++ < row)) {
			pgbRow = pgbRow->pBrother;
		    }
		    rowDescent = UMax(rowDescent, pgbRow->descent);
		    rowAscent = UMax(rowAscent, pgbRow->h - pgbRow->descent);
		    pgbCol = pgbCol->pBrother;
		}
		/* put y field in each cell of this row */
		pgbCol = pgb->pSon;
		pgbCol = ((GBox *) (pgbCol->pBrother))->pBrother;
		/* for each column */
		while (pgbCol) {
		    sr = 0;
		    pgbRow = pgbCol->pSon;
		    /* find the right cell in column (ie row'th) */
		    while (pgbRow && (sr++ < row)) {
			pgbRow = pgbRow->pBrother;
		    }
		    pgbRow->y = nextRowY + (rowAscent - (pgbRow->h - pgbRow->descent));
		    pgbCol = pgbCol->pBrother;
		}
		nextRowY += rowAscent + rowDescent + vclear;
	    }

	    /* compute the sizes of embeding symbols () fill their x field */
	    pgbSymb = pgb->pSon;
	    pgbSymb->h = nextRowY;
	    EmFillGBox(pg, pgbSymb, GBCHeightFixed, wx, wy, ww, wh, curx, cury, sizeLevel);
	    pgbSymb->x = 0;
	    nextColX = pgbSymb->w + hclear;

	    pgbCol = pgb->pSon;
	    pgbCol = ((GBox *) (pgbCol->pBrother))->pBrother;
	    while (pgbCol) {
		pgbCol->x = nextColX;
		pgbCol->h = nextRowY;	/* column hight has changed due to
					 * alignment of rows */
		nextColX += pgbCol->w + hclear;
		pgbCol = pgbCol->pBrother;
	    }

	    pgbSymb = pgbSymb->pBrother;
	    pgbSymb->h = nextRowY;
	    EmFillGBox(pg, pgbSymb, GBCHeightFixed, wx, wy, ww, wh, curx, cury, sizeLevel);
	    pgbSymb->x = nextColX;
	    nextColX += pgbSymb->w;

	    pgb->w = nextColX;
	    pgb->h = nextRowY;
	}
    }
}


/* static function not documented...
 */
static void
EmFillGBoxTemplate(EmGroup * pg, GBox * pgb, EmFillConstraint constraint, int wx, int wy, short ww, short wh, int curx, int cury, Byte sizeLevel)
{
    char c = '?';

    return EmFillGBoxCharAux(pg, pgb,
			     &c,
			     EmFindFont(pg, pgb->pn, "body", sizeLevel));

}

/* Fill fields descent,w,h for this box and all its descendants
 */
/* ??TODO add yield */
void
EmFillGBox(EmGroup * pg /* Group to use for attribs */ ,
	   GBox * pgb /* Root box for filled tree */ ,
	   EmFillConstraint constraint	/* Kind of constraint for geometry
	       managment */ ,
	   int wx			/* X position of the output window in
	       the virtual formula window */ ,
	   int wy			/* Y position of the output window in
	       the virtual formula window */ ,
	   short ww			/* Width dimesion of the output
					 * window in the virtual formula
	       window */ ,
	   short wh			/* Height dimesion of the output
					 * window in the virtual formula
	       window */ ,
	   int curx			/* X position (or default
					 * approximation) of the ul of this
					 * box relatively to the virtual
	       formula window */ ,
	   int cury			/* Y position (or default
					 * approximation) of the ul of this
					 * box relatively to the virtual
	       formula window */ ,
	   Byte sizeLevel)
{
    EmFillGBoxFuncType pf;
    EmNode *pn;


    if ((!EmGBRefillP(pgb)) || (cury > wy + wh))
	return;

    pn = pgb->pn;
    switch (pgb->type) {
    case GBChar:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBCharFill"));
	    break;
	}
    case GBSymb:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBSymbFill"));
	    break;
	}
    case GBHLine:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBHLineFill"));
	    break;
	}
    case GBRootSymb:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBRootSymbFill"));
	    break;
	}
    case GBMultSymb:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBMultSymbFill"));
	    break;
	}
    case GBRoot:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBRootFill"));
	    break;
	}
    case GBDiv:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBDivFill"));
	    break;
	}
    case GBUMinus:
    case GBRowCut:
    case GBRow:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBRowCutFill"));
	    break;
	}
    case GBIndex:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBIndexFill"));
	    break;
	}
    case GBColCenter:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBColCenterFill"));
	    break;
	}
    case GBColLeft:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBColLeftFill"));
	    break;
	}
    case GBVector:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBVectorFill"));
	    break;
	}
    case GBMatrix:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBMatrixFill"));
	    break;
	}
    case GBTemplate:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBTemplateFill"));
	    break;
	}
	/* containers which bound tightly their only son */
    case GBContainer:
    case GBUp:
    case GBDown:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBContainerFill"));
	    break;
	}
    case GBBad:
    default:
	UIError("EmFillGBox", "unknown node-type %d", pgb->type);
    }

    pf(pg, pgb, constraint, wx, wy, ww, wh, curx, cury, sizeLevel);
    EmGBRefillF(pgb);
    return;
}

/* Must fill all default attributes concerning filling of GBoxes.
 */
void
EmGBoxFDAFill(EmGroup * pg /* Group to fill */ ,
	      EmNode * pn /* Node to fill */ )
{
    EmASetC(pg, pn, "GBRowCutFill", KlNumPointerMake(EmFillGBoxRowCut));
    EmASetC(pg, pn, "GBDivFill", KlNumPointerMake(EmFillGBoxDiv));
    EmASetC(pg, pn, "GBHLineFill", KlNumPointerMake(EmFillGBoxHLine));
    EmASetC(pg, pn, "GBCharFill", KlNumPointerMake(EmFillGBoxChar));
    EmASetC(pg, pn, "GBSymbFill", KlNumPointerMake(EmFillGBoxSymb));
    EmASetC(pg, pn, "GBMultSymbFill", KlNumPointerMake(EmFillGBoxMultSymb));
    EmASetC(pg, pn, "GBRootFill", KlNumPointerMake(EmFillGBoxRoot));
    EmASetC(pg, pn, "GBIndexFill", KlNumPointerMake(EmFillGBoxIndex));
    EmASetC(pg, pn, "GBColCenterFill", KlNumPointerMake(EmFillGBoxColCenter));
    EmASetC(pg, pn, "GBColLeftFill", KlNumPointerMake(EmFillGBoxColLeft));
    EmASetC(pg, pn, "GBVectorFill", KlNumPointerMake(EmFillGBoxVector));
    EmASetC(pg, pn, "GBMatrixFill", KlNumPointerMake(EmFillGBoxMatrix));
    EmASetC(pg, pn, "GBContainerFill", KlNumPointerMake(EmFillGBoxContainer));
    EmASetC(pg, pn, "GBTemplateFill", KlNumPointerMake(EmFillGBoxTemplate));

}
