#include "emall.h"

/**************************************************************** Prototypes */

/* static function not documented...
 */
static void 
EmDrawGBoxHLine(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmDrawGBoxRootSymb(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmDrawGBoxChar(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel);

/* static function not documented...
 */
static void 
EmDrawGBoxSymb(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel);

/******************************************************************** Bodies */

/* static function not documented...
 */
static void
EmDrawGBoxHLine(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel)
{
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc, fulx + pgb->x, fuly + GBAscent(pgb) + pgb->y, fulx + pgb->x + pgb->w, fuly + GBAscent(pgb) + pgb->y);
}

/* static function not documented...
 */
static void
EmDrawGBoxRootSymb(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel)
{
    XFontStruct *pfs;
    int fontHeight, wsl, wbl;

    pfs = EmFindFont(pg, pgb->pn, "body", sizeLevel);
    fontHeight = pfs->ascent + pfs->descent;
    wsl = fontHeight / EM_GB_ROOT_WSL_RATIO;
    wbl = fontHeight / EM_GB_ROOT_WBL_RATIO;
    /* small line (\) */
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x, fuly + pgb->y + pgb->h - wsl,
	      fulx + pgb->x + wsl, fuly + pgb->y + pgb->h);
    /* big line (/) */
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x + wsl, fuly + pgb->y + pgb->h,
	      fulx + pgb->x + wsl + wbl, fuly + pgb->y);
    /* straight hat (_) */
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x + wsl + wbl, fuly + pgb->y,
	      fulx + pgb->x + pgb->w, fuly + pgb->y);

};


/* static function not documented...
 */
static void
EmDrawGBoxMultSymb(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel)
{
    int sz;

    sz = UMin(pgb->w - 4, pgb->h - pgb->descent - 4);
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x + (pgb->w - sz) / 2,
	      fuly + pgb->y + (pgb->h - sz) / 2,
	      fulx + pgb->x + (pgb->w + sz) / 2,
	      fuly + pgb->y + (pgb->h + sz) / 2);
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x + (pgb->w - sz) / 2,
	      fuly + pgb->y + (pgb->h + sz) / 2,
	      fulx + pgb->x + (pgb->w + sz) / 2,
	      fuly + pgb->y + (pgb->h - sz) / 2);
}

/* static function not documented...
 */
static void
EmDrawGBoxChar(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel)
{
    GC gc;

    gc = EmFontToGC(pg, ptd,
		    EmFindFont(pg, pgb->pn, "body", sizeLevel),
	      (Pixel *) KlNumToPtr(EmAGetC(pg, pgb->pn, "body-font-color")),
		  (Pixel *) KlNumToPtr(EmAGetC(pg, pgb->pn, "background")));
    XDrawString(ptd->dpy, (Drawable) ptd->win, gc,
		(unsigned int) (fulx + pgb->x),
		(unsigned int) (fuly + pgb->y + pgb->h - pgb->descent),
		(char *) pgb->pVal, 1);

}

/* static function not documented...
 */
static void
EmDrawGBoxSymb(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel)
{
    UNIW;
}

/* static function not documented...
 */
static void
EmDrawGBoxTemplate(EmGroup * pg, GBox * pgb, Td * ptd, int wx, int wy, short ww, short wh, int fulx, int fuly, Byte sizeLevel)
{
    GC gc;
    char c = '?';

    gc = EmFontToGC(pg, ptd,
		    EmFindFont(pg, pgb->pn, "body", sizeLevel),
	      (Pixel *) KlNumToPtr(EmAGetC(pg, pgb->pn, "body-font-color")),
		  (Pixel *) KlNumToPtr(EmAGetC(pg, pgb->pn, "background")));
    XDrawString(ptd->dpy, ptd->win, gc,
		fulx + pgb->x, fuly + pgb->y + pgb->h - pgb->descent,
		&c, 1);
}

/* Draw this box and all its descendants.
 * ?? TODO: add yield
 */
void
EmDrawGBox(EmGroup * pg /* Group to use for attribs */ ,
	   GBox * pgb /* Root box for filled tree */ ,
	   Td * ptd /* Pointer to window/thread structure */ ,
	   int wx			/* X position of the output window in
	       the virtual formula window */ ,
	   int wy			/* Y position of the output window in
	       the virtual formula window */ ,
	   short ww			/* Width dimension of the output
					 * window in the virtual formula
	       window */ ,
	   short wh			/* Height dimension of the output
					 * window in the virtual formula
	       window */ ,
	   int fulx			/* X position of the ul corner of
					 * father-box relatively to the
	       virtual formula window */ ,
	   int fuly			/* Y position of the ul corner of
					 * father-box relatively to the
	       virtual formula window */ ,
	   Byte sizeLevel)
{
    EmDrawGBoxFuncType pf;
    EmNode *pn, *pcn;
    GBox *pgbs;

#ifdef TEST_THREAD_OVERFLOW
    EmTpCheckStackOverflow(ptd);
#endif
    /* box is not in the output window */
    if ((fuly > wy + wh) || ((fuly + pgb->h) < wy) ||
	(fulx > wx + ww) || (fulx + pgb->w < wx))
	return;

    pn = pgb->pn;

    if (KlCTrueP(EmAGetC(pg, pn, "draw-box"))) {
	XDrawRectangle(ptd->dpy, ptd->win, ptd->fgc, fulx + pgb->x - wx, fuly + pgb->y - wy, pgb->w, pgb->h);
    }

    if (KlCTrueP(EmAGetC(pg, pn, "draw-diag"))) {
	if (pgb->pn->nbsn)
	    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
		      fulx + pgb->x - wx,
		      fuly + pgb->y - wy,
		      fulx + pgb->x + pgb->w - wx,
		      fuly + pgb->y + pgb->h - wy);
	else
	    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
		      fulx + pgb->x + pgb->w - wx,
		      fuly + pgb->y - wy,
		      fulx + pgb->x - wx,
		      fuly + pgb->y + pgb->h - wy);
	pgbs = pgb->pSon;
    }

    pcn = KlNumToPtr(EmAGetC(pg, (EmNode *) NULL, "*current-node*"));;
    if (pn == pcn) {
	XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
		  fulx + pgb->x + pgb->w - wx, fuly + pgb->y - wy,
		  fulx + pgb->x + pgb->w - wx, fuly + pgb->y + pgb->h - wy);
    }

    switch (pgb->type) {
	/* leafs */
    case GBSymb:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBSymbDraw"));
	    pf(pg, pgb, ptd, wx, wy, ww, wh, fulx, fuly, sizeLevel);
	    break;
	}
    case GBChar:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBCharDraw"));
	    pf(pg, pgb, ptd, wx, wy, ww, wh, fulx, fuly, sizeLevel);
	    break;
	}
    case GBHLine:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBHLineDraw"));
	    pf(pg, pgb, ptd, wx, wy, ww, wh, fulx, fuly, sizeLevel);
	    break;
	}
    case GBRootSymb:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBRootSymbDraw"));
	    pf(pg, pgb, ptd, wx, wy, ww, wh, fulx, fuly, sizeLevel);
	    break;
	}
    case GBMultSymb:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBMultSymbDraw"));
	    pf(pg, pgb, ptd, wx, wy, ww, wh, fulx, fuly, sizeLevel);
	    break;
	}
    case GBTemplate:{
	    pf = KlNumToPtr(EmAGetC(pg, pn, "GBTemplateDraw"));
	    pf(pg, pgb, ptd, wx, wy, ww, wh, fulx, fuly, sizeLevel);
	    break;
	}
	/* non leaf boxes with size change */
    case GBUp:
    case GBDown:{
	    pgbs = pgb->pSon;
	    while (pgbs) {
		EmDrawGBox(pg, pgbs, ptd, wx, wy, ww, wh, fulx + pgb->x, fuly + pgb->y, sizeLevel + 1);
		pgbs = pgbs->pBrother;
	    }
	    break;
	}
	/* non leaf boxes without size change */
    case GBContainer:
    case GBUMinus:
    case GBIndex:
    case GBRow:
    case GBRowCut:
    case GBColLeft:
    case GBColCenter:
    case GBDiv:
    case GBRoot:
    case GBVector:
    case GBMatrix:{
	    pgbs = pgb->pSon;
	    while (pgbs) {
		EmDrawGBox(pg, pgbs, ptd, wx, wy, ww, wh, fulx + pgb->x, fuly + pgb->y, sizeLevel);
		pgbs = pgbs->pBrother;
	    }
	    break;
	}
    case GBBad:
    default:
	UIError("EmDrawGBox", "unknown node-type %d", pgb->type);
    }
}



/* Must fill all default attributes concerning drawing of GBoxes.
 */
void
EmGBoxFDADraw(EmGroup * pg /* Group to fill */ ,
	      EmNode * pn /* Node to fill */ )
{

    EmASetC(pg, pn, "GBCharDraw", KlNumPointerMake(EmDrawGBoxChar));
    EmASetC(pg, pn, "GBHLineDraw", KlNumPointerMake(EmDrawGBoxHLine));
    EmASetC(pg, pn, "GBSymbDraw", KlNumPointerMake(EmDrawGBoxSymb));
    EmASetC(pg, pn, "GBRootSymbDraw", KlNumPointerMake(EmDrawGBoxRootSymb));
    EmASetC(pg, pn, "GBMultSymbDraw", KlNumPointerMake(EmDrawGBoxMultSymb));
    EmASetC(pg, pn, "GBTemplateDraw", KlNumPointerMake(EmDrawGBoxTemplate));
}
