#include "emall.h"

/**************************************************************** Prototypes */

/* init all emath modules
 */
static void 
EmAllModulesInit(void);

/* init the server
 */
static void 
EmEmathInit(void);

/******************************************************************** Bodies */
/* */

/* init all emath modules
 */
static void
EmAllModulesInit(void)
{
    EmXInit();
    EmEventInit();
    EmTpInit();
    EmTreeInit();
    EmAttribInit();
    EmGroupInit();
    EmRecordInit();
    EmCommInit();
    EmCacheInit();
    EmResInit();
    EmGBoxInit();
    EmKlInit();
    EmSelectionInit();
}


/* plug a set of default attributes in the rootgroup
 */
void
EmFillDefaultAttributes(void)
{
    EmGBoxFDA(EmRootGroup, NULL);
}


/* init the server
 */
static void
EmEmathInit(void)
{
    KlPath = "../Klone/kl:.";
    KlInit();
    EmAllModulesInit();
}

/* the main procedure of the server
 * the main loop of event handling is written in klone and started
 * with the load emath.kl
 */
int
main(int argc, char **argv)
{
    /* do all internal C inits */
    EmEmathInit();

    /* wait for a new client and fork a new server per client */
    KlExecuteStringNoReturn("(load \"emforker.kl\")");
    /* so here we are in a forked process dedicated to one client */
    /* load all klone modules */
    KlExecuteStringNoReturn("(load \"emath.kl\")");
    /* initialize server */
    return 0;
}
